@extends('layouts.user.focused')

@section('content')

<div class="main-content">

    <div class="task-choose bg-img" style="background-image: url({{asset('common/img/login-bg.jpg')}});">

        <div class="task-choose-outer">

            <div class="task-choose-inner white-bg">

                <a class="task-logo" href="{{route('home')}}">
                    <div class="bg-img logo" style="background-image: url({{Setting::get('site_logo')}});"></div>

                </a>

                @include('notification.notify')

                <form class="login-form" role="form" method="POST" action="{{ url('/provider/password/reset') }}">

                    {{ csrf_field() }}

                        <input type="hidden" name="token" value="{{ $token }}">

                        <div class="form-group{{ $errors->has('email') ? ' has-error' : '' }}">
                            <label for="email">{{tr('email')}}</label>
                            <input type="email" id="email" type="email" placeholder="{{tr('enter_your_email')}}" required="" name="email" value="{{ $email or old('email') }}" aria-describedby="emailHelp" class="form-control"  >
                            @if ($errors->has('email'))
                                <span class="help-block">
                                    <strong>{{ $errors->first('email') }}</strong>
                                </span>
                            @endif
                        </div>

                        <div class="form-group{{ $errors->has('password') ? ' has-error' : '' }}">

                            <label for="password">{{tr('password')}}</label>

                            <input id="password" type="password" placeholder="{{tr('enter_your_password')}}" required="" name="password" value="{{ $password or old('password') }}" aria-describedby="password" class="form-control"  >

                            @if ($errors->has('password'))
                                <span class="help-block">
                                    <strong>{{ $errors->first('password') }}</strong>
                                </span>
                            @endif
                            
                        </div>

                        <div class="form-group{{ $errors->has('password_confirmation') ? ' has-error' : '' }}">

                            <label for="password_confirmation">{{tr('password_confirmation')}}</label>

                            <input  id="password_confirmation" type="password" placeholder= "{{tr('enter_your_confirm_password')}}" required="" name="password_confirmation" value="{{ $password_confirmation or old('password_confirmation') }}" aria-describedby="password Confirmation" class="form-control" >

                            @if ($errors->has('password_confirmation'))
                                <span class="help-block">
                                    <strong>{{ $errors->first('password_confirmation') }}</strong>
                                </span>
                            @endif

                        </div>

                        <button type="submit" class="btn btn-primary sub-btn">{{tr('submit')}}</button>

                </form>
            </div>

        </div>
        
    </div>
</div>

@endsection
