@extends('layouts.user.focused')

@section('content')

<div class="main-content">

    <div class="task-choose bg-img" style="background-image: url({{asset('common/img/login-bg.jpg')}});">

        <div class="task-choose-outer">

            <div class="task-choose-inner white-bg">

                <a class="task-logo" href="{{route('home')}}">
                    <div class="bg-img logo" style="background-image: url({{Setting::get('site_logo')}});"></div>
                </a>

                @include('notification.notify')

                <form class="login-form" action="{{route('provider.register.save')}}" role="form" method="POST">

                    <input type="hidden" name="timezone" value="" id="userTimezone">

                    <input type="hidden" name="device_type" value="{{DEVICE_WEB}}">

                    <div class="form-group @if ($errors->has('name')) has-error @endif">

                        <label for="name">{{tr('name')}}</label>

                        <input type="text" id="name" required class="form-control" value="{{ old('name') }}" name="name" placeholder="{{tr('enter_name')}}">

                        @if ($errors->has('name')) <p class="help-block">{{ $errors->first('name') }}</p> @endif
                        
                    </div>

                    <div class="form-group @if ($errors->has('email')) has-error @endif">
                        <label for="email">{{tr('email')}}</label>
                        <input type="text" id="email" required class="form-control" value="{{ old('email') }}" name="email" placeholder="{{tr('enter_email')}}">
                        @if ($errors->has('email')) <p class="help-block">{{ $errors->first('email') }}</p> @endif
                    </div>

                    <div class="form-group @if ($errors->has('password')) has-error @endif">
                        <label for="password">{{tr('password')}}</label>
                        <input type="password" id="password" required class="form-control" name="password"  placeholder="{{tr('enter_password')}}">
                        @if ($errors->has('password')) <p class="help-block">{{ $errors->first('password') }}</p> @endif
                    </div>

                    <div class="form-group @if ($errors->has('password_confirmation')) has-error @endif">

                        <label for="password_confirmation">{{tr('confirm_password')}}</label>

                        <input type="password" id="password_confirmation" required class="form-control" name="password_confirmation"  placeholder="{{tr('confirm_password')}}">
                        @if ($errors->has('password_confirmation')) <p class="help-block">{{ $errors->first('password_confirmation') }}</p> @endif
                    </div>

                    <button type="submit" class="btn btn-primary sub-btn">{{tr('submit')}}</button>

                    <p class="login-txt btm-txt text-center">{{tr('already_have_account')}} <a href="{{route('provider.login.form')}}" class="common-link">{{tr('login')}}</a></p>
                    
                    <p class="login-txt btm-txt text-center">{{tr('signup_agree')}} 
                    <a target="_blank" href="{{route('terms')}}" class="common-link">{{tr('terms')}}</a> {{tr('and')}} 
                    <a target="_blank" href="{{route('privacy')}}" class="common-link">{{tr('privacy')}}</a></p>
                
                </form>

            </div>

        </div>
        
    </div>
</div>


@endsection

@section('scripts')
<script src="{{asset('common/js/jstz.min.js')}}"></script>
<script>
    
    $(document).ready(function() {

        var dMin = new Date().getTimezoneOffset();
        var dtz = -(dMin/60);
        // alert(dtz);
        $("#userTimezone").val(jstz.determine().name());
    });

    $('form').submit(function () {
        $(this).find(':submit').attr('disabled', 'disabled');
    });

</script>
@endsection
