@foreach($bidded_requests as $pr => $bidded_request)

	<div class="dashboard-list row m-0 create-job-shadow">

		<!-- Dashboard-list-box -->
		<div class="dashboard-list-col col-lg-4 col-md-5 col-sm-5 col-xs-12">
			<div class="dashboard-list-box">
				<h3 class="dashboard-list-tit truncate">{{$bidded_request->name}}</h3>
				<p class="dashboard-list-txt">
					<span><b>{{tr('created')}} : </b> {{$bidded_request->request_date}} </span>
				</p>
			</div>
		</div>
		<!-- End of dashboard-list-box -->

		<!-- Dashboard-list-box -->
		<div class="dashboard-list-col col-lg-3 col-md-2 col-sm-2 col-xs-12">
			<div class="dashboard-list-box">
				<p class="dashboard-list-txt">
					<i class="ion-arrow-graph-up-left"></i> 
					{{$bidded_request->category_name}}
				</p>
				<p class="dashboard-list-txt">
					<i class="ion-arrow-graph-down-left"></i> 
					{{request_type($bidded_request->request_type)}}
				</p>
			</div>
		</div>
		<!-- End of dashboard-list-box -->

		<?php $requests_meta = get_requests_meta($bidded_request->request_id , Auth::guard('provider')->user()->id); ?>


		<!-- Dashboard-list-box -->
		<div class="dashboard-list-col col-lg-2 col-md-2 col-sm-3 col-xs-12">
			<div class="dashboard-list-box">
				<p class="dashboard-list-txt m-t-20">
				 	<i class="fa fa-money"></i>
				 	@if($requests_meta)

				 		{{$bidded_request->currency}}{{$requests_meta->bid_amount}}{{$requests_meta->price_per_symbol}}

				 	@endif
				</p>
			</div>
		</div>
		<!-- End of dashboard-list-box -->

		<!-- Dashboard-list-box -->
		<div class="dashboard-list-col col-lg-3 col-md-3 col-sm-2 col-xs-12">

			<div class="dashboard-list-box m-t-15">

				@if($requests_meta)

					@if($requests_meta->status == REQUEST_META_ASSIGNED)

						<form class="job-form" action="{{route('provider.requests.confirm')}}" method="POST">

							<input type="hidden" name="request_id" value="{{$bidded_request->request_id}}" >

							<button type="submit" class="btn btn-success" class="" onclick="return confirm(&quot;{{tr('are_you_sure')}}&quot;);">{{tr('confirm')}}</button>

						</form>

						<form class="job-form" action="{{route('provider.requests.cancel')}}" method="POST">

							<input type="hidden" name="request_id" value="{{$bidded_request->request_id}}" >

							<button type="submit" class="btn btn-danger" class="" onclick="return confirm(&quot;{{tr('are_you_sure')}}&quot;);">{{tr('reject')}}</button>

						</form>
					@else

						

					@endif

				@endif

				<a href="{{route('provider.requests.view' , ['request_unique_id' => $bidded_request->unique_id])}}" class="btn btn-warning">

					{{tr('view')}}
				</a>									
			</div>
		</div>
		<!-- End of dashboard-list-box -->
	</div>

@endforeach