@extends('layouts.provider')

@section('after-styles')

@endsection

@section('content')

<div class="content-wrap gray-bg">

	<div class="container">
		
        <div class="chat white-bg m-30 p-f-30 row">
			<div class="row m-0">
            
				<h3 class="chat-tit pull-left">{{$request_details->name}}</h3>

				<a href="{{request()->headers->get('referer')}}" class="common-bg-link pull-right back-btn">{{tr('back')}}</a>
			</div>

			<div class="chat-sec-left-col col-lg-5 col-md-5 col-sm-12 col-xs-12">
				<div class="chat-sec-left">
					<div class="incoming-img bg-img" style="background-image: url({{$request_details->user->picture}});">
			        </div>
					<div class="table-responsive incoming-table">
						<table class="table table-responsive">
							<thead>
								<tr>
									<th>{{tr('name')}}</th>
									<th>{{$request_details->user->name}}</th>
								</tr>
							</thead>
							<tbody>
								<tr>
									<th scope="row">{{tr('job_type')}}</th>
									<td>{{job_type($request_details->job_type)}}</td>
								</tr>
								<tr>
									<th scope="row">{{tr('request_type')}}</th>
									<td>{{request_type($request_details->request_type)}}</td>
								</tr>
								<tr>
									<th scope="row">{{tr('category')}}</th>
									<td>{{$request_details->category->name}}</td>
								</tr>
								
								<tr>
									<th scope="row">{{tr('initial_per_hour_price')}}</th>
									<td>{{$request_details->currency}}{{$request_details->user_price}}{{$request_details->price_per_symbol}}</td>
								</tr>

								<tr>
									<th scope="row">{{tr('price_per_hour')}}</th>
									<td>{{$request_details->currency}}{{$request_details->price_per_hour}}{{$request_details->price_per_symbol}}</td>
								</tr>
							</tbody>
						</table>
					</div>
				</div>
			</div>

			<div class="chat-sec-right-col col-lg-7 col-md-7 col-sm-12 col-xs-12">
				<div class="chat-sec">
					<div class="chat-head row m-0">
						<!-- <span class="chat-img bg-img" style="background-image: url({{asset('common/img/user1.jpg')}});">
						</span> -->
						<span>Chat with {{$user->name}}</span>
					</div>

                    @if(count($messages) > 0)

    					<div class="chat-content row m-0">

    						<div class="chat-content-inner" id="chat-box">

    							<!-- Chat message will appear here -->
    						
    						</div>

    						<div class="input-group send-msg">

    						  <input type="text" class="form-control" placeholder="Type Here" aria-describedby="" id="chat-input">

    						  	<span class="input-group-addon" id="chat-send">
    						  		<i class="ion-android-send"></i>
    						  	</span>
    						</div>
    					</div>

                    @else
                        <p{{tr('provider_chat_initiate_error')}}></p>
                    @endif
				</div>
			</div>

		</div>
	
	</div>

</div>

@endsection

@section('after-scripts')

@if(count($messages) > 0)

    <script src="https://cdn.socket.io/socket.io-1.4.5.js"></script>

    <script src="https://cdn.socket.io/socket.io-1.4.5.js"></script>

    <script type="text/javascript">

        var defaultImage = "{{ asset('user_default.png') }}";
        var chatBox = document.getElementById('chat-box');
        var chatInput = document.getElementById('chat-input');
        var chatSend = document.getElementById('chat-send');

        var messageTemplate = function(data) {

        	var messageTemplate = '';

        	// Provider to user Message

        	if(data.type == 'up') {

        		messageTemplate = '<div class="chat-left text-left row m-0">';
        		messageTemplate += '<div class="chat-msg-left">';
        		messageTemplate += '<div class="chat-img bg-img" style="background-image: url(' + socketClient.user_picture +');"></div>';
        		messageTemplate += '</div>';
        		messageTemplate += '<div class="chat-msg-right">';
        		messageTemplate += '<p class="msg">'+data.message+'</p>';
        		messageTemplate += '</div>';
        		messageTemplate += '</div>';
        		messageTemplate += '</ br>';

        	} else {

        		messageTemplate = '<div class="row m-0">';
        		messageTemplate += '<div class="chat-right pull-right">';
        		messageTemplate += '<div class="chat-msg-left">';
        		messageTemplate += '<div class="chat-right-inner text-right">';
        		messageTemplate += '<p class="msg">'+data.message+'</p>';
        		messageTemplate += '</div>';
        		messageTemplate += '</div>';
        		messageTemplate += '</div>';
        		messageTemplate += '</div>';
        		messageTemplate += '</ br>';
        	
        	}

            return messageTemplate;
        }

        chatSockets = function () {

            this.socket = undefined;

            this.user_picture = "{{$request_details->user->picture}}";

            this.provider_picture = "{{ \Auth::guard('provider')->user()->picture }}" == "" ? defaultImage : "{{ \Auth::guard('provider')->user()->picture }}";
        }

        chatSockets.prototype.initialize = function() {
            
            this.socket = io('{{ Setting::get("SOCKET_SERVER") }}', { query: "myid=pu{{ Auth::guard('provider')->user()->id }}&reqid={{ $request_details->id }}" });

            this.socket.on('connection', function (data) {
                console.log("Connection"+this.socket.client);
            });

            this.socket.on('connected', function (data) {

                socketState = true;

                chatInput.enable();

                // console.log('Connected :: '+JSON.stringify(data));
                
            });

            this.socket.on('message', function (data) {

                console.log("New Message :: "+JSON.stringify(data));

                if(data.message) {

                    var pushstatusURL = "{{route('update.message.status')}}";

                    $.post(pushstatusURL, {
                        user_id: "{{$request_details->user_id}}",
                        provider_id: "{{Auth::guard('provider')->user()->id}}",
                        type: data.type,
                        request_id: "{{ $request_details->id }}"
                    },
                    function(data, status){
                        console.log("success Update")
                        // alert("Data: " + data + "\nStatus: " + status);
                    });

                    // chatBox.appendChild(messageTemplate(data));

                    $('#chat-box').append(messageTemplate(data));
                    
                    $(chatBox).animate({
                        scrollTop: chatBox.scrollHeight,
                    }, 500);
                    
                }
            
            });

            this.socket.on('disconnect', function (data) {

                // alert('client socketio disconnect!');
 
            });
        }

        chatSockets.prototype.sendMessage = function(data) {

            data = {};
            data.type = 'pu';
            data.message = text;
            data.user_id = "{{ $request_details->user_id }}";
            data.provider_id = "{{ \Auth::guard('provider')->user()->id }}";
            data.data_type = 'TEXT';
            data.status = 'sent';

            console.log("send message :: "+JSON.stringify(data));

            this.socket.emit('send message', data); 
        
        }

        socketClient = new chatSockets();
        
        socketClient.initialize();

        chatInput.enable = function() {
            // console.log('Chat Input Enable');
            this.disabled = false;
        };

        chatInput.clear = function() {
            // console.log('Chat Input Cleared');
            this.value = "";
        };

        chatInput.disable = function() {
            // console.log('Chat Input Disable');
            this.disabled = true;
        };

        chatInput.addEventListener("keyup", function (e) {
            if (e.which == 13) {
                sendMessage(chatInput);
                return false;
            }
        });

        chatSend.addEventListener('click', function() {
            sendMessage(chatInput);
        });
        

        function sendMessage(input) {
            text = input.value.trim();
            if(socketState && text != '') {

                message = {};
                message.type = 'pu';
                message.message = text;

                socketClient.sendMessage(text);
                // chatBox.appendChild(messageTemplate(message));

                $('#chat-box').append(messageTemplate(message));
                $(chatBox).animate({
                    scrollTop: chatBox.scrollHeight,
                }, 500);
                chatInput.clear();
            }
        }

        $.get('{{ route("provider.requests.chat") }}', {
            request_id: '{{ $request_details->id }}'
        })
        .done(function(response) {
            for (var i = (response.length - 10 >= 0 ? response.length - 10 : 0); i < response.length; i++) {
                // chatBox.appendChild(messageTemplate(response[i]));
                $('#chat-box').append(messageTemplate(response[i]));
                $(chatBox).animate({
                    scrollTop: chatBox.scrollHeight,
                }, 500);
            }
        })
        .fail(function(response) {
            // console.log(response);
        })
        .always(function(response) {
            // console.log(response);
        });

    </script>

@endif

@endsection