@extends('layouts.provider')

@section('after-styles')

<style>
	.truncate {
	  width: 15em;
	  white-space: nowrap;
	  overflow: hidden;
	  text-overflow: ellipsis;
	}
</style>

@endsection

@section('content')

	<div class="content-wrap gray-bg">

		<div class="container">

			@if(Auth::guard('provider')->user()->is_approved == PROVIDER_STATUS_PENDING)
		    
		        <div class="alert alert-danger text-uppercase" style="margin-top: 10px;">
		            {{tr('provider_waiting_for_admin_approval')}}
		        </div>

		    @endif

			@include('notification.notify')

			<div class="jobs white-bg m-30 p-f-30">
				<!-- jobs-head -->
				<div class="jobs-head row m-0">
					<ul class="nav nav-tabs job-tabs" role="tablist" id='tab'>
						
						<li role="presentation" class="{{$job_active == 'new-requests' ? 'active' : ''}} col-lg-2 col-md-3 col-sm-3 col-xs-12 p-0" id="new_badge">
							<a href="{{route('provider.dashboard', array('active'=>'new-requests', 'dashboard' => 1))}}" style="position: relative;">{{tr('new_requests')}}
							<div class="notify_badge new_job_badge" style="display: none"></div>
							</a>
						</li>

						<li role="presentation" class="{{$job_active == 'direct-requests' ? 'active' : ''}} col-lg-3 col-md-3 col-sm-3 col-xs-12 p-0" id="direct_badge">
							<a href="{{route('provider.dashboard', array('active'=>'direct-requests', 'dashboard' => 1))}}" style="position: relative;">
								{{tr('direct_requests')}}
								<div class="notify_badge direct_job_badge" style="display: none">{{direct_job_notifications()}}</div>
							</a>
						</li>

						<li role="presentation" class="{{$job_active == 'bidded-requests' ? 'active' : ''}} col-lg-2 col-md-3 col-sm-3 col-xs-12 p-0">
							<a href="{{route('provider.dashboard', array('active'=>'bidded-requests', 'dashboard' => 1))}}" style="position: relative;">{{tr('bidded_requests')}}
								<div class="notify_badge bidded_job_badge" style="display: none">{{bidded_job_notifications()}}</div>
							</a>
						</li>
						<li role="presentation" class="{{$job_active == 'confirm-requests' ? 'active' : ''}} col-lg-2 col-md-3 col-sm-3 col-xs-12 p-0">
							<a href="{{route('provider.dashboard', array('active'=>'confirm-requests', 'dashboard' => 1))}}">
								{{tr('confirmed_requests')}}
							</a>
						</li>

						<li role="presentation" class="{{$job_active == 'ongoing-requests' ? 'active' : ''}} col-lg-3 col-md-3 col-sm-3 col-xs-12 p-0">
							<a href="{{route('provider.dashboard', array('active'=>'ongoing-requests', 'dashboard' => 1))}}">{{tr('ongoing_requests')}}
							</a>
						</li>
					</ul>
				</div>
				<!-- End of jobs-head -->

				<!-- Job content -->
				<div class="tab-content job-content">

					<!-- Drafts tab -->
					<div role="tabpanel" class="tab-pane fade {{$job_active == 'new-requests' ? 'in active' : ''}}" id="new-requests">
						<!-- Job details-list -->
						<div class="job-details-list-row row m-0 p-30">

							<h3 class="job-main-tit"></h3>

							<!-- <h4 class="job-sub-tit"> 1 Results</h4> -->

							<div class="dashboard-list-outer">
								<!-- DAshboard list -->

								@if($new_requests)

									<div class="row">
										<div class="col-md-3">
										</div>
										<div class="col-md-3">
										</div>
										<div class="col-sm-6 top col-md-3">
											<input type="text" name="new_request_search" id="new_request_search" class="form-control" placeholder="{{tr('search_job_title')}}" onkeyup="searchNewRequest(this.value, false, 0)">
										</div>
										<div class="col-sm-6 top col-md-3">
											<select class="form-control" id="new_request_sorting_key" name="sorting" onchange="searchNewRequest(this.value, true, 0)">
												<option value="">{{tr('sort')}}</option>
												<option value="asc">{{tr('sort_by_a_z')}}</option>
												<option value="desc">{{tr('sort_by_z_a')}}</option>
												<option value="{{REQUEST_NOW}}">{{tr('only_ondemand_request')}}</option>
												<option value="{{REQUEST_LATER}}">{{tr('only_later_request')}}</option>
											</select>
										</div>
									</div>
									<br>


									<div class="clearfix"></div> 

									<div id="default_new_requests">

									@foreach($new_requests as $pr => $new_request)
								
										<div class="dashboard-list row m-0 create-job-shadow">

											<!-- Dashboard-list-box -->
											<div class="dashboard-list-col col-lg-5 col-md-5 col-sm-12 col-xs-12">
												<div class="dashboard-list-box">
													<h3 class="dashboard-list-tit job_name">{{$new_request->name}}</h3>
													<p class="dashboard-list-txt">
														<span><b>{{tr('request_date')}} : </b> {{$new_request->request_date}} </span>
													</p>
												</div>
											</div>
											<!-- End of dashboard-list-box -->

											<!-- Dashboard-list-box -->
											<div class="dashboard-list-col col-lg-2 col-md-2 col-sm-12 col-xs-12">
												<div class="dashboard-list-box">
													<p class="dashboard-list-txt">
														<i class="ion-arrow-graph-up-left truncate"></i> {{Setting::get('currency')}} {{$new_request->user_price}}{{$new_request->price_per_symbol}}
													</p>
													<p class="dashboard-list-txt">
														<i class="ion-arrow-graph-down-left"></i> {{$new_request->user_name}}
													</p>
												</div>
											</div>
											<!-- End of dashboard-list-box -->

											<!-- Dashboard-list-box -->
											<div class="dashboard-list-col col-lg-2 col-md-2 col-sm-12 col-xs-12">
												<div class="dashboard-list-box">
													<p class="dashboard-list-txt m-t-20">
													 	<i class="fa fa-briefcase"></i>
													 	{{request_status($new_request->status)}}
													</p>
												</div>
											</div>
											<!-- End of dashboard-list-box -->

											<!-- Dashboard-list-box -->
											<div class="dashboard-list-col col-lg-3 col-md-3 col-sm-12 col-xs-12">
												<div class="dashboard-list-box">

													<form class="job-form m-t-15" action="{{route('provider.requests.send.bid')}}" method="POST">
														<input required type="text" name="bid_amount" id="bid_amount" class="m-t-15" style="display: inline-block;padding: 5px;border-radius: 5px 5px;width: 50%;
														border:1px solid #999;height: 35px;" step="any" min="1" pattern="[0-9]+(\.[0-9]{0,2})?%?" title="{{tr('number_must_upto_decimal')}}" placeholder="{{tr('bid_amount_request')}}{{$new_request->price_per_symbol}}" onkeypress="return float_validation(event, this.value)">

														<input type="hidden" name="request_id" value="{{$new_request->request_id}}" >

														<button type="submit" class="btn btn-success" class=""><i class="fa fa-send" title="{{tr('send_bid_amount')}}"></i></button>

													</form>

													<a href="{{route('provider.requests.view' , ['request_unique_id' => $new_request->unique_id])}}" class="btn btn-warning" title="{{tr('view_job')}}"><i class="fa fa-eye"></i></a>								

												</div>
											</div>
											<!-- End of dashboard-list-box -->
										</div>

									@endforeach

									</div>

									<div id="new_requests"></div>

									<div id="new_loader"></div>

								@else

									<h3 class="text-center">{{tr('no_result_content')}}</h3>

								@endif
							
							</div>
						</div>
						<!-- End of job details list -->
					
					</div>
					<!-- End of Drafts tab -->

					<!-- Direct Jobs -->

					<div role="tabpanel" class="tab-pane fade {{$job_active == 'direct-requests' ? 'in active' : ''}}" id="direct-requests">
						<!-- Job details-list -->
						
						<div class="job-details-list-row row m-0 p-30">

							<h3 class="job-main-tit"></h3>

							@if($direct_requests)

								<h4 class="job-sub-tit">{{count($direct_requests)}} Results</h4>
								
							@endif

							<div class="dashboard-list-outer">

								@if($direct_requests)

									<div class="row">
										<div class="col-md-3">
										</div>
										<div class="col-md-3">
										</div>
										<div class="col-sm-6 top col-md-3">
											<input type="text" name="direct_job_search" id="direct_job_search" class="form-control" placeholder="{{tr('search_job_title')}}" onkeyup="searchDirectJob(this.value, false, 0)">
										</div>
										<div class="col-sm-6 top col-md-3">
											<select class="form-control" id="direct_job_sorting_key" name="sorting" onchange="searchDirectJob(this.value, true, 0)">
												<option value="">{{tr('sort')}}</option>
												<option value="asc">{{tr('sort_by_a_z')}}</option>
												<option value="desc">{{tr('sort_by_z_a')}}</option>
												
											</select>
										</div>
									</div>
									<br>

									<div id="default_direct_requests">

										@foreach($direct_requests as $pr => $direct_request)

											<div class="dashboard-list row m-0 create-job-shadow">

												<!-- Dashboard-list-box -->
												<div class="dashboard-list-col col-lg-4 col-md-5 col-sm-12 col-xs-12">
													<div class="dashboard-list-box">
														<h3 class="dashboard-list-tit truncate">{{$direct_request->name}}</h3>
														<p class="dashboard-list-txt">
															<span><b>{{tr('request_date')}} : </b> {{$direct_request->request_date}} </span>
														</p>
													</div>
												</div>
												<!-- End of dashboard-list-box -->

												<!-- Dashboard-list-box -->
												<div class="dashboard-list-col col-lg-3 col-md-2 col-sm-12 col-xs-12">
													<div class="dashboard-list-box">
														<p class="dashboard-list-txt">
															<i class="ion-arrow-graph-up-left"></i> 
															{{$direct_request->category_name}}
														</p>
														<p class="dashboard-list-txt">
															<i class="ion-arrow-graph-down-left"></i> 
															{{request_type($direct_request->request_type)}}
														</p>
													</div>
												</div>
												<!-- End of dashboard-list-box -->

												<!-- Dashboard-list-box -->
												<div class="dashboard-list-col col-lg-2 col-md-2 col-sm-12 col-xs-12">
													<div class="dashboard-list-box">
														<p class="dashboard-list-txt m-t-20">
														 	<i class="fa fa-money"></i>
														 	{{$direct_request->currency}} {{$direct_request->user_price}} {{$direct_request->price_per_symbol}}
														</p>
													</div>
												</div>
												<!-- End of dashboard-list-box -->

												<!-- Dashboard-list-box -->
												<div class="dashboard-list-col col-lg-3 col-md-3 col-sm-12 col-xs-12">
													<div class="dashboard-list-box m-t-15">

														<form class="job-form" action="{{route('provider.requests.send.bid')}}" method="POST">

															<input required type="text" name="bid_amount" id="bid_amount" class="m-t-15" style="display: inline-block;padding: 5px;border-radius: 5px 5px;width: 50%;height:35px;border:1px solid #999;" step="any" min="1" pattern="[0-9]+(\.[0-9]{0,2})?%?" title="This must be a number with up to 2 decimal places and/or %" placeholder="{{tr('bid_amount_request')}} {{$direct_request->price_per_symbol}}" onkeypress="return float_validation(event, this.value)">

															<input type="hidden" name="request_id" value="{{$direct_request->request_id}}" >

															<button type="submit" class="btn btn-success" class="" title="{{tr('send_bid_amount')}}"><i class="fa fa-send"></i></button>

														</form>

														<a href="{{route('provider.requests.view' , ['request_unique_id' => $direct_request->unique_id])}}" class="btn btn-success" title="{{tr('view_job')}}"><i class="fa fa-eye"></i></a>
																							
													</div>
												</div>
												<!-- End of dashboard-list-box -->
											</div>

										@endforeach

									</div>

									<div id="direct_requests"></div>

									<div id="direct_loader"></div>

								@else

									<h3 class="text-center">{{tr('no_result_content')}}</h3>

								@endif
								
							</div>

						</div>

						<!-- End of job details list -->
					
					</div>
					<!-- End of Direct Jobs -->

					<!-- Active jobs tab -->
					<div role="tabpanel" class="tab-pane fade {{$job_active == 'bidded-requests' ? 'in active' : ''}}" id="bidded-requests">
						<!-- Job details-list -->
						<div class="job-details-list-row row m-0 p-30">

							<h3 class="job-main-tit"></h3>

							@if($bidded_requests)

								<h4 class="job-sub-tit">{{count($bidded_requests)}} Results</h4>

							@endif

							<div class="dashboard-list-outer">
								<!-- DAshboard list -->

								@if($bidded_requests)


									<div class="row">
										<div class="col-md-3">
										</div>
										<div class="col-md-3">
										</div>
										<div class="col-sm-6 top col-md-3">
											<input type="text" name="bidded_job_search" id="bidded_job_search" class="form-control" placeholder="{{tr('search_job_title')}}" onkeyup="searchBidded(this.value, false, 0)">
										</div>
										<div class="col-sm-6 top col-md-3">
											<select class="form-control" id="bidded_sorting_key" name="sorting" onchange="searchBidded(this.value, true, 0)">
												<option value="">{{tr('sort')}}</option>
												<option value="asc">{{tr('sort_by_a_z')}}</option>
												<option value="desc">{{tr('sort_by_z_a')}}</option>
												
											</select>
										</div>
									</div>
									<br>

									<div id="default_bidded_requests">

									@foreach($bidded_requests as $pr => $bidded_request)

										<div class="dashboard-list row m-0 create-job-shadow">

											<!-- Dashboard-list-box -->
											<div class="dashboard-list-col col-lg-4 col-md-5 col-sm-12 col-xs-12">
												<div class="dashboard-list-box">
													<h3 class="dashboard-list-tit truncate">{{$bidded_request->name}}</h3>
													<p class="dashboard-list-txt">
														<span><b>{{tr('created')}} : </b> {{$bidded_request->request_date}} </span>
													</p>
												</div>
											</div>
											<!-- End of dashboard-list-box -->

											<!-- Dashboard-list-box -->
											<div class="dashboard-list-col col-lg-3 col-md-2 col-sm-12 col-xs-12">
												<div class="dashboard-list-box">
													<p class="dashboard-list-txt">
														<i class="ion-arrow-graph-up-left"></i> 
														{{$bidded_request->category_name}}
													</p>
													<p class="dashboard-list-txt">
														<i class="ion-arrow-graph-down-left"></i> 
														{{request_type($bidded_request->request_type)}}
													</p>
												</div>
											</div>
											<!-- End of dashboard-list-box -->

											<?php $requests_meta = get_requests_meta($bidded_request->request_id , Auth::guard('provider')->user()->id); ?>


											<!-- Dashboard-list-box -->
											<div class="dashboard-list-col col-lg-2 col-md-2 col-sm-12 col-xs-12">
												<div class="dashboard-list-box">
													<p class="dashboard-list-txt m-t-20">
													 	<i class="fa fa-money"></i>
													 	@if($requests_meta)

													 		{{$bidded_request->currency}} {{$requests_meta->bid_amount}}{{$bidded_request->price_per_symbol}}

													 	@endif
													</p>
												</div>
											</div>
											<!-- End of dashboard-list-box -->

											<!-- Dashboard-list-box -->
											<div class="dashboard-list-col col-lg-3 col-md-3 col-sm-12 col-xs-12">

												<div class="dashboard-list-box m-t-15">

													@if($requests_meta)

														@if($requests_meta->status == REQUEST_META_ASSIGNED)

															<form class="job-form" action="{{route('provider.requests.confirm')}}" method="POST">

																<input type="hidden" name="request_id" value="{{$bidded_request->request_id}}" >

																<button type="submit" class="btn btn-success" class="">{{tr('confirm')}}</button>

															</form>

															<form class="job-form" action="{{route('provider.requests.cancel')}}" method="POST">

																<input type="hidden" name="request_id" value="{{$bidded_request->request_id}}" >

																<button type="submit" class="btn btn-danger" class="">{{tr('reject')}}</button>

															</form>
														@else

															

														@endif

													@endif

													<a href="{{route('provider.requests.view' , ['request_unique_id' => $bidded_request->unique_id])}}" class="btn btn-warning">

														{{tr('view')}}
													</a>									
												</div>
											</div>
											<!-- End of dashboard-list-box -->
										</div>

									@endforeach

									</div>

									<div id="bidded_requests"></div>

									<div id="bidded_loader"></div>

								@else

									<h3 class="text-center">{{tr('no_result_content')}}</h3>

								@endif
							
							</div>
							
						</div>
						<!-- End of job details list -->
					
					</div>
					<!-- End of active jobs tab -->

					<!-- Confirmed Jobs -->
					<div role="tabpanel" class="tab-pane fade {{$job_active == 'confirm-requests' ? 'in active' : ''}}" id="confirm-requests">
						<!-- Job details-list -->
						<div class="job-details-list-row row m-0 p-30">

							<!-- <h3 class="job-main-tit">Confirm Jobs</h3> -->

							@if($confirmed_requests)
								<h4 class="job-sub-tit">{{count($confirmed_requests)}} Results</h4>
							@endif

							<div class="dashboard-list-outer">

								@if($confirmed_requests)

									<div class="row">
										<div class="col-md-3">
										</div>
										<div class="col-md-3">
										</div>
										<div class="col-sm-6 top col-md-3">
											<input type="text" name="confirmed_job_search" id="confirmed_job_search" class="form-control" placeholder="{{tr('search_job_title')}}" onkeyup="searchConfirmed(this.value, false, 0)">
										</div>
										<div class="col-sm-6 top col-md-3">
											<select class="form-control" id="confirmed_job_sorting_key" name="sorting" onchange="searchConfirmed(this.value, true, 0)">
												<option value="">{{tr('sort')}}</option>
												<option value="asc">{{tr('sort_by_a_z')}}</option>
												<option value="desc">{{tr('sort_by_z_a')}}</option>
												
											</select>
										</div>
									</div>
									<br>

									<div id="default_confirmed_requests">

									@foreach($confirmed_requests as $pr => $confirmed_request)

										<div class="dashboard-list row m-0 create-job-shadow">

											<!-- Dashboard-list-box -->
											<div class="dashboard-list-col col-lg-4 col-md-5 col-sm-12 col-xs-12">
												<div class="dashboard-list-box">
													<h3 class="dashboard-list-tit truncate">{{$confirmed_request->name}}</h3>
													<p class="dashboard-list-txt">
														<span><b>{{tr('request_date')}} : </b> {{$confirmed_request->request_date}} </span>
													</p>
												</div>
											</div>
											<!-- End of dashboard-list-box -->

											<!-- Dashboard-list-box -->
											<div class="dashboard-list-col col-lg-3 col-md-2 col-sm-12 col-xs-12">
												<div class="dashboard-list-box">
													<p class="dashboard-list-txt">
														<i class="ion-arrow-graph-up-left"></i> 
														{{$confirmed_request->category_name}}
													</p>
													<p class="dashboard-list-txt">
														<i class="ion-arrow-graph-down-left"></i> 
														{{request_type($confirmed_request->request_type)}}
													</p>
												</div>
											</div>
											<!-- End of dashboard-list-box -->

											<!-- Dashboard-list-box -->
											<div class="dashboard-list-col col-lg-2 col-md-2 col-sm-12 col-xs-12">
												<div class="dashboard-list-box">
													<p class="dashboard-list-txt m-t-20">
													 	<i class="fa fa-money"></i>

													 	{{$confirmed_request->currency}}{{$confirmed_request->price_per_hour}}{{$confirmed_request->price_per_symbol}}
													 	
													</p>
												</div>
											</div>
											<!-- End of dashboard-list-box -->

											<!-- Dashboard-list-box -->
											<div class="dashboard-list-col col-lg-3 col-md-3 col-sm-12 col-xs-12">

												<div class="dashboard-list-box m-t-15">

													<a href="{{route('provider.requests.view' , ['request_unique_id' => $confirmed_request->unique_id])}}" class="view-link theme-btn" title="{{tr('view_job')}}"><i class="fa fa-eye"></i> {{tr('view')}}</a>									

												</div>
												
											</div>

											<!-- End of dashboard-list-box -->
										</div>

									@endforeach

									</div>

									<div id="confirmed_requests"></div>

									<div id="confirmed_loader"></div>

								@else

									<h3 class="text-center">{{tr('no_result_content')}}</h3>

								@endif
							</div>
						</div>
						<!-- End of job details list -->
					
					</div>
					<!-- End of Confirmed Jobs -->

					

					<!-- Ongoing Jobs -->
					<div role="tabpanel" class="tab-pane fade {{$job_active == 'ongoing-requests' ? 'in active' : ''}}" id="ongoing-requests">
						<!-- Job details-list -->
						<div class="job-details-list-row row m-0 p-30">

							<h3 class="job-main-tit"></h3>

							@if($ongoing_requests)

								<h4 class="job-sub-tit">{{count($ongoing_requests)}} {{tr('result')}}</h4>
								
							@endif

							<div class="dashboard-list-outer">

								@if(count($ongoing_requests) > 0)

									<div class="row">
										<div class="col-md-3">
										</div>
										<div class="col-md-3">
										</div>
										<div class="col-sm-6 top col-md-3">
											<input type="text" name="ongoing_job_search" id="ongoing_job_search" class="form-control" placeholder="{{tr('search_job_title')}}" onkeyup="searchOngoing(this.value, false, 0)">
										</div>
										<div class="col-sm-6 top col-md-3">
											<select class="form-control" id="ongoing_sorting_key" name="sorting" onchange="searchOngoing(this.value, true, 0)">
												<option value="">{{tr('sort')}}</option>
												<option value="asc">{{tr('sort_by_a_z')}}</option>
												<option value="desc">{{tr('sort_by_z_a')}}</option>
												
											</select>
										</div>
									</div>
									<br>

									<div id="default_ongoing_requests">

									@foreach($ongoing_requests as $pr => $ongoing_request)

										<div class="dashboard-list row m-0 create-job-shadow">

											<!-- Dashboard-list-box -->
											<div class="dashboard-list-col col-lg-4 col-md-5 col-sm-12 col-xs-12">
												<div class="dashboard-list-box">
													<h3 class="dashboard-list-tit truncate">{{$ongoing_request->name}}</h3>
													<p class="dashboard-list-txt">
														<span><b>{{tr('request_date')}} : </b> {{$ongoing_request->request_date}} </span>
													</p>
												</div>
											</div>
											<!-- End of dashboard-list-box -->

											<!-- Dashboard-list-box -->
											<div class="dashboard-list-col col-lg-3 col-md-2 col-sm-12 col-xs-12">
												<div class="dashboard-list-box">
													<p class="dashboard-list-txt">
														<i class="ion-arrow-graph-up-left"></i> 
														{{$ongoing_request->category_name}}
													</p>
													<p class="dashboard-list-txt">
														<i class="ion-arrow-graph-down-left"></i> 
														{{request_type($ongoing_request->request_type)}}
													</p>
												</div>
											
											</div>

											<!-- End of dashboard-list-box -->

											<!-- Dashboard-list-box -->
											<div class="dashboard-list-col col-lg-2 col-md-2 col-sm-12 col-xs-12">
												<div class="dashboard-list-box">
													<p class="dashboard-list-txt m-t-20">
													 	<i class="fa fa-info-circle"></i>
													 	{{$ongoing_request->currency}} {{$ongoing_request->price_per_hour}} {{$ongoing_request->price_per_symbol}}
													</p>
												</div>
											
											</div>
											<!-- End of dashboard-list-box -->

											<!-- Dashboard-list-box -->
											<div class="dashboard-list-col col-lg-3 col-md-3 col-sm-12 col-xs-12">

												<div class="dashboard-list-box">

													<a href="{{route('provider.requests.view' , ['request_unique_id' => $ongoing_request->unique_id])}}" class="btn btn-success m-t-15" title="View Job"><i class="fa fa-eye"></i> {{tr('view')}}</a>

												</div>

											</div>
											<!-- End of dashboard-list-box -->
										
										</div>

									@endforeach

									</div>

									<div id="ongoing_requests"></div>

									<div id="ongoing_loader"></div>

								@else

									<h3 class="text-center">{{tr('no_result_content')}}</h3>

								@endif
								
							</div>


						</div>
						<!-- End of job details list -->
					
					</div>
					<!-- End of Ongoing Jobs -->

				</div>
				<!-- end of Job content  -->
			
			</div>
		</div>

	</div>

@endsection


@section('after-scripts')

<script type="text/javascript">

var newLength = "{{count($new_requests)}}";

var directLength = "{{count($direct_requests)}}";

var biddedLength = "{{count($bidded_requests)}}";

var confirmedLength = "{{count($confirmed_requests)}}";

var ongoingLength = "{{count($ongoing_requests)}}";

var stopScroll = false;

var searchLength = 0;
	
function newRequests(value) {

	console.log("skip value"+value);

	$.ajax ({

		type : "POST",

		url : "{{route('provider.ajax_new_requests')}}",

		beforeSend : function () {

			$("#new_loader").html('<h1 class="text-center theme-color"><i class="fa fa-spinner fa-spin"></i></h1>');
		},

		data : {skip : value},

		async : false,

		success : function (data) {

			$("#new_requests").append(data.view);

			if (data.length == 0) {

				stopScroll = true;

			} else {

				stopScroll = false;

				newLength = parseInt(newLength) + data.length;

			}

		}, 

		complete : function() {

			$("#new_loader").html('');

		},

		error : function (data) {


		},

	});

}


function directRequests(value) {

	console.log("skip value"+value);

	$.ajax ({

		type : "POST",

		url : "{{route('provider.ajax_direct_requests')}}",

		beforeSend : function () {

			$("#direct_loader").html('<h1 class="text-center theme-color"><i class="fa fa-spinner fa-spin"></i></h1>');
		},

		data : {skip : value},

		async : false,

		success : function (data) {

			$("#direct_requests").append(data.view);

			if (data.length == 0) {

				stopScroll = true;

			} else {

				stopScroll = false;

				directLength = parseInt(directLength) + data.length;

			}

		}, 

		complete : function() {

			$("#direct_loader").html('');

		},

		error : function (data) {


		},

	});

}

function biddedRequests(value) {

	console.log("skip value"+value);

	$.ajax ({

		type : "POST",

		url : "{{route('provider.ajax_bidded_requests')}}",

		beforeSend : function () {

			$("#bidded_loader").html('<h1 class="text-center theme-color"><i class="fa fa-spinner fa-spin"></i></h1>');
		},

		data : {skip : value},

		async : false,

		success : function (data) {

			$("#bidded_requests").append(data.view);

			if (data.length == 0) {

				stopScroll = true;

			} else {

				stopScroll = false;

				biddedLength = parseInt(biddedLength) + data.length;

			}

		}, 

		complete : function() {

			$("#bidded_loader").html('');

		},

		error : function (data) {


		},

	});

}



function confirmRequests(value) {

	console.log("skip value"+value);

	$.ajax ({

		type : "POST",

		url : "{{route('provider.ajax_confirmed_requests')}}",

		beforeSend : function () {

			$("#confirmed_loader").html('<h1 class="text-center theme-color"><i class="fa fa-spinner fa-spin"></i></h1>');
		},

		data : {skip : value},

		async : false,

		success : function (data) {

			$("#confirmed_requests").append(data.view);

			if (data.length == 0) {

				stopScroll = true;

			} else {

				stopScroll = false;

				confirmedLength = parseInt(confirmedLength) + data.length;

			}

		}, 

		complete : function() {

			$("#confirmed_loader").html('');

		},

		error : function (data) {


		},

	});

}


function ongoingRequests(value) {

	console.log("skip value"+value);

	$.ajax ({

		type : "POST",

		url : "{{route('provider.ajax_ongoing_requests')}}",

		beforeSend : function () {

			$("#ongoing_loader").html('<h1 class="text-center theme-color"><i class="fa fa-spinner fa-spin"></i></h1>');
		},

		data : {skip : value},

		async : false,

		success : function (data) {

			$("#ongoing_requests").append(data.view);

			if (data.length == 0) {

				stopScroll = true;

			} else {

				stopScroll = false;

				ongoingLength = parseInt(ongoingLength) + data.length;

			}

		}, 

		complete : function() {

			$("#ongoing_loader").html('');

		},

		error : function (data) {


		},

	});

}

function reset() {

	stopScroll = false;

	var newLength = "{{count($new_requests)}}";

	var directLength = "{{count($direct_requests)}}";

	var biddedLength = "{{count($bidded_requests)}}";

	var confirmedLength = "{{count($confirmed_requests)}}";

	var ongoingLength = "{{count($ongoing_requests)}}";

	$("#new_requests").html("");

	$("#bidded_requests").html("");

	$("#direct_requests").html("");

	$("#confirmed_requests").html("");

	$("#ongoing_requests").html("");


	searchLength = 0;

	if ($("#default_new_requests").html() == ""){ 

		newRequests(0);

	}

}

$(window).scroll(function() {

    if($(window).scrollTop() == $(document).height() - $(window).height()) {

    	var jobs_type = $('ul#tab').find('li.active').data('value');

    	if (!stopScroll) {


    		switch(jobs_type) {

    			case 'new-requests' :

    				console.log(searchLength);

    				if (searchLength > 0) {

    					var newKeyWord = $("#new_request_search").val();

    					var newSearchWord = $("#new_request_sorting_key").val();

    					if (newKeyWord != '') {

    						var status = false;

    						var word = newKeyWord;

    					} else {

    						var status = true;

    						var word = newSearchWord;

    					}

    					searchNewRequest(word, status, searchLength);

    				} else {

    					newRequests(newLength);

    				}


    				break;


    			case 'direct-requests' :

    				console.log(searchLength);

    				if (searchLength > 0) {

    					var directKeyWord = $("#direct_job_search").val();

    					var directSearchWord = $("#direct_job_sorting_key").val();

    					if (directKeyWord != '') {

    						var status = false;

    						var word = directKeyWord;

    					} else {

    						var status = true;

    						var word = directSearchWord;

    					}

    					searchDirectJob(word, status, searchLength);

    				} else {

    					directRequests(directLength);

    				}

    				break;

    			case 'bidded-requests' :

    				console.log(searchLength);

    				if (searchLength > 0) {

    					var biddedKeyWord = $("#bidded_job_search").val();

    					var biddedSearchWord = $("#bidded_sorting_key").val();

    					if (biddedKeyWord != '') {

    						var status = false;

    						var word = biddedKeyWord;

    					} else {

    						var status = true;

    						var word = biddedSearchWord;

    					}

    					searchBidded(word, status, searchLength);

    				} else {

    					biddedRequests(biddedLength);

    				}
	

    				break;

    			case 'confirm-requests' :

    				console.log(searchLength);

    				if (searchLength > 0) {

    					var confirmedKeyWord = $("#confirmed_job_search").val();

    					var confirmedSearchWord = $("#confirmed_job_sorting_key").val();

    					if (confirmedKeyWord != '') {

    						var status = false;

    						var word = confirmedKeyWord;

    					} else {

    						var status = true;

    						var word = confirmedSearchWord;

    					}

    					searchConfirmed(word, status, searchLength);

    				} else {

    					confirmRequests(confirmedLength);

    				}

    				

    				break;

    			case 'ongoing-requests' :

    				console.log(searchLength);

    				if (searchLength > 0) {

    					var ongngKeyWord = $("#ongoing_job_search").val();

    					var ongngSearchWord = $("#ongoing_sorting_key").val();

    					if (ongngKeyWord != '') {

    						var status = false;

    						var word = ongngKeyWord;

    					} else {

    						var status = true;

    						var word = ongngSearchWord;

    					}

    					searchOngoing(word, status, searchLength);

    				} else {

    					ongoingRequests(ongoingLength);

    				}


    				break;

    			default :

    				console.log(searchLength);

    				if (searchLength > 0) {

    					var newKeyWord = $("#new_request_search").val();

    					var newSearchWord = $("#new_request_sorting_key").val();

    					if (newKeyWord != '') {

    						var status = false;

    						var word = newKeyWord;

    					} else {

    						var status = true;

    						var word = newSearchWord;

    					}

    					searchNewRequest(word, status, searchLength);

    				} else {

    					newRequests(newLength);

    				}

    				break;

    		}

	    	

    	}
    }
});

 $("#new_badge").click(function() {

 	var new_job_badge = $('.new_job_badge').html();

 	if (parseInt(new_job_badge) > 0) {

	    $.ajax({
	        'url' : '{{ url("/api/provider/change_job_status_notifications") }}',
	        'type' : 'post',
	        data : {id : "{{Auth::guard('provider')->user()->id}}", token : "{{Auth::guard('provider')->user()->token}}"},    
	        'success' : function(response) {

	            console.log(response);

	        }
	    
	    });

	}

});


 $("#direct_badge").click(function() {

 	var direct_badge = $('.direct_job_badge').html();

 	if (parseInt(direct_badge) > 0) {

	    $.ajax({
	        'url' : '{{ url("/api/provider/change_direct_notifications") }}',
	        'type' : 'post',
	        data : {id : "{{Auth::guard('provider')->user()->id}}", token : "{{Auth::guard('provider')->user()->token}}"},    
	        'success' : function(response) {

	            console.log(response);

	        }
	    
	    });

	}

});



function searchNewRequest(val, status, searchLength) {

	console.log("skip value"+val);

	$("#default_new_requests").html("");

	$("#new_requests").html("");

	if (status) {

		var sorting_key = val;

		var searching_key = $("#new_request_search").val();

	} else {

		var sorting_key = $("#new_request_sorting_key").val();

		var searching_key = val;
	}


	$.ajax ({

		type : "POST",

		url : "{{route('provider.ajax_new_requests')}}",

		beforeSend : function () {

			$("#new_loader").html('<h1 class="text-center theme-color"><i class="fa fa-spinner fa-spin"></i></h1>');
		},

		data : {skip : searchLength, search_key : searching_key, sorting_status : status, sorting_key : sorting_key},

		async : false,

		success : function (data) {

			$("#new_requests").append(data.view);

			if (data.length == 0) {

				stopScroll = true;

			} else {

				stopScroll = false;

				newLength = parseInt(newLength) + data.length;

			}

		}, 

		complete : function() {

			$("#new_loader").html('');

		},

		error : function (data) {


		},

	});

}


function searchDirectJob(val, status, searchLength) {

	console.log("skip value"+val);

	$("#default_direct_requests").html("");

	$("#direct_requests").html("");

	if (status) {

		var sorting_key = val;

		var searching_key = $("#direct_job_search").val();

	} else {

		var sorting_key = $("#direct_job_sorting_key").val();

		var searching_key = val;
	}

	$.ajax ({

		type : "POST",

		url : "{{route('provider.ajax_direct_requests')}}",

		beforeSend : function () {

			$("#direct_loader").html('<h1 class="text-center theme-color"><i class="fa fa-spinner fa-spin"></i></h1>');
		},

		data : {skip : searchLength, search_key : searching_key, sorting_status : status, sorting_key : sorting_key},

		async : false,

		success : function (data) {

			$("#direct_requests").append(data.view);

			if (data.length == 0) {

				stopScroll = true;

			} else {

				stopScroll = false;

				directLength = parseInt(directLength) + data.length;

			}

		}, 

		complete : function() {

			$("#direct_loader").html('');

		},

		error : function (data) {


		},

	});

}

function searchBidded(val, status, searchLength) {


	console.log("skip value"+val);

	$("#default_bidded_requests").html("");

	$("#bidded_requests").html("");

	if (status) {

		var sorting_key = val;

		var searching_key = $("#bidded_job_search").val();

	} else {

		var sorting_key = $("#bidded_sorting_key").val();

		var searching_key = val;
	}

	$.ajax ({

		type : "POST",

		url : "{{route('provider.ajax_bidded_requests')}}",

		beforeSend : function () {

			$("#bidded_loader").html('<h1 class="text-center theme-color"><i class="fa fa-spinner fa-spin"></i></h1>');
		},

		data : {skip : searchLength, search_key : searching_key, sorting_status : status, sorting_key : sorting_key},

		async : false,

		success : function (data) {

			$("#bidded_requests").append(data.view);

			if (data.length == 0) {

				stopScroll = true;

			} else {

				stopScroll = false;

				biddedLength = parseInt(biddedLength) + data.length;

			}

		}, 

		complete : function() {

			$("#bidded_loader").html('');

		},

		error : function (data) {


		},

	});

}



function searchConfirmed(val, status, searchLength) {

	
	console.log("skip value"+val);

	$("#default_confirmed_requests").html("");

	$("#confirmed_requests").html("");

	if (status) {

		var sorting_key = val;

		var searching_key = $("#confirmed_job_search").val();

	} else {

		var sorting_key = $("#confirmed_job_sorting_key").val();

		var searching_key = val;
	}


	$.ajax ({

		type : "POST",

		url : "{{route('provider.ajax_confirmed_requests')}}",

		beforeSend : function () {

			$("#confirmed_loader").html('<h1 class="text-center theme-color"><i class="fa fa-spinner fa-spin"></i></h1>');
		},

		data : {skip : searchLength, search_key : searching_key, sorting_status : status, sorting_key : sorting_key},

		async : false,

		success : function (data) {

			$("#confirmed_requests").append(data.view);

			if (data.length == 0) {

				stopScroll = true;

			} else {

				stopScroll = false;

				confirmedLength = parseInt(confirmedLength) + data.length;

			}

		}, 

		complete : function() {

			$("#confirmed_loader").html('');

		},

		error : function (data) {


		},

	});

}


function searchOngoing(val,status,searchLength) {

		
	console.log("skip value"+val);

	$("#default_ongoing_requests").html("");

	$("#ongoing_requests").html("");

	if (status) {

		var sorting_key = val;

		var searching_key = $("#ongoing_job_search").val();

	} else {

		var sorting_key = $("#ongoing_sorting_key").val();

		var searching_key = val;
	}

	$.ajax ({

		type : "POST",

		url : "{{route('provider.ajax_ongoing_requests')}}",

		beforeSend : function () {

			$("#ongoing_loader").html('<h1 class="text-center theme-color"><i class="fa fa-spinner fa-spin"></i></h1>');
		},

		data : {skip : searchLength, search_key : searching_key, sorting_status : status, sorting_key : sorting_key},

		async : false,

		success : function (data) {

			$("#ongoing_requests").append(data.view);

			if (data.length == 0) {

				stopScroll = true;

			} else {

				stopScroll = false;

				ongoingLength = parseInt(ongoingLength) + data.length;

			}

		}, 

		complete : function() {

			$("#ongoing_loader").html('');

		},

		error : function (data) {


		},

	});

}

</script>
@endsection