@extends('layouts.provider')

@section('after-styles')

<link href="{{asset('common/css/star.rating.min.css')}}" rel="stylesheet">

@endsection

@section('content')

<div class="content-wrap gray-bg">
	<div class="container">
		<div class="other-profiles m-30 white-bg p-f-30">

			@include('notification.notify')
		
			<div class="other-profiles-inner row m-0">
				<h3 class="others-prof-tit">

					<span class="">{{tr('user_profile')}}</span>

					<span class="pull-right">
						<a href="{{request()->headers->get('referer')}}" class="btn btn-success"><i class="fa fa-back-arrow"></i> {{tr('back')}}</a>
					</span>
				</h3>
				<!-- Other Profiles Left -->
				<div class="other-profiles-left-col col-lg-3 col-md-4 col-sm-5 col-xs-12">
					<div class="other-profiles-left">
						
						<div class="other-prof-img bg-img" style="background-image: url({{$user->picture}});">
						</div>

						<div class="rating-sec-view" style="text-align: center;margin: 10px;">

							<input type="hidden" name="rating" disabled id="rating-view" class="rating" value="{{user_rating($user->id)}}" />

						</div>

						@if(count($request_details) > 0)

							@if($requests_meta || $request_details->provider_id && $request_details->status < REQUEST_COMPLETE_PENDING)

							<div class="others-review-block text-center">
								<a href="{{route('provider.chat' , ['request_id' => $request_details->unique_id , 'user_id' => $user->unique_id ])}}" class="common-bg-link others-link">{{tr('chat')}}</a>
							</div>

							@endif

						@endif

					</div>

				</div>
				<!-- End of other profiles left-->

				<!-- other profiles right -->
				<div class="other-profiles-right-col col-lg-9 col-md-8 col-sm-7 col-xs-12">

					<div class="other-profiles-right p-f-30">

					 	<div class="others-prof-head row m-0 border-bot">

					 		<h3 class="others-tit pull-left">{{$user->name}}</h3>
					 		<!-- <p class="others-sub-tit pull-right">$30/hr</p> -->
					 	</div>

					 	<div class="others-prof-content">


					 		<div class="others-prof-sub-block border-bot p-30">

					 			<p class="others-prof-txt">
					 				<i class="fa fa-envelope theme-color"></i>
					 				{{$user->email}}
					 			</p>

					 			<p class="others-prof-txt">
					 				<i class="fa fa-address-card-o theme-color"></i>
					 				{{$user->address}}
					 			</p>

					 			<p class="others-prof-txt">
					 				<i class="fa fa-mobile theme-color"></i>
					 				{{$user->mobile}}
					 			</p>

					 			<p class="others-prof-txt">
					 				<i class="theme-color fa fa-file-text"></i>
					 				{{$user->description}}
					 			</p>

					 		</div>

					 		<!-- <div class="other-prof-des">
					 			<h3 class="other-prof-des">How Can I Help</h3>
					 			<p class="others-prof-txt">
					 				Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.
					 			</p>
					 			<div class="review-block row m-0 p-30 b-t">
					 				<div class="review-block-left-col col-lg-3 col-md-3 col-sm-4 col-xs-12">
					 					<div class="review-block-left">
					 						<div class="review-block-img bg-img" style="background-image: url({{asset('common/img/user1.jpg')}});"></div>
					 					</div>
					 				</div>

					 				<div class="review-block-right-col col-lg-9 col-md-9 col-sm-8 col-xs-12">
					 					<div class="review-block-left">
					 						<p class="review-block-txt">"Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat."</p>
					 						<p class="review-block-txt">- August, 2016</p>
					 					</div>
					 				</div>
					 			</div>
					 		</div> -->
					 	</div>
					</div>
				</div>
				<!-- End fof profiles right -->
			</div>
		</div>
	
	</div>

</div>

<!-- review modal -->
<!-- Modal -->

<div class="modal fade" id="review" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
  	<div class="modal-dialog" role="document">
	    <div class="modal-content p-f-30">
	      	<div class="modal-header">
	        	<button type="button" class="close" data-dismiss="modal" aria-label="Close">	
	        		<span aria-hidden="true">&times;</span>
	        	</button>
	        	<h4 class="modal-title" id="myModalLabel">{{tr('reviews_bella_marys')}}</h4>
	      	</div>

	      	<div class="modal-body">
	      		<div class="about-me border-bot">
	      			<h3 class="other-prof-des">{{tr('little_about_me')}}</h3>
		 			<p class="others-prof-txt">
		 				{{tr('user_prrofile_content')}}
		 			</p>
	      		</div>
	      		<div class="review-sec">
	      			<h3 class="review-tit">{{tr('reviews')}}</h3>
		        	<!-- Review block -->
		        	<div class="review-block row m-0 p-30 border-bot">
		 				<div class="review-block-left-col col-lg-3 col-md-3 col-sm-4 col-xs-12">
		 					<div class="review-block-left">
		 						<div class="review-block-img bg-img" style="background-image: url(img/user1.jpg);">
		 							<div class="like-icon"><i class="ion-thumbsup"></i></div>
		 						</div>
		 					</div>
		 				</div>

		 				<div class="review-block-right-col col-lg-9 col-md-9 col-sm-8 col-xs-12">
		 					<div class="review-block-left">
		 						<p class="review-block-txt">{{tr('user_profile_note')}}</p>
		 						<p class="review-block-txt">- August, 2016</p>
		 					</div>
		 				</div>
		 			</div>
		        	<!-- End of review block -->
		        	<!-- Review block -->
		        	<div class="review-block row m-0 p-30 border-bot">
		 				<div class="review-block-left-col col-lg-3 col-md-3 col-sm-4 col-xs-12">
		 					<div class="review-block-left">
		 						<div class="review-block-img bg-img" style="background-image: url(img/user1.jpg);">
		 							<div class="like-icon"><i class="ion-thumbsdown"></i></div>
		 						</div>
		 					</div>
		 				</div>

		 				<div class="review-block-right-col col-lg-9 col-md-9 col-sm-8 col-xs-12">
		 					<div class="review-block-left">
		 						<p class="review-block-txt">{{tr('user_profile_note')}}</p>
		 						<p class="review-block-txt">- August, 2016</p>
		 					</div>
		 				</div>
		 			</div>
		        	<!-- End of review block -->
	        	</div>
	      	</div>
	    </div>
  	</div>
</div>

@endsection

@section('after-scripts')

<script src="{{asset('common/js/star.rating.min.js')}}"></script>

@endsection