@extends('layouts.provider')

@section('after-styles')

<link href="{{asset('common/css/star.rating.min.css')}}" rel="stylesheet">

<style type="text/css">
    html, body {
        height: 100%;
        margin: 0;
        padding: 0;
    }

    #map {
        height: 100%;
        min-height: 400px; 
    }

    table {
	    border-collapse: collapse;
	    border-spacing: 0;
	    width: 100%;
	    border: 1px solid #ddd;
	}

	th, td {
	    text-align: center;
	    padding: 16px;
	}

	th:first-child, td:first-child {
	    text-align: left;
	    color: gray;
	    text-transform: uppercase;
	}

	tr:nth-child(even) {
	    background-color: #32b90e0d;
	}

</style>

@endsection

@section('content')

<div class="content-wrap gray-bg">

	<div class="container">

		<div class="jobs white-bg m-30 p-f-30">

			@include('notification.notify')

			<!-- Job content -->
			<div class="provider-work-details">

				<div class="provider-work-row row m-0">

					<h3 class="job-main-tit row m-0">

						<span class="job-name pull-left">{{$request_details->name}}

						@if($messages) 

							@if($requests_meta || $request_details->provider_id && $request_details->status < REQUEST_COMPLETE_PENDING)

								<a href="{{route('provider.chat' , ['request_id' => $request_details->unique_id , 'user_id' => $request_details->user->unique_id ])}}" target="_blank" class="common-bg-link chat-link"> <i class="fa fa-comment"></i></a>

							@endif
						
						@endif

						</span>
						<span></span>

						<span class="pull-right">{{common_date($request_details->request_date, Auth::guard('provider')->user()->timezone)}}</span>
					</h3>

					@if($request_details->description)
					
						<p class="job-des">{{$request_details->description}}</p>

					@endif

					@if($request_details->cancelled_by)
					
						<p class="job-des text-danger">

							<span class="text-uppercase">{{tr('cancelled_by')}} - {{$request_details->cancelled_by}}</span>

							<br>

							<span class="text-danger">{{$request_details->cancelled_reason}}</span>

							<br>

							<span class="text-gray">{{common_date($request_details->cancelled_date , Auth::guard('provider')->user()->timezone)}}</span>

						</p>

						<p></p>

					@endif

					@if($request_details->note)
					
						<br>
						<p class="theme-color">{{tr('note')}} : {{$request_details->note}}</p>

					@endif

					<!-- tracking details -->
					<div class="tracking-details row m-0 m-30">

						@if($tracking = tracking($request_details->status , $request_details->provider_status))

							@foreach($tracking as $t => $value)

								<!-- 0 - disabled , 1 - active status , 2 = completed status -->

								<div class="track-details-col col-lg-2 col-md-2 col-sm-4 col-xs-12 p-0">
									<a href="javascript:void(0);" class="track-tab @if($value == 0) disabled @elseif($value == 1) active @else complete @endif">{{tr($t)}}</a>
								</div>

							@endforeach

						@endif


					</div>
					<!-- End of tracking details -->

					<div class="job-details-row row m-0">

						<!-- job-details-left -->
						<div class="job-details-left-col col-lg-6 col-md-6 col-sm-12 col-xs-12 p-l-0">

							<div class="job-details-left gray-bg p-f-30">

								<dl class="job-details row">

			        				@if($request_details->user_id)

										<div class="job-details-sec">

											<a href="javascript:void(0)" target="_blank">

												<div class="incoming-img bg-img" style="background-image: url({{$request_details->user->picture ?? '-'}});">

						        				</div>

					        				</a>

					        				<div class="col-sm-12"></div>

				        				</div>

				        				<div class="clear-fix"></div>
				        				
				        				<div class="job-details-sec">
				        					<dt class="col-sm-4">{{tr('user')}} :</dt>
				        					
				        					<dd class="col-sm-8 theme-color">
				        						<a href="{{route('provider.user.profile' , ['id' => $request_details->user->unique_id ?? '0' , 'request_id' => $request_details->unique_id])}}" class="theme-a" style="">{{$request_details->user->name ?? tr('user_not_available')}}</a>
				        					</dd>
				        				</div>

										<div class="clear-fix"></div>

									@endif

									<div class="job-details-sec">
										<dt class="col-sm-4">{{tr('job_type')}} :</dt>
										<dd class="col-sm-8">{{job_type($request_details->job_type)}}</dd>
									</div>

									<div class="clear-fix"></div>

									@if($request_details->job_type != REQUEST_NOW)

										<div class="job-details-sec">
											<dt class="col-sm-4">{{tr('request_type')}} :</dt>
											<dd class="col-sm-8">{{request_type($request_details->request_type)}}</dd>
										</div>
										
									@endif

									<div class="clear-fix"></div>

									<div class="job-details-sec">
										<dt class="col-sm-4">{{tr('request_status')}} :</dt>
										
										<dd class="col-sm-8 theme-color">
											{{request_status($request_details->status)}}
										</dd>
									</div>

									<div class="clear-fix"></div>

									<div class="job-details-sec">
										<dt class="col-sm-4">{{tr('provider_status')}} :</dt>
										
										<dd class="col-sm-8 theme-color">
											@if($requests_meta)

												{{request_meta_status($requests_meta->status)}}

											@else
												{{provider_status($request_details->provider_status)}}
											@endif
										</dd>
									</div>

									<div class="clear-fix"></div>

									<div class="job-details-sec">
										<dt class="col-sm-4">{{tr('category')}} :</dt>
										<dd class="col-sm-8">{{$request_details->category->name}}</dd>
									</div>

									<div class="clear-fix"></div>

									<div class="job-details-sec">
										<dt class="col-sm-4">{{tr('sub_category')}} :</dt>
										<dd class="col-sm-8">{{$request_details->subCategory->name}}</dd>
									</div>

									<div class="clear-fix"></div>

									<div class="job-details-sec">
										<dt class="col-sm-4">{{tr('address')}} :</dt>
										<dd class="col-sm-8">{{$request_details->s_address}}</dd>
									</div>

									<div class="clear-fix"></div>

									<div class="job-details-sec">

										<dt class="col-sm-4">{{tr('payment_mode')}} :</dt>

										<dd class="col-sm-8" class="text-uppercase">{{$request_details->payment_mode ? $request_details->payment_mode : "-"}}</dd>
									</div>

									<div class="clear-fix"></div>

									<div class="job-details-sec">
										<dt class="col-sm-4">{{tr('price_type')}}:</dt>
										<dd class="col-sm-8">{{$request_details->price_type}}</dd>
									</div>

									<div class="clear-fix"></div>

									<div class="job-details-sec">
										<dt class="col-sm-4">{{tr('initial_per_hour_price')}}:</dt>
										<dd class="col-sm-8">{{$request_details->currency}}{{$request_details->user_price}}{{$request_details->price_per_symbol}}</dd>
									</div>

									<div class="clear-fix"></div>

									@if($requests_meta)

										<div class="job-details-sec">
											<dt class="col-sm-4">{{tr('bid_amount')}}:</dt>
											<dd class="col-sm-8">{{$request_details->currency}}{{$requests_meta->bid_amount}}{{$request_details->price_per_symbol}}</dd>
										</div>

										<div class="clear-fix"></div>
									@endif

									<div class="job-details-sec">
										<dt class="col-sm-4">{{tr('final_per_hour_price')}}:</dt>
										<dd class="col-sm-8">
											@if($request_details->price_per_hour) 
												{{$request_details->currency}}{{$request_details->price_per_hour}}{{$request_details->price_per_symbol}}
											@else 
												-
											@endif
										</dd>
									</div>
									<div class="clear-fix"></div>

								</dl>

							</div>
						
						</div>

						<!-- End of details-left -->

						<!-- job-details-right -->

						<div class="job-details-right-col col-lg-6 col-md-6 col-sm-12 col-xs-12">

							<!-- Check the requests meta is offered -->

							@if($request_details->provider_status == PROVIDER_NONE && $request_details->job_type == REQUEST_LATER)
							
								<?php $allow = true; ?>

								@if(isset($requests_meta))

									@if($requests_meta->status == REQUEST_META_BID)

										<?php $allow = false; ?>

									@endif

								@endif

								@if($allow)

									<form class="job-form m-t-15" action="{{route('provider.requests.send.bid')}}" method="POST">
										
										<input type="hidden" name="request_id" value="{{$request_details->id}}">

										<label>{{tr('bid_amount')}}</label>

										<input type="number" step="any" min="1" pattern="[0-9]+(\.[0-9]{0,2})?%?" title="{{tr('number_must_upto_decimal')}}" class="form-control" placeholder="{{tr('bid_amount')}} {{$request_details->price_per_symbol}}" name="bid_amount" class="m-t-15" onkeypress="return float_validation(event, this.value)">

										<br>

										<button type="submit" class="btn btn-success job-form" class=""><i class="fa fa-send"></i> {{tr('send_bid')}}</button>

										<br>

										<br>

									</form>

								@endif

							@endif

							<!-- Confirm the user assigned request -->

							@if($request_details->provider_status == PROVIDER_ASSIGNED && $requests_meta->status == REQUEST_META_ASSIGNED && $request_details->status == REQUEST_PROVIDER_ASSIGNED && $requests_meta->provider_id == Auth::guard('provider')->user()->id )

								<div class="row">

									<form action="{{route('provider.requests.confirm')}}" method="POST" class="col-lg-12 col-md-12 col-sm-12 col-xs-12">

										<input type="hidden" name="request_id" value="{{$request_details->id}}">

										<button class="btn btn-success" style="width: 100%;margin-bottom: 10px">
											{{tr('confirm')}}
										</button>
									
									</form>

									<form action="{{route('provider.requests.cancel')}}" method="POST" class="col-lg-12 col-md-12 col-sm-12 col-xs-12">

										<input type="hidden" name="request_id" value="{{$request_details->id}}" >

										<button type="submit" class="btn btn-danger" style="width: 100%;margin-bottom: 10px" class="">{{tr('reject')}}</button>

									</form>
									
								</div>

							@endif

							<!-- Check if the request status is ongoing -->

							@if($request_details->status == REQUEST_ONGOING && $request_details->provider_id == Auth::guard('provider')->user()->id)

								<!-- Check the provider Status and direct to the corresponding actions -->

								<form action="{{route('provider.switch.state')}}" id="switch-form" enctype="multipart/form-data" method="POST">

									<input type="hidden" name="request_id" value="{{$request_details->id}}">

			                        @if($request_details->provider_status == PROVIDER_ACCEPTED && Auth::guard('provider')->user()->id == $request_details->provider_id)

				                        <input type="hidden" name="type" value="STARTED">

				                        <button @if($request_details->job_type == REQUEST_LATER) id="request_started" @endif class="btn btn-success switch-state-form" type="submit">
				                        	{{ tr('started') }}
				                        </button>

			                        @elseif($request_details->provider_status == PROVIDER_STARTED && Auth::guard('provider')->user()->id == $request_details->provider_id)

				                        <input type="hidden" name="type" value="ARRIVED">

				                        <button class="btn btn-success switch-state-form" type="submit">
				                        	{{ tr('arrived') }}
				                        </button>

			                        @elseif($request_details->provider_status == PROVIDER_ARRIVED && Auth::guard('provider')->user()->id == $request_details->provider_id)

				                        <input type="hidden" name="type" value="SERVICE_STARTED">

				                        <strong>{{ tr('before_image') }}</strong> : 

				                        <br> 

				                        <br>

				                        <input class="form-control" type="file" name="before_image" accept="image/*">

				                        <br>

				                        <button class="btn btn-success switch-state-form" type="submit">
				                        	{{ tr('service_started') }}
				                        </button>

			                        @elseif($request_details->provider_status == PROVIDER_SERVICE_STARTED && Auth::guard('provider')->user()->id == $request_details->provider_id)

				                        <input type="hidden" name="type" value="SERVICE_COMPLETED">
				                       
				                        <strong>{{ tr('after_image') }}</strong> :  

				                        <br>

				                        <br>

				                        <input class="form-control" type="file" name="after_image" accept="image/*">

				                        <br>

				                        <button class="btn btn-success switch-state-form" type="submit">
				                        	{{ tr('service_completed') }}
				                        </button>
			                        
			                        @endif

			                    </form>

		                    @endif

		                    <!-- Check the provider assigned to this request -->

							@if($request_details->provider_id == Auth::guard('provider')->user()->id)

								<!-- Check the allowed cancellation status -->
								
								@if($request_details->provider_status == PROVIDER_ASSIGNED || $request_details->provider_status == PROVIDER_ACCEPTED)

									<!-- <form action="{{route('provider.requests.cancel')}}" method="POST" class="">

										<input type="hidden" name="request_id" value="{{$request_details->id}}">

										<button class="btn btn-danger switch-state-form" onclick="return confirm(&apos;{{tr('request_cancel_confirm')}}&apos;)">
											{{tr('cancel')}}
										</button>
									</form> -->

									<button type="button" class="btn btn-danger" data-toggle="modal" data-target="#cancelRequestModel{{$request_details->id}}" style="width: 100%;margin-bottom: 10px; padding: 10px;">

										{{tr('cancel')}}
									</button>

								@endif

							@endif

							@if($request_details->provider_status < PROVIDER_SERVICE_COMPLETED && $request_details->status <= REQUEST_ONGOING)
						
								<div class="job-details-right">
	                                <div id="map"></div>
								</div>

							@endif

							@if(in_array($request_details->status ,[REQUEST_COMPLETE_PENDING,WAITING_PAYMENT_CONFIRM,REQUEST_RATING , REQUEST_COMPLETED]) && $request_details->provider_id == Auth::guard('provider')->user()->id)
								
								<div class="job-details-right invoice-right">

									<table>

										<tr>
											<h3 class="create-job-shadow p-5">{{tr('invoice')}}</h3>
										</tr>
										<tr>
										    <th style="width:50%">{{tr('payment_mode')}}</th>
										    <th class="text-uppercase">{{$request_details->payment_mode}}</th>
										</tr>
										<tr>
											<td>{{tr('total_time')}}</td>
											<td>{{$request_details->payments->total_time}} hrs</td>
										</tr>
										<tr>
											<td>{{tr('price_per_hour')}}</td>
											<td>
											{{$request_details->currency}} {{$request_details->price_per_hour}} {{$request_details->price_per_symbol}}
											</td>
										</tr>
										<tr>
											<td>{{tr('sub_total')}}</td>
											<td>
											{{$request_details->currency}} {{$request_details->payments->sub_total}}
											</td>
										</tr>

										<tr>
											<td>{{tr('tax_price')}}</td>
											<td>
											{{$request_details->currency}} {{$request_details->payments->tax_price}}
											</td>
										</tr>

										@if($request_details->payments->is_coupon_applied == YES)

										<tr>
											<td>{{tr('coupon_amount')}}</td>
											<td>
											{{$request_details->currency}} {{$request_details->payments->coupon_amount}}
											</td>
										</tr>

										@endif

										<tr>
											<td>{{tr('total')}}</td>
											<td>
											{{$request_details->currency}} {{$request_details->payments->total}}
											</td>
										</tr>

										<tr>
											<td>{{tr('service_fee')}}</td>
											<td>
											{{$request_details->currency}} {{$request_details->payments->admin_amount}}
											</td>
										</tr>

										<tr>
											<td>{{tr('your_earnings')}}</td>
											<td class="theme-color"><b>
											{{$request_details->currency}} {{$request_details->payments->provider_amount}}
											</b></td>
										</tr>

									</table>

									<div class="clear-fix"></div>
									
									@if($request_details->status == REQUEST_COMPLETE_PENDING)

										<h3 class="m-t-20 text-center">
											<i class="fa fa-spin fa-spinner theme-color"></i>
										</h3>

										<h3 class="m-t-20 text-center">{{tr('waiting_user_payment')}}</h3>

									@elseif($request_details->status == WAITING_PAYMENT_CONFIRM)

										<h3 class="m-t-20 text-center">{{tr('COD')}}</h3>

						                <h1 style="font-size:50px;" class="text-center">
						                	<strong>
						                	{{ $request_details->total }}
						                	</strong>
						                </h1>

						                <h5 class="text-center">{{tr('amount_to_be_paid')}}</h5>

						                <div class="panel-footer" style="background: unset;">

						                    <form method="POST" action="{{ route('provider.payment.confirm') }}" class="form-horizontal">

						                        <input type="hidden" name="request_id" value="{{$request_details->id}}">

						                        <button class="btn btn-success switch-state-form" type="submit">{{tr('paid')}}</button>

						                    </form>
						                
						                </div>

									@elseif($request_details->provider_status == PROVIDER_SERVICE_COMPLETED)

										<form class="" method="POST" action="{{route('provider.requests.rating')}}">

											<input type="hidden" name="request_id" value="{{$request_details->id}}">

											<input type="hidden" name="provider_id" value="{{$request_details->provider_id}}">


											<div class="rating-sec">

												<h3 class="">{{tr('rate_user')}}</h3>
												
												<input id="rating-system" name="rating" type="number" class="rating" min="1" max="5" step="1">

											</div>

											<div class="comment-sec">

												<h3 class="">{{tr('comment')}}</h3>

												<div class="form-group">
													<textarea name="comment" class="form-control" style="resize: none" rows="3" placeholder="{{tr('comment')}}"></textarea>
												</div>
												
											</div>								

											<button type="submit" class="btn btn-success">{{tr('submit')}}</button>

										</form>

									@else


									@endif

								</div>

							@endif
						
						</div>
						<!-- end of job-details right -->
					</div>
					
					<!-- Job details-list -->

					@if($request_details->provider_id == Auth::guard('provider')->user()->id)

						@if($request_details->before_image || $request_details->after_image)

							<div class="tracking-details row m-0 m-30">

								<div class="track-details-col col-lg-12 col-md-3 col-sm-6 col-xs-12 p-0">

									<a href="javascript:void(0);" class="track-tab complete create-job-shadow bid-heading">
										<i class="fa fa-picture-o"></i>
										{{tr('service_image')}}

									</a>
								</div>

							</div>

							<div class="job-details-row row m-0">

								@if($request_details->before_image)

									<!-- job-details-left -->
									<div class="before-img-left-col col-lg-6 col-md-6 col-sm-6 col-xs-12 p-l-0">

										<h3 class="before-tit">{{tr('before_image')}}</h3>

										<div class="bg-img before-img" style="background-image: url({{$request_details->before_image}});">
											
										</div>
									</div>

								@endif

								@if($request_details->after_image)

									<!-- job-details-left -->
									<div class="before-img-left-col col-lg-6 col-md-6 col-sm-6 col-xs-12">

										<h3 class="before-tit">{{tr('after_image')}}</h3>
										<div class="bg-img before-img" style="background-image: url({{$request_details->after_image}});">
											
										</div>


									</div>
								
								@endif

							</div>	

						@endif
						
					@endif

				</div>

			</div>
			
			<!-- end of Job content  -->
		</div>
	
	</div>

</div>

<div class="modal fade" tabindex="-1" role="dialog" id="cancelRequestModel{{$request_details->id}}" aria-labelledby="cancelRequestModelLabel">
												  	
  	<div class="modal-dialog" role="document">

    	<div class="modal-content">

    		<form action="{{route('provider.requests.cancel')}}" method="POST" class="job-form">
			
	      		<div class="modal-header btn-success">

	        		<button type="button" class="close" data-dismiss="modal" aria-label="Close">
	        			<span aria-hidden="true">&times;</span>

	        		</button>

	        		<h4 class="modal-title" id="cancelRequestModelLabel">{{tr('confirm_to_cancel_the_job')}}</h4>
	      		
	      		</div>

				<div class="modal-body">

					<input type="hidden" name="request_id" value="{{$request_details->id}}">
					
					<p class="text-gray"> {{tr('note')}} : {{tr('job_cancel_note')}}</p>

					<label>{{tr('job_cancel_label')}}</label>

					<input type="text" name="cancelled_reason" class="form-control">
					
				</div>

		      	<div class="modal-footer">

					<button type="submit" class="btn btn-danger" onclick="return confirm(&apos;{{tr('request_cancel_confirm')}}&apos;)" >{{tr('submit')}}
					</button>
		        														      	
		      	</div>
			
			</form>					     

    	</div>
  	
  	</div>

</div>

@endsection

@section('after-scripts')

<script src="{{asset('common/js/star.rating.min.js')}}"></script>

<script type="text/javascript">

$(document).ready(function() {

	$('#rating-system').rating('refresh', 
		{
			disabled: false, 
			showClear: false, 
			showCaption: false,

		}
	);

	initMap();
});

/** 
 * Used to check the request date and current date 
 */

$('#request_started').click(function() {

	var id = "{{Auth::guard('provider')->user()->id}}";

	var token = "{{Auth::guard('provider')->user()->token}}";

	var request_id = "{{$request_details->id}}";

    $.ajax({
        'url' : '{{url("/api/provider/check_provider_started")}}',
		'data' : {id : id, token : token, 
				request_id : request_id},            
        'type' : 'POST',
        'success' : function(response) {

            if (response.success == false) {

            	if(confirm(response.error)) {
            		$("#switch-form").submit();
            	} else {
            		return false;
            	}
          
            } else {
            	return true;
            }
        }
    });

return false;

});

/****************** Request Details ****************************/

    var providerStatus = {{ $request_details->provider_status }};
    var serviceStatus = {{ $request_details->status }};

    @if(isset($requests_meta))
    	var requests_meta_status = {{ $requests_meta->status }};
    @else
    	var requests_meta_status = "";

    @endif

    var request_id = {{ $request_details->id }};

    window.setInterval(function() {

        $.ajax({
            'url' : '{{ route("provider.requests.refresh.single") }}',
            'data' : {request_id : request_id},
            'type' : 'POST',
            'success' : function(response) {

                if (response.success == true) {

                    if(response.requests != "") {

                        if(response.requests.provider_status == providerStatus && response.requests.status == serviceStatus) {

                        	console.log('No LOAD');

                        } else {
                            location.reload();
                        } 
                    } else {
                        location.reload(); 
                    }

                    if(response.requests_meta != "" ) {

                    	if(response.requests_meta.status == requests_meta_status) {

                        	console.log('No LOAD');

                        } else {
                            location.reload();
                        } 

                    } else {
                    	// location.reload();
                    }
                }
            }
        
        });
    
    }, 3000);


/****************** ****************************/

    var map;
    var serviceLocation = {lat: parseFloat("{{ $request_details->s_latitude }}"), lng: parseFloat("{{ $request_details->s_longitude }}")};
    function initMap() {
        map = new google.maps.Map(document.getElementById('map'), {
            center: serviceLocation,
            zoom: 15
        });

        var marker = new google.maps.Marker({
            map: map,
            position: serviceLocation,
            visible: true,
            animation: google.maps.Animation.DROP,
        });

        var infowindow = new google.maps.InfoWindow({
            content: "{{$request_details->s_address}}",
        });

        infowindow.open(map, marker);
    }
</script>

@endsection
