@foreach($provider_subscription_payments as $key => $subscription_payment_details)

    <div class="panel panel-default m-b-10">

        <div class="panel-heading wte-bg">

            <h4 class="panel-title">

                <a data-toggle="collapse" data-parent="#accordion" href="#subscription_payment_details_{{$subscription_payment_details->provider_subscription_payment_id}}">

                    {{$subscription_payment_details->title ?: ""}}

                    @if($subscription_payment_details->status == YES)

                        <span class="pull-right"><i class="fa fa-check-circle text-success"></i></span>

                    @else

                        <span class="pull-right"><i class="fa fa-close text-success"></i></span>

                    @endif

                </a>

                <p class="credit-tap">
                    {{$subscription_payment_details->currency}} {{$subscription_payment_details->amount}} ({{common_date($subscription_payment_details->expiry_date, Auth::guard('provider')->user()->timezone, 'd M Y H A')}})
                </p>

            </h4>

        </div>

        <div id="subscription_payment_details_{{$subscription_payment_details->provider_subscription_payment_id}}" class="panel-collapse collapse">
            <div class="panel-body">

                <ul class="credits-list">

                    <li>
                        <span class="text-uppercase">
                            {{tr('category')}}:
                        </span>
                        
                        <span class="value">
                            {{$subscription_payment_details->category_name ?: "-"}}
                        </span>
                        
                    </li>

                    <li>
                        <span class="text-uppercase">
                            {{tr('payment_id')}}:
                        </span>
                        
                        <span class="value">
                            {{$subscription_payment_details->payment_id}}
                        </span>
                    </li>

                    <li>
                        <span class="text-uppercase">
                            {{tr('amount')}}:
                        </span>

                        <span class="value">
                            {{$subscription_payment_details->currency}}
                            {{$subscription_payment_details->amount}}
                        </span>
                        
                    </li>

                    <li>
                        <span class="text-uppercase">
                            {{tr('expiry_date')}}:
                        </span>

                        <span class="value">
                            {{common_date($subscription_payment_details->expiry_date)}}
                        </span>
                        
                    </li>
                    
                    <li>
                        <span class="text-uppercase">
                            {{tr('payment_mode')}}:
                        </span>

                        <span class="value">
                            {{$subscription_payment_details->payment_mode}}
                        </span>
                        
                    </li>  

                    <li>
                        <span class="text-uppercase">
                            {{tr('paid_at')}}:
                        </span>

                        <span class="value">
                            {{common_date($subscription_payment_details->updated_at)}}
                        </span>
                        
                    </li>

                    @if($subscription_payment_details->is_cancelled == YES)

                    <li>
                        <span class="text-uppercase">
                            {{tr('cancelled_reason')}}:
                        </span>

                        <span class="value">
                            {{$subscription_payment_details->cancelled_reason}}
                        </span>
                        
                    </li>

                    @endif

                </ul>
                
            </div>
        </div>

    </div>

@endforeach