@extends('layouts.provider')

@section('content')

<div class="content-wrap gray-bg">

    <div class="dashboard row m-0 p-30">
        
        <div class="container">

            @if(Auth::guard('provider')->user()->is_approved == PROVIDER_STATUS_PENDING)
            
                <div class="alert alert-danger text-uppercase">
                    {{tr('provider_waiting_for_admin_approval')}}
                </div>

            @endif
                
            @include('notification.notify')

            <!-- Dashboard Right -->

            <div class="dashboard-right-col col-lg-10 col-md-10 col-sm-12 col-xs-12 col-lg-offset-1 col-md-offset-1">   

                <div class="main">

                    <div class="col-md-12">
             
                        <h2 class="m-0 top">{{tr('subscriptions')}}</h2>

                        <p class="top text-grey">{{tr('provider_subscriptions_content')}}</p>

                        <div class="top1">

                            <a class="button" href="{{ route('provider.subscriptions.index')}}">{{tr('subscribe_now')}}</a>

                        </div>

                    </div>

                    <div class="clearfix"></div>

                    <!-- history start -->

                    <div class="col-md-12 box white-bg top1 border-cls">

                        <h4>{{tr('history')}}</h4>

                        <p class="grey-clr m-0">{{tr('subscriptions_history_note')}}</p>

                        <!-- =========ACCORDION STARTS====== -->

                        <div class="panel-group top" id="accordion">

                            @include('provider.subscriptions._history')

                            <div id="history-loadmore-content"></div>

                        </div>

                        @if(count($provider_subscription_payments) == 0 )

                        <p class="text-grey" id="history-no-result">{{tr('no_result_found')}}</p>

                        @endif

                        <div id="history-count" style="display: none;">{{count($provider_subscription_payments)}}</div>

                        <div class="btn btn-info history-loadmore " id="history-loadmore">
                            <b><span id="load_more_text">{{count($provider_subscription_payments)>5 ? tr('load_more') : tr('refresh')}}</span></b>
                        </div>

                        <!-- =======ACCORDION ENDS=======  -->
                    
                    </div>

                    <!-- history end -->
                            
                </div>
            </div>
            <!-- End of dashboard right -->
        
        </div>
    
    </div>

</div>

@endsection

@section('after-scripts')

<script type="text/javascript">

    document.getElementById("uploadBtn").onchange = function () {
        document.getElementById("uploadFile").value = this.value;
    };
    
    document.getElementById("uploadBtn1").onchange = function () {
        document.getElementById("uploadFile1").value = this.value;
    };
</script>

@endsection