@extends('layouts.provider')

@section('content')

<div class="content-wrap gray-bg">

    <div class="dashboard row m-0 p-30">
        
        <div class="container">

            @if(Auth::guard('provider')->user()->is_approved == PROVIDER_STATUS_PENDING)
            
                <div class="alert alert-danger text-uppercase">
                    {{tr('provider_waiting_for_admin_approval')}}
                </div>

            @endif
                
            @include('notification.notify')

            <div class="dashboard-right-col col-lg-10 col-md-10 col-sm-12 col-xs-12 col-lg-offset-1 col-md-offset-1">   

                <div class="main">

                    <div class="col-md-12">
             
                        <h2 class="m-0 top">{{tr('subscriptions')}}
                        @if($category_details)   
                            -                     
                            {{ $category_details->name}}
                        @endif
                        </h2>

                        <p class="top text-grey">{{tr('provider_subscriptions_content')}}</p>

                    </div>
                                
                    <div class="clearfix"></div>
                    
                    @if(count($provider_subscriptions) > 0)
                    
                        <div class="spacing">

                            @foreach($provider_subscriptions as $s => $provider_subscription_details)

                                <div class="columns col-lg-4">
                                    <ul class="price">
                                        <li class="header">{{$provider_subscription_details->title}}</li>
                                        
                                        <li class="grey">
                                            {{Setting::get('currency')}} {{$provider_subscription_details->amount}}
                                            / {{$provider_subscription_details->plan}} {{$provider_subscription_details->plan_type}}
                                        </li>
                                                                            
                                        <li style="max-height: 80px;min-height: 80px">
                                            {{ substr($provider_subscription_details->description, 0 , 90) }}
                                        </li>
                                        
                                        <li class="grey">

                                            <a href="{{ route('provider.subscriptions.invoice',[ 'provider_subscription_id' => $provider_subscription_details->provider_subscription_id ])}}" class="button">{{ tr('pay_now') }}</a>

                                        </li>

                                    </ul>
                                
                                </div> 

                            @endforeach

                        </div>
                    
                    @endif
                
                    <div class="clearfix"></div>

                </div>

            </div>

        </div>
    
    </div>

</div>

@endsection