@extends('layouts.provider')

@section('content')

<div class="content-wrap gray-bg">

    <div class="dashboard row m-0 p-30">
        
        <div class="container">

            @if(Auth::guard('provider')->user()->is_approved == PROVIDER_STATUS_PENDING)
            
                <div class="alert alert-danger text-uppercase">
                    {{tr('provider_waiting_for_admin_approval')}}
                </div>

            @endif
                
            @include('notification.notify')

            <!-- end of dashboard left -->
            <div class="dashboard-right-col col-lg-10 col-md-10 col-sm-12 col-xs-12 col-lg-offset-1 col-md-offset-1">   

                <div class="main">

                    <center>
                        <a class="pull-right btn btn-success" href="{{route('provider.cards')}}">
                            <i class="theme-color fa fa-credit-card"></i>{{tr('cards')}}
                        </a>
                    </center>

                    <div class="col-12 col-xs-12 col-sm-12 col-md-12 col-lg-12 ">

                        <div class="section-side-spacing section-top-bottom-spacing">
                            
                            <h3 class="m-0 top text-center">{{tr('subscription_invoice')}}</h3>

                            <div class="panel panel-default top1">

                                <div class="panel-body">
                                    
                                    <div>
                                        
                                        <p class="lead">{{tr('invoice')}}</p>

                                        <div class="table-responsive">

                                            <table class="table">
                                                
                                                <tr>
                                                    <th>{{ tr('category') }}</th>
                                                    <td>{{ $provider_subscription_details->category_name }}</td>
                                                </tr>
                                           
                                                <tr>
                                                    <th>{{ tr('title') }}</th>
                                                    <td>{{ $provider_subscription_details->title }}</td>
                                                </tr>

                                                <tr>
                                                    <th>{{ tr('plan') }}</th>
                                                    <td>{{ $provider_subscription_details->plan }} {{$provider_subscription_details->plan_type}}</td>
                                                </tr> 

                                                <tr>
                                                    <th>{{ tr('amount')}}</th>
                                                    <td>{{  Setting::get('currency') }} {{ $provider_subscription_details->amount }}</td>
                                                </tr> 

                                                <tr>
                                                    <th>{{ tr('description')}}</th>
                                                    <td><?php echo $provider_subscription_details->description ?></td>
                                                </tr>

                                                <tr>
                                                    <th>{{ tr('date')}}</th>
                                                    <td>{{ date('d M y') }}</td>
                                                </tr>
                                                
                                            </table>
                                       
                                            <form action="{{ route('provider.subscriptions.save') }}" method="POST" role="form">

                                                <p>
                                                    <span class="btn btn-danger pull-left" style="cursor: default;">{{  Setting::get('currency') }} {{ $provider_subscription_details->amount }}</span>
                                                    
                                                    <input type="hidden" name="plan" value="{{$provider_subscription_details->plan}}">

                                                    <input type="hidden" name="provider_id" value="{{$provider_details->id}}">

                                                    <input type="hidden" name="provider_subscription_id" value="{{$provider_subscription_details->provider_subscription_id}}">
                                                 
                                                    <button type="submit" class="btn btn-success pull-right" @if(Setting::get('admin_delete_control') == YES) disabled @endif) >{{ tr('choose') }}</button> 
                                                </p>

                                            </form>
                                        
                                        </div>
                                    
                                    </div>
                                
                                </div>

                            </div>

                        </div>

                    </div>                

                </div>

            </div>

        </div>
    
    </div>

</div>

@endsection