@extends('layouts.common.common')

@section('content')

<div class="content-wrap">

	<!-- INTRO SECTION
	==================================== -->
	<div class="intro-section one-slide">

		@foreach($banner_image as $image)
	
		<div class="intro-banner bg-img" style="background-image: url({{$image->picture ? $image->picture : asset('common/img/banner.jpg')}});">
			<div class="banner-content">
				<div>
					@if($image->banner_title)
					<h1 class="intro-tit text-center">{{$image->banner_title ? $image->banner_title : ""}}</h1>
					<div class="divider1"></div>
					@endif
					<p class="intro-txt text-center">{{$image->banner_text ? $image->banner_text : ""}}</p>
				</div>
			</div>
		</div>

		@endforeach
	</div>
	<!-- END OF INTRO SECCTION -->

	<!-- LANDING SECTION
	===================================== -->
	<div class="landing-section row m-0 gray-bg p-30">
		<div class="container">
			<h3 class="main-tit">{{tr('skilled_specilists')}}</h3>
			<div class="landing-sec-left-col col-lg-8 col-md-8 col-sm-8 col-xs-12">
				<div class="landing-content1 white-bg bg-img" style="background-image: url({{asset('common/img/landing-1.jpg')}});">
					<div class="landing-content1-outer">
						<div class="landing-content1-inner white-bg text-center">
							<h3 class="main-sub-tit">{{tr('trusted_handyman')}}</h3>
							<p class="main-txt landing-txt1">{{tr('handyman_help_content')}}</p>
						</div>
					</div>
				</div>
			</div>

			<div class="landing-sec-right-col col-lg-4 col-md-4 col-sm-4 col-xs-12">
				<div class="landing-content2 text-center bg-img" style="background-image: url({{asset('common/img/landing-3.jpg')}});">
					<div class="landing-content2-inner">
						<h3 class="main-sub-tit">{{tr('no_more_diy_disaster')}}</h3>
						<p class="main-txt landing-txt">{{tr('no_more_diy_disaster')}}</p>
					</div>
				</div>
			</div>
		</div>
	</div>
	<!-- END OF LANDING SECTION -->

	<!-- LANDING SECTION
	===================================== -->
	<div class="landing-section row m-0 gray-bg p-30">
		<div class="container">
			<h3 class="main-tit">{{tr('skilled_specilists')}}</h3>
			<div class="landing-sec-left-col col-lg-8 col-md-8 col-sm-8 col-xs-12">
				<div class="landing-content1 white-bg bg-img" style="background-image: url({{asset('common/img/landing-4.jpg')}});">
					<div class="landing-content1-outer">
						<div class="landing-content1-inner white-bg text-center">
							<h3 class="main-sub-tit">{{tr('spotless_house')}}</h3>
							<p class="main-txt landing-txt1">{{tr('want_quality_cleaning')}}</p>
						</div>
					</div>
				</div>
			</div>

			<div class="landing-sec-right-col col-lg-4 col-md-4 col-sm-4 col-xs-12">
				<div class="landing-content2 text-center bg-img" style="background-image: url({{asset('common/img/landing-7.jpg')}});">
					<div class="landing-content2-inner">
						<h3 class="main-sub-tit">{{tr('choose_everclean')}}</h3>
						<p class="main-txt landing-txt">{{tr('quality_repeat_cleanings')}}</p>
					</div>
				</div>
			</div>
		</div>
	</div>
	<!-- END OF LANDING SECTION -->

	<!-- TASK WROK SECTION
	====================================== -->
	<div class="task-work row m-0 white-bg p-30">
		<div class="container">
			<h3 class="main-tit">Put {{Setting::get('site_name')}} to Work</h3>

			<!-- Task work box start -->
			@foreach($sub_categories as $sub_category)

				<div class="task-work-col col-lg-4 col-md-4 col-sm-6 col-xs-12">
					<div class="task-work-box bg-img" style="background-image: url({{$sub_category->picture}});">
						<div class="task-work-box-inner">
							<h3 class="task-work-tit home-cat-image">{{$sub_category->name}}</h3>
							<a href="{{route('user.login.form')}}" class="common-bg-link task-work-link">{{tr('book_now')}}</a>
						</div>
					</div>
				</div>
				
			@endforeach
			<!-- End of task box -->
		</div>
	</div>
	<!-- END OF TASK WORK SECTON -->

	<!-- HOW ITS WORK SECTION
	====================================== -->
	<div class="how-its-work row m-0 gray-bg  p-30">
		<div class="container">
			<h3 class="main-tit">{{tr('how_it_works')}}</h3>
			<!-- How its work box -->
			<div class="how-its-work-col col-lg-4 col-md-4 col-sm-6 col-xs-12">
				<div class="how-its-work-box text-center">
					<div class="how-its-work-icon bg-img" style="background-image: url({{asset('common/img/how-its-work.png')}});">
					</div>
					<div class="how-its-work-content">
						<h3 class="how-its-work-tit">{{tr('describe_task')}}</h3>
						<p class="how-its-work-txt">{{tr('choose_variety_home_service')}}</p>
					</div>
				</div>
			</div>
			<!-- End of how its work box -->
			<!-- How its work box -->
			<div class="how-its-work-col col-lg-4 col-md-4 col-sm-6 col-xs-12">
				<div class="how-its-work-box text-center">
					<div class="how-its-work-icon bg-img" style="background-image: url({{asset('common/img/how-its-work.png')}});">
					</div>
					<div class="how-its-work-content">
						<h3 class="how-its-work-tit">{{tr('get_matched')}}</h3>
						<p class="how-its-work-txt">{{tr('select_from_list_qualified')}}</p>
					</div>
				</div>
			</div>
			<!-- End of how its work box -->
			<!-- How its work box -->
			<div class="how-its-work-col col-lg-4 col-md-4 col-sm-6 col-xs-12">
				<div class="how-its-work-box text-center">
					<div class="how-its-work-icon bg-img" style="background-image: url({{asset('common/img/how-its-work.png')}});">
					</div>
					<div class="how-its-work-content">
						<h3 class="how-its-work-tit">{{tr('get_done')}}</h3>
						<p class="how-its-work-txt">{{tr('tasker_arrive_get_jobs')}}</p>
					</div>
				</div>
			</div>
			<!-- End of how its work box -->
		</div>
	</div>
	<!-- END OF HOW ITS WORK SECTION -->

	<!-- FEATURES SECTION
	====================================== -->
	<div class="features row m-0 p-30 bg-img" style="background-image: url({{asset('common/img/landing-9.png')}});">
		<div class="container">
			<!-- features-box -->
			<div class="features-col col-lg-4 col-md-4 col-sm-4 col-xs-12">
				<div class="features-box">
					<div class="features-img bg-img" style="background-image: url({{asset('common/img/jogging.png')}});">
						
					</div>
				</div>
			</div>
			<!-- End of features box -->
			<!-- features-box -->
			<div class="features-col col-lg-4 col-md-4 col-sm-4 col-xs-12">
				<h3 class="features-tit">{{tr('we_do_chores')}}</h3>
				<ul class="features-list list-unstyled">
					<li>
						<i class="ion-checkmark-round"></i>
						{{tr('hang_your_shelves')}}
					</li>
					<li>
						<i class="ion-checkmark-round"></i>
						{{tr('run_errands')}}
					</li>
					<li>
						<i class="ion-checkmark-round"></i>
						{{tr('paint_apartment')}}
					</li>
					<li>
						<i class="ion-checkmark-round"></i>
						{{tr('pick_up_clatter')}}
					</li>
				</ul>
			</div>
			<!-- End of features box -->
			<!-- features-box -->
			<div class="features-col col-lg-4 col-md-4 col-sm-4 col-xs-12">
				<h3 class="features-tit">{{tr('you_live_life')}}</h3>
				<ul class="features-list list-unstyled">
					<li>
						<i class="ion-checkmark-round"></i>
						{{tr('hangout_your_kids')}}
					</li>
					<li>
						<i class="ion-checkmark-round"></i>
						{{tr('run_park')}}
					</li>
					<li>
						<i class="ion-checkmark-round"></i>
						{{tr('paint_masterpiece')}}
					</li>
					<li>
						<i class="ion-checkmark-round"></i>
						{{tr('pick_up_new_hobby')}}
					</li>
				</ul>
			</div>
			<!-- End of features box -->
		</div>
	</div>
	<!-- END OF FEATURES SECTION -->

	<!-- HOW ITS WORK SECTION
	====================================== -->
	<div class="how-its-work row m-0 gray-bg  p-30">
		<div class="container">
			<h3 class="main-tit">{{tr('when_you_need')}}</h3>
			<!-- How its work box -->
			<div class="how-its-work-col col-lg-4 col-md-4 col-sm-6 col-xs-12">
				<div class="how-its-work-box text-center">
					<div class="how-its-work-icon bg-img" style="background-image: url({{asset('common/img/how-its-work.png')}});">
					</div>
					<div class="how-its-work-content">
						<h3 class="how-its-work-tit">{{tr('save_your_time')}}</h3>
						<p class="how-its-work-txt">{{tr('you_able_to_accomplish_more')}}</p>
					</div>
				</div>
			</div>
			<!-- End of how its work box -->
			<!-- How its work box -->
			<div class="how-its-work-col col-lg-4 col-md-4 col-sm-6 col-xs-12">
				<div class="how-its-work-box text-center">
					<div class="how-its-work-icon bg-img" style="background-image: url({{asset('common/img/how-its-work.png')}});">
					</div>
					<div class="how-its-work-content">
						<h3 class="how-its-work-tit">{{tr('same_day_help')}}</h3>
						<p class="how-its-work-txt">{{tr('need_it_done_now')}}</p>
					</div>
				</div>
			</div>
			<!-- End of how its work box -->
			<!-- How its work box -->
			<div class="how-its-work-col col-lg-4 col-md-4 col-sm-6 col-xs-12">
				<div class="how-its-work-box text-center">
					<div class="how-its-work-icon bg-img" style="background-image: url({{asset('common/img/how-its-work.png')}});">
					</div>
					<div class="how-its-work-content">
						<h3 class="how-its-work-tit">{{tr('trust_safety')}}</h3>
						<p class="how-its-work-txt">{{tr('our_taskers_vetting_process')}}</p>
					</div>
				</div>
			</div>
			<!-- End of how its work box -->
			<div class="need-link-outer text-center col-md-12">
			</div>
		</div>
	</div>
	<!-- END OF HOW ITS WORK SECTION -->

	<!-- BECOME TASKER SECTION
	====================================== -->
	<div class="become-tasker row m-0 bg-img" style="background-image: url({{asset('common/img/landing-10.jpg')}});">
		<div class="container">
			<div class="become-tasker-col col-lg-7 col-md-7 col-sm-6 col-xs-12">
				
			</div>
			<div class="become-tasker-col col-lg-5 col-md-5 col-sm-6 col-xs-12">
		 		<div class="become-tasker-box white-bg text-center">
					<h3 class="main-sub-tit">{{tr('become_tasker')}}</h3>
					<p class="main-txt landing-txt1">{{tr('when_you_work')}} {{Setting::get('site_name')}}, {{tr('you_control_your_schedule')}}</p>
					<a href="{{route('provider.register.form')}}" class="green-border-link">{{tr('register_now')}}</a>
				</div>
			</div>
		</div>
	</div>
	<!-- END OF BECOME TASKER SECTION -->

</div>
<!-- END OF CONTENT-PANEL -->

@endsection