@extends('layouts.user')

@section('after-styles')
<style>
	.btn-default.active {
		color: #fff !important;
	    background-color: #51af33 !important;
	    border-color: #51af33 !important;
	}
	.set-payment {
		    box-shadow: 0px 1px 2px 1px #e1e1e1;
    	padding-bottom: 20px;
	}
	.heading-underline {
		width: 11% !important;
	    display: block;
	    border: 1px solid #51af33;
	}
</style>
@endsection

@section('content')

<div class="content-wrap gray-bg">

	<div class="dashboard row m-0 p-30">
		
		<div class="container">

			@include('notification.notify')

			<!-- Dashboard Left -->
			<div class="dashboard-left-col col-lg-12 col-md-12 col-sm-12 col-xs-12">
			
				<div class="col-md-8">

				<h2 class="no-margin">Sperad the word and earn rewards</h2>

				<p class="text-gray referrals-text">When someone signs up with your unique referral link, you will get below benifits</p>

				<li class="referrals-text">Subscription commission</li>

				<h4 class="shareUrl-headerText">Click to Copy Invite Link</h4>
	        	
	        	<p class="text-gray"></p>

	        	<input class="shareUrl-input js-shareUrl" type="text" readonly="readonly" />

			</div>

			<div class="col-sm-4" style="background: white">

				<div style="padding: 15px 3px">

			    <div class="card">

			        <div class="card-body">

			            <h5 class="card-title" style="margin-bottom: 15px">{{tr('referrals')}}</h5>
		            	
		            	<p>{{tr('total')}} <span class="pull-right">{{$user_referrer_details->total_referrals}}</span></p>
		            	<hr>

		            	<p>Earnings <span class="pull-right"> {{Setting::get('currency')}} {{$user_referrer_details->total_referrals_earnings ?: 0.00}}</span></p>
		            	<hr>
			            
			        </div>

			    </div>

			    </div>

			</div>

			<div class="clearfix"></div>

			<div class="col-md-12">

				<div>

					<hr>

					<h3> <span class="text-gray"></span>{{tr('referrals')}}</h3>

					<hr>

					<div class="card">

            			<div class="card-body">

							<div class="card">

		            			<div class="card-body">

									<table id="example2" class="table table-bordered table-striped table-responsive referral-table">

										<thead>
											<tr style="background: white">
								      			<th>{{tr('s_no')}}</th>
								      			<th>{{tr('image')}}</th>
								      			<th>{{tr('username')}}</th>
								      			<th>{{tr('referral_code')}}</th>
								      			<th>{{tr('created')}}</th>
								      			<th>{{tr('action')}}</th>
								      		</tr>
										</thead>

										<tbody>

											@foreach($referrals as $key => $referral_details)

											<tr>
												<td>{{$key+1}}</td>
											
												<td >
													<img src="{{$referral_details->picture?: asset('placeholder.png')}}" class="img img-circle" style="width: 50px;height: 50px">
												</td>

												<td>
													@if(!$referral_details->username)
														{{tr('user_not_available')}}	
									      			@else
									      				{{ $referral_details->username }}
									      			@endif
												</td>

												<td>{{$referral_details->referral_code}}</td>
												
												<td>{{$referral_details->created_at}}</td>
												
												<td>
													<a href="{{route('user.referrals.view', ['user_id' => $referral_details->user_id, 'parent_user_id' => $referral_details->parent_user_id])}}" class="btn btn-info">
														{{tr('more')}} <i class="fa fa-angle-right"></i><i class="fa fa-angle-right"></i>
													</a>
												</td>
											</tr>

											@endforeach

										</tbody>

									</table>

								</div>

							</div>

						</div>

					</div>

				</div>

			</div>

			</div>
			
		</div>
	
	</div>

</div>



@endsection

@section('after-scripts')

    <link rel="stylesheet" href="{{ asset('admin-css/plugins/datatables/dataTables.bootstrap.css')}}">

	<script src="{{asset('admin-css/plugins/datatables/jquery.dataTables.min.js')}}"></script>

    <script src="{{asset('admin-css/plugins/datatables/dataTables.bootstrap.min.js')}}"></script>

	<script>

		$(function () {

		    $("#example1").DataTable();

		    $('#example2').DataTable({
		        "paging": true,
		        "lengthChange": false,
		        "searching": false,
		        "ordering": true,
		        "info": true,
		        "autoWidth": false
		    });
		    
		    // Create reusable copy function

		    function copy(element) {
		        
		        return function() {
		          	document.execCommand('copy', false, element.select());
		        }
		    }
		    
		    // Grab shareUrl element
		    var shareUrl = document.querySelector('.js-shareUrl');

		    // Create new instance of copy, passing in shareUrl element
		    var copyShareUrl = copy(shareUrl);
		    
		    // Set value via markup or JS
		    shareUrl.value = "{{route('referrals_signup', $user_referrer_details->referral_code)}}";
		  
		    // Click listener with copyShareUrl handler
		    shareUrl.addEventListener('click', copyShareUrl, false);
		  
		}());
		
	</script>
@endsection