@extends('layouts.user.focused')

@section('content')

<div class="main-content">

    <div class="task-choose bg-img" style="background-image: url({{asset('common/img/login-bg.jpg')}});">
        
        <div class="task-choose-outer">
            
            <div class="task-choose-inner white-bg">

                <a class="task-logo" href="{{route('home')}}">
                    <div class="bg-img logo" style="background-image: url({{Setting::get('site_logo')}});"></div>
                </a>

                @include('notification.notify')

                <div class="social-net row">

                    @if(config('services.facebook.client_id') && config('services.facebook.client_secret'))

                        <div class="col-md-6">

                            <form action="{{route('SocialLogin')}}" method="POST" class="">
                                
                                <input type="hidden" value="facebook" name="provider" id="provider">
                                
                                <input type="submit" style="width: 100%;box-shadow: 0"  class="facebook" name="facebook" value="{{tr('facebook')}}" />


                            </form>

                        </div>
                        
                    @endif

                    @if(config('services.google.client_id') && config('services.google.client_secret'))

                        <div class="col-md-6">

                            <form action="{{route('SocialLogin')}}" method="POST" role="form" class="">

                                <input type="hidden" value="google" name="provider" id="provider">
                                
                                <input type="submit" style="width: 100%;box-shadow: 0" class="google" name="google" value="{{tr('google')}}" />

                            </form>

                        </div>

                    @endif

                </div>

                <form class="login-form" role="form" method="POST" action="{{route('user.login.post')}}">

                    <input type="hidden" name="timezone" value="" id="userTimezone">

                    <div class="form-group @if ($errors->has('email')) has-error @endif">
                        <label>{{tr('email')}}</label>
                        <input type="email" required class="form-control" name="email" value="{{ old('email') ? old('email') : Setting::get('demo_user_email')}}" placeholder="{{tr('enter_email')}}">
                       
                        @if ($errors->has('email')) <p class="help-block">{{ $errors->first('email') }}</p> @endif

                    </div>

                    <div class="form-group @if ($errors->has('password')) has-error @endif">
                        <label>{{tr('password')}}</label>
                        <input type="password" required class="form-control" name="password" placeholder="{{tr('enter_password')}}" value="{{old('password') ? old('password'): Setting::get('demo_user_password')}}">

                        @if ($errors->has('password')) <p class="help-block">{{ $errors->first('password') }}</p> @endif
                    </div>

                    <button type="submit" class="btn btn-primary sub-btn">{{tr('submit')}}</button>


                    <p class="login-txt btm-txt text-center">
                        <a href="{{route('user.password.reset')}}" class="forgot-link common-link">{{tr('forgot_password')}}</a>
                    </p>

                    <p class="login-txt btm-txt text-center">{{tr('dont_have_account')}}
                        <a href="{{route('user.register.form')}}" class="common-link">{{tr('signup')}}</a>
                    </p>

                    <p class="login-txt btm-txt text-center">{{tr('signup_agree')}} 
                        <a href="{{route('terms')}}" target="_blank"  class="common-link">{{tr('terms')}}</a> {{tr('and')}} 
                        <a href="{{route('privacy')}}"  target="_blank" class="common-link">{{tr('privacy')}}</a></p>
                </form>
            </div>

        </div>    

    </div>

</div>

@endsection

@section('scripts')
<script src="{{asset('common/js/jstz.min.js')}}"></script>
<script>
    
    $(document).ready(function() {

        var dMin = new Date().getTimezoneOffset();
        var dtz = -(dMin/60);
        // alert(dtz);
        $("#userTimezone").val(jstz.determine().name());
    });

    $('form').submit(function () {
        $(this).find(':submit').attr('disabled', 'disabled');
    });

</script>

@endsection
