@extends('layouts.common.focused')

@section('content')

<div class="main-content">
    <div class="task-choose bg-img" style="background-image: url({{asset('common/img/login-bg.jpg')}});">
        
        <div class="task-choose-outer">

            <div class="task-choose-inner white-bg">

                <a class="task-logo" href="{{route('home')}}">
                    <div class="bg-img logo" style="background-image: url({{Setting::get('site_logo')}});"></div>
                </a>

                @include('notification.notify')
                
                <form class="login-form" method="POST" action="{{ url('/password/email') }}">
                    {!! csrf_field() !!}

                    <div class="form-group">
                        <label>{{tr('email')}}</label>
                        <input type="email" name="email" class="form-control" placeholder="{{tr('email')}}">
                        @if ($errors->has('email'))
                            <span class="help-block">
                                <strong>{{ $errors->first('email') }}</strong>
                            </span>
                        @endif
                    </div>
                    <button type="submit" class="btn btn-primary sub-btn">{{tr('submit')}}</button>

                    <p class="login-txt btm-txt text-center">{{tr('already_have_account')}} <a href="{{route('user.login.form')}}" class="common-link">{{tr('login')}}</a></p>
                    
                    <p class="login-txt btm-txt text-center">{{tr('reset_mail_content')}}</p>
                </form>
            </div>

        </div>    

    </div>
</div>  


@endsection
