@extends('layouts.user')

@section('after-styles')
<style>
	.truncate {
	  width: 15em;
	  white-space: nowrap;
	  overflow: hidden;
	  text-overflow: ellipsis;
	}
</style>
@endsection

@section('content')

<div class="content-wrap gray-bg">

		<div class="container">

			@include('notification.notify')

			<div class="jobs white-bg m-30 p-f-30">


				<h3>{{tr('jobs_cancelled')}}</h3>

				<div class="row">

					<div class="col-md-3"></div>

					<div class=" col-md-3"></div>

					<div class="top col-sm-6 col-md-3">
						<input type="text" name="cancelled_job_search" id="cancelled_job_search" class="form-control" placeholder="{{tr('search_job_title')}}" onkeyup="searchCancelled(this.value, false, 0)">
					</div>
					<div class="top col-sm-6 col-md-3">
						<select class="form-control" id="cancelled_sorting_key" name="sorting" onchange="searchCancelled(this.value, true, 0)">
							<option value="">{{tr('sort')}}</option>
							<option value="asc">{{tr('sort_by_a_z')}}</option>
							<option value="desc">{{tr('sort_by_z_a')}}</option>
						</select>
					</div>
				</div>
				<br>


				<div class="clearfix"></div>

				<div class="clearfix"></div> 

				<div id="default_cancelled">

				@foreach($cancelled_requests as $pr => $cancelled_request)

					<div class="dashboard-list row m-0 create-job-shadow">

						<!-- Dashboard-list-box -->
						<div class="dashboard-list-col col-lg-4 col-md-12 col-sm-12 col-xs-12">
							<div class="dashboard-list-box">
								<h3 class="dashboard-list-tit truncate">{{$cancelled_request->name}}</h3>
								<p class="dashboard-list-txt">
									<span><b>{{tr('request_date')}} : </b> {{$cancelled_request->request_date}} </span>
								</p>
							</div>
						</div>
						<!-- End of dashboard-list-box -->

						<!-- Dashboard-list-box -->
						<div class="dashboard-list-col col-lg-3 col-md-12 col-sm-12 col-xs-12">
							<div class="dashboard-list-box">
								<p class="dashboard-list-txt">
									<i class="ion-arrow-graph-up-left"></i> 
									{{$cancelled_request->category_name}}
								</p>
								<p class="dashboard-list-txt">
									<i class="ion-arrow-graph-down-left"></i> 
									{{request_type($cancelled_request->request_type)}}
								</p>
							</div>
						</div>
						<!-- End of dashboard-list-box -->

						<!-- Dashboard-list-box -->
						<div class="dashboard-list-col col-lg-2 col-md-12 col-sm-12 col-xs-12">
							<div class="dashboard-list-box">
								<p class="dashboard-list-txt m-t-20">
								 	<i class="fa fa-info-circle"></i>
								 	{{$cancelled_request->currency}} {{$cancelled_request->price_per_hour}} {{$canceller_request->price_per_symbol}}
								</p>
							</div>
						</div>
						<!-- End of dashboard-list-box -->

						<!-- Dashboard-list-box -->
						<div class="dashboard-list-col col-lg-3 col-md-12 col-sm-12 col-xs-12">
						
							<div class="dashboard-list-box">

								<a href="{{route('user.jobs.view' , ['request_unique_id' => $cancelled_request->unique_id])}}" class="btn btn-success m-t-15 text-center"><i class="fa fa-eye"></i> {{tr('view')}}</a>

							</div>
						</div>
						<!-- End of dashboard-list-box -->
					
					</div>

				@endforeach

				<div id="cancelled_requests"></div>

				<div id="cancelled_loader"></div>

			</div>

		</div>
	</div>

@endsection

@section('after-scripts')

<script>

var cancelledLength = "{{count($cancelled_requests)}}";

var stopScroll = false;

var searchLength = 0;

function cancelledRequests(value) {

	console.log("skip value"+value);

	console.log(searchLength);

	$.ajax ({

		type : "POST",

		url : "{{route('user.cancelled_requests')}}",

		beforeSend : function () {

			$("#cancelled_loader").html('<h1 class="text-center theme-color"><i class="fa fa-spinner fa-spin"></i></h1>');
		},

		data : {skip : value},

		async : false,

		success : function (data) {

			$("#cancelled_requests").append(data.view);

			if (data.length == 0) {

				stopScroll = true;

			} else {

				stopScroll = false;

				cancelledLength = parseInt(cancelledLength) + data.length;

			}

		}, 

		complete : function() {

			$("#cancelled_loader").html('');

		},

		error : function (data) {


		},

	});

}

function searchCancelled(val, status, searchLength) {

	$("#default_cancelled").html("");

	$("#cancelled_requests").html("");

	if (status) {

		var sorting_key = val;

		var searching_key = $("#cancelled_job_search").val();

	} else {

		var sorting_key = $("#cancelled_sorting_key").val();

		var searching_key = val;
	}

	$.ajax ({

		type : "POST",

		url : "{{route('user.cancelled_requests')}}",

		beforeSend : function () {

			$("#cancelled_loader").html('<h1 class="text-center theme-color"><i class="fa fa-spinner fa-spin"></i></h1>');
		},

		data : {skip : searchLength, search_key : searching_key, sorting_status : status, sorting_key : sorting_key},

		async : false,

		success : function (data) {

			$("#cancelled_requests").append(data.view);

			console.log(parseInt(data.length) == 0);

			if (parseInt(data.length) == 0) {

				stopScroll = true;

			} else {

				stopScroll = false;

				searchLength = parseInt(searchLength) + data.length;

			}

		}, 

		complete : function() {

			$("#cancelled_loader").html('');

		},

		error : function (data) {


		},

	});

}

$(window).scroll(function() {

    if($(window).scrollTop() == $(document).height() - $(window).height()) {

    	if (!stopScroll) {

			if (searchLength > 0) {

				var cancelKeyWord = $("#cancelled_job_search").val();

				var cancelSearchWord = $("#cancelled_sorting_key").val();

				if (cancelKeyWord != '') {

					var status = false;

					var word = cancelKeyWord;

				} else {

					var status = true;

					var word = cancelSearchWord;

				}

				searchCancelled(word, status, searchLength);

			} else {

				cancelledRequests(cancelledLength);

			}	    	

    	}
    }
});

</script>

@endsection