@extends('layouts.user')

@section('after-styles')

<style>

.chat-contact > img {
    height: 40px;
    width: 40px;
}

</style>

@endsection

@section('content')

<div class="content-wrap gray-bg">

	<div class="container">
		<div class="chat white-bg m-30 p-f-30 row">
			<div class="row m-0">
				<h3 class="chat-tit pull-left">{{$request_details->name}}</h3>
				<a href="{{route('user.jobs.view' , $request_details->unique_id)}}" class="common-bg-link pull-right back-btn">{{tr('back')}}</a>
			</div>

			<div class="chat-sec-left-col col-lg-5 col-md-5 col-sm-12 col-xs-12">
				<div class="chat-sec-left">
					<div class="incoming-img bg-img" style="background-image: url({{$provider->picture}});">
			        </div>
					<div class="table-responsive incoming-table">
						<table class="table table-responsive">
							<thead>
								<tr>
									<th>{{tr('name')}}</th>
									<th>{{$provider->name}}</th>
								</tr>
							</thead>
							<tbody>
								<tr>
									<th scope="row">{{tr('job_type')}}</th>
									<td>{{job_type($request_details->job_type)}}</td>
								</tr>
								<tr>
									<th scope="row">{{tr('request_type')}}</th>
									<td>{{request_type($request_details->request_type)}}</td>
								</tr>
								<tr>
									<th scope="row">{{tr('category')}}</th>
									<td>{{$request_details->category->name}}</td>
								</tr>
								
								<tr>
                                    <th scope="row">{{tr('initial_per_hour_price')}}</th>
                                    <td>{{$request_details->currency}}{{$request_details->user_price}}{{$request_details->price_per_symbol}}</td>
                                </tr>

                                <tr>
                                    <th scope="row">{{tr('price_per_hour')}}</th>
                                    <td>{{$request_details->currency}}{{$request_details->price_per_hour}}{{$request_details->price_per_symbol}}</td>
                                </tr>
							</tbody>
						</table>
					</div>
				</div>
			</div>

			<div class="chat-sec-right-col col-lg-7 col-md-7 col-sm-12 col-xs-12">
				<div class="chat-sec">
					<div class="chat-head row m-0">
						<span class="chat-img bg-img" style="background-image: url({{$provider->picture}});">
						</span>
						<span>{{tr('chat_with')}} {{$provider->name}}</span>
					</div>

					<div class="chat-content row m-0">

						<div class="chat-content-inner" id="chat-box">

							<!-- Chat messages -->

						</div>


						<div class="input-group send-msg">

						  	<input type="text" class="form-control" id="chat-input" placeholder="Type Here" aria-describedby="">

						  	<span class="input-group-addon" id="chat-send">
						  		<i class="ion-android-send"></i>
						  	</span>

						</div>

					</div>
				</div>
			</div>
		</div>
	
	</div>

</div>

@endsection

@section('after-scripts')

<script src="https://cdn.socket.io/socket.io-1.4.5.js"></script>

<script type="text/javascript">

    var defaultImage = "{{ asset('placeholder.png') }}";
    var chatBox = document.getElementById('chat-box');
    var chatInput = document.getElementById('chat-input');
    var chatSend = document.getElementById('chat-send');

    var socketState = false;

    var messageTemplate = function(data) {

    	var messageTemplate = '';

    	// Provider to user Message

    	if(data.type == 'pu') {
    		messageTemplate = '<div class="chat-left text-left row m-0">';
    		messageTemplate += '<div class="chat-msg-left">';
    		messageTemplate += '<div class="chat-img bg-img" style="background-image: url(' + socketClient.provider_picture +');"></div>';
    		messageTemplate += '</div>';
    		messageTemplate += '<div class="chat-msg-right">';
    		messageTemplate += '<p class="msg">'+data.message+'</p>';
    		messageTemplate += '</div>';
    		messageTemplate += '</div>';
    		messageTemplate += '</ br>';
    	} else {

    		messageTemplate = '<div class="row m-0">';
    		messageTemplate += '<div class="chat-right pull-right">';
    		messageTemplate += '<div class="chat-msg-left">';
    		messageTemplate += '<div class="chat-right-inner text-right">';
    		messageTemplate += '<p class="msg">'+data.message+'</p>';
    		messageTemplate += '</div>';
    		messageTemplate += '</div>';
    		messageTemplate += '</div>';
    		messageTemplate += '</div>';
    		messageTemplate += '</ br>';

    	}

        return messageTemplate;
    }

    chatSockets = function () {
        this.socket = undefined;
        this.provider_picture = "{{ $provider->picture }}" == "" ? defaultImage : "{{ $provider->picture }}";
        this.user_picture = "{{ Auth::user()->picture }}" == "" ? defaultImage : "{{ Auth::user()->picture }}";
    }

    chatSockets.prototype.initialize = function() {

        this.socket = io('{{ Setting::get("SOCKET_SERVER") }}', { 

                query: "myid=up{{ \Auth::user()->id }}&reqid={{ $request_details->id }}" 
            });

        this.socket.on('connected', function (data) {
            socketState = true;
            chatInput.enable();
            console.log('Connected :: '+data);
        });

        this.socket.on('message', function (data) {

            console.log("New Message :: "+JSON.stringify(data));
            
            if(data.message) {

                var pushstatusURL = "{{route('update.message.status')}}";

                $.post(pushstatusURL, {
                    user_id: "{{ Auth::user()->id }}",
                    provider_id: data.provider_id,
                    type: data.type,
                    request_id: "{{ $request_details->id }}"
                },
                function(data, status){
                    console.log("success Update")
                    // alert("Data: " + data + "\nStatus: " + status);
                });

        		$('#chat-box').append(messageTemplate(data));

                // chatBox.appendChild(messageTemplate(data));

                $(chatBox).animate({
                    scrollTop: chatBox.scrollHeight,
                }, 500);
            }
        
        });

        this.socket.on('disconnect', function (data) {
            socketState = false;
            chatInput.disable();
            console.log('Disconnected from server');
        });
   
    }

    chatSockets.prototype.sendMessage = function(data) {

        console.log('SendMessage'+data);
        
        data = {};
        data.type = 'up';
        data.message = text;
        data.user_id = "{{ \Auth::user()->id }}";
        data.provider_id = "{{ $provider->id}}";
        data.data_type = 'TEXT';
        data.status = 'sent';

        this.socket.emit('send message', data); 
    }

    socketClient = new chatSockets();
    socketClient.initialize();

    chatInput.enable = function() {
        console.log('Chat Input Enable');
        this.disabled = false;
    };

    chatInput.clear = function() {
        console.log('Chat Input Cleared');
        this.value = "";
    };

    chatInput.disable = function() {
        console.log('Chat Input Disable');
        this.disabled = true;
    };

    chatInput.addEventListener("keyup", function (e) {
        if (e.which == 13) {
            console.log("keyup");
            sendMessage(chatInput);
            return false;
        }
    });

    chatSend.addEventListener('click', function() {
        sendMessage(chatInput);
    });
    

    function sendMessage(input) {

        console.log("sendMessage");

        text = input.value.trim();
        if(socketState && text != '') {

            message = {};
            message.type = 'up';
            message.message = text;

            socketClient.sendMessage(text);

            $('#chat-box').append(messageTemplate(message));

            chatInput.clear();
            
            $(chatBox).animate({
                scrollTop: chatBox.scrollHeight,
            }, 500);
        }
    }

    $.get('{{ route("user.requests.chat") }}', {
        request_id: '{{ $request_details->id }}'
    })
    .done(function(response) {

        console.log("Get messages");

        for (var i = (response.length - 10 >= 0 ? response.length - 10 : 0); i < response.length; i++) {
        	$('#chat-box').append(messageTemplate(response[i]));

            // chatBox.appendChild(messageTemplate(response[i]));
            $(chatBox).animate({
                scrollTop: chatBox.scrollHeight,
            }, 500);
        }
    })
    .fail(function(response) {
        console.log(response);
    })
    .always(function(response) {
        console.log(response);
    });
</script>
@endsection