@extends('layouts.user')

@section('before-styles')

	<link href="{{asset('common/assets/css/material-bootstrap-wizard.css')}}" rel="stylesheet" />

	<link rel="stylesheet" href="{{asset('common/css/bootstrap-dialog.min.css')}}">

	<!-- CSS Just for demo purpose, don't include it in your project -->
	<link href="{{asset('common/assets/css/demo.css')}}" rel="stylesheet" />

	<link href="{{asset('common/css/bootstrap-datetimepicker.css')}}" rel="stylesheet" />

	<style type="text/css">
		.common-bg-link {
			cursor: pointer;
		}
		.btn-next {
			cursor:  pointer;
		}
	    #map {
	        height: 100%;
	        min-height: 400px; 
	    }

		.disabled_tags {
		   pointer-events: none;
		   cursor: default;
		}

		.navbar {

			padding: 0px;

		}

		.radio>label {
				color: #AAAAAA !important;
			}

	</style>

@endsection

@section('content')

<div class="image-container set-full-heightreq-col " style="background-color: #f1f1f1;">

    <!--   Big container   -->
    <div class="container">
        <div class="create-job-row row m-0 p-30">
	        <div class="col-sm-12">
	            <!--      Wizard container        -->
	            <div class="wizard-container">
	                <div class="card wizard-card" data-color="green" id="wizardProfile">
	                    <form action="" method="" id="create_job">
	                    	<input type="hidden" name="temp_request_id" id="temp_requests_id" />
	                    	<input type="hidden" name="job_type" id="job_type" />
	                    	<input type="hidden" name="s_latitude" id="s_latitude" />
           					<input type="hidden" name="s_longitude" id="s_longitude" />
	                    	<div class="wizard-header">
	                        	<h3 class="wizard-title">
	                        	   {{tr('create_a_job')}}
	                        	</h3>
	                    	</div>
							<div class="wizard-navigation">
								<ul>
									<li onclick="checkStepPosition({{REQUEST_STEP_1}}, 'Choose Job Type', 1)" id="{{REQUEST_STEP_1}}"><a href="#choose-job" data-toggle="tab">{{tr('REQUEST_STEP_1')}}</a></li>
		                            <li onclick="checkStepPosition({{REQUEST_STEP_2}}, 'Choose Category', 1)" id="{{REQUEST_STEP_2}}"><a href="#sel-category" data-toggle="tab">{{tr('REQUEST_STEP_2')}}</a></li>
		                            <li onclick="checkStepPosition({{REQUEST_STEP_3}}, 'Choose Sub Category', 1)" id="{{REQUEST_STEP_3}}"><a href="#sel-sub-category" data-toggle="tab">{{tr('REQUEST_STEP_3')}}</a></li>
		                            <li onclick="checkStepPosition({{REQUEST_STEP_4}}, 'Fill Job Details', 1)" id="{{REQUEST_STEP_4}}"><a href="#job-details" data-toggle="tab">{{tr('REQUEST_STEP_4')}}</a></li>
		                            <li onclick="checkStepPosition({{REQUEST_STEP_5}}, 'Choose Request Type', 1)" id="{{REQUEST_STEP_5}}"><a href="#sel-req-provider" data-toggle="tab">{{tr('REQUEST_STEP_5')}}</a></li>
		                            <li onclick="checkStepPosition({{REQUEST_STEP_FINAL}}, 'Select Provider', 1)" id="{{REQUEST_STEP_FINAL}}"><a href="#sel-provider" data-toggle="tab">{{tr('REQUEST_STEP_FINAL')}}</a></li>

		                            <!-- <li onclick="checkStepPosition({{REQUEST_STEP_1}})" id="{{REQUEST_STEP_1}}"><a href="#choose-job" data-toggle="tab">{{tr('REQUEST_STEP_1')}}</a></li>

		                            <li onclick="checkStepPosition({{REQUEST_STEP_2}})" id="{{REQUEST_STEP_2}}"><a href="#sel-category" data-toggle="tab">{{tr('REQUEST_STEP_2')}}</a></li>

		                            <li onclick="checkStepPosition({{REQUEST_STEP_3}})" id="{{REQUEST_STEP_3}}"><a href="#sel-sub-category" data-toggle="tab">{{tr('REQUEST_STEP_3')}}</a></li>

		                            <li onclick="checkStepPosition({{REQUEST_STEP_4}})" id="{{REQUEST_STEP_4}}"><a href="#job-details" data-toggle="tab">{{tr('REQUEST_STEP_4')}}</a></li>

		                            <li onclick="checkStepPosition({{REQUEST_STEP_5}})" id="{{REQUEST_STEP_5}}"><a href="#sel-req-provider" data-toggle="tab">{{tr('REQUEST_STEP_5')}}</a></li>
		                            
		                            <li onclick="checkStepPosition({{REQUEST_STEP_FINAL}})" id="{{REQUEST_STEP_FINAL}}"><a href="#sel-provider" data-toggle="tab">{{tr('REQUEST_STEP_FINAL')}}</a></li> -->
		                        </ul>
							</div>

	                        <div class="tab-content p-30">
	                        	<!-- Choose job tab -->
	                        	<div class="tab-pane fade in active" id="choose-job">
		                            <div class="job-tab-row row m-0">
		                            	@if (Setting::get('request_now') == 1)
			                            	<div class="req-col col-sm-6">
												<div class="req-col-inner gray-bg text-center p-f-30 create-job-shadow">
													<h3 class="req-col-tit">{{tr('request_now')}}</h3>
													<p class="req-col-txt">{{tr('request_now_content')}}</p>

													<input type="button" onclick="checkRequestNow({{REQUEST_NOW}}, {{REQUEST_STEP_1}})" class="btn btn-fill btn-success btn-wd" value= "Select &amp; Continue" />
												</div>
		                                    </div>
	                                    @endif

	                                    @if (Setting::get('request_later') == 1)

		                                    <div class="req-col col-sm-6">
		                                    	
												<div class="req-col-inner gray-bg text-center p-f-30 create-job-shadow">
													<h3 class="req-col-tit">{{tr('request_later')}}</h3>
													<p class="req-col-txt">{{tr('request_later_content')}}</p>
													<input type="button" onclick="saveJobType({{REQUEST_LATER}}, {{REQUEST_STEP_1}})" class="btn btn-fill btn-success btn-wd" value= "Select &amp; Continue" />
												</div>
		                                    </div>

	                                    @endif
		                            </div>
	                            </div>
	                            <!-- End of choose job tab -->

	                            <!-- Select Category tab -->
	                            <div class="tab-pane fade" id="sel-category">
	                            	<div class="job-tab-row row m-0">
	                            		@foreach ($categories as $category) 
	                            		<div class="category-list-left col-lg-4 col-md-4 col-sm-6 col-xs-12">
	                            			<a class="category-item text-center" onclick="saveCategory({{$category->category_id}}, {{REQUEST_STEP_2}})">
	                            				<div class="category-img bg-img" style="background-image: url({{asset($category->category_picture)}})"></div>
	                            				<h3 class="category-tit">{{$category->category_name}}</h3>
	                            			</a>
	                            		</div>
	                            		@endforeach
	                            	</div>
	                            </div>
	                            <!-- End of select category tab -->

	                            <!-- Select Sub Category tab -->
	                            <div class="tab-pane fade" id="sel-sub-category">

	                            </div>
	                            <!-- End of select sub category tab -->

	                            <!-- Job details tab-->
	                            <div class="tab-pane fade" id="job-details">
	                                <div class="job-tab-row m-0">
	                                    <div class="col-sm-12">
	                                        <!-- <h4 class="info-text">Job Details</h4> -->
	                                    </div>
	                                    <div class="col-sm-6">
                                        	<div class="form-group label-floating">
                                        		<label class="control-label">{{tr('job_title')}} *</label>
                                    			<input type="text" class="form-control" id="name" name="name" onchange="onKeyUpsaveJobDetails({{REQUEST_STEP_4}})">
                                        	</div>
	                                    </div>

	                                    <div class="col-sm-6">

	                                    	<div class="form-group" style="margin-top: 15px">

	                                    		<label class="control-label form-question-color">{{tr('choose_price_type')}} *</label>

	                                        	<div class="radio">

													<label>

													<input type="radio" value="{{PRICE_TYPE_HOUR_BASED}}" name="price_type" checked onchange="onKeyUpsaveJobDetails({{REQUEST_STEP_4}})">
														{{tr('PRICE_TYPE_HOUR_BASED')}}
													</label>

													<label>
													<input type="radio" value="{{PRICE_TYPE_FIXED_BASED}}" name="price_type" onchange="onKeyUpsaveJobDetails({{REQUEST_STEP_4}})">
														{{tr('PRICE_TYPE_FIXED_BASED')}}
													</label>

												</div>
												
												<div class="radio">
													
												</div>

											</div>
	                                    
	                                    </div>

	                                    <div class="clearfix"></div>

	                                    <div class="col-sm-6" style="display: none" id="price_field">
	                                        <div class="form-group label-floating">
	                                            <label class="control-label">{{tr('price')}} *</label>
	                                            <input type="number" step="any" class="form-control" id="user_price" name="user_price" min="0" onchange="onKeyUpsaveJobDetails({{REQUEST_STEP_4}})">
	                                        </div>
	                                    </div>
	                                    <div class="col-sm-6" style="display: none" id="request_date_field">
	                                    	<div class="form-group label-floating">
		                                    	<label class="control-label">{{tr('date')}} *</label>
		                                    	<input class="form-control" id="request_date" name="request_date" onchange="onKeyUpsaveJobDetails({{REQUEST_STEP_4}})">
	                                    	</div>
	                                    </div>

	                                    <div class="clearfix"></div>

	                                    <div class="col-sm-6">
	                                        <div class="form-group label-floating">
	                                            <label class="control-label">{{tr('description')}} *</label>
	                                            <textarea class="form-control" rows="3" id="description" name="description" onchange="onKeyUpsaveJobDetails({{REQUEST_STEP_4}})"></textarea>
	                                        </div>
	                                    </div>
	        
	                                    <div class="col-sm-6">
	                                    	<div class="form-group label-floating">
	                                    		<label class="control-label">{{tr('note')}} *</label>
	                                    		<textarea class="form-control" rows="3" id="note" name="note" onchange="onKeyUpsaveJobDetails({{REQUEST_STEP_4}})"></textarea>
	                                    	</div>
	                                    </div>
	                                    <div class="col-sm-12">
	                                        <div class="form-group label-floating is-focused">
	                                            <label class="control-label">{{tr('location')}}</label>
	                                            <input type="text" class="form-control" id="pac-input" placeholder="" name="s_address">
	                                        </div>
	                                    </div>

	                                    <div class="col-sm-12">
	                                        <div id="map"></div> 
	                                        <button style="display:none" type="button" id="map_button" onclick="displayMap()">{{tr('show_map')}}</button>
	                                    </div>
	                                </div>
	                            </div>
	                            <!-- End of job details tab-->

	                            <!-- Select req provider tab -->
	                            <div class="tab-pane fade" id="sel-req-provider">
	                            	<div class="job-tab-row m-0">
										@if (Setting::get('request_type_location') == APPROVED)
		                            		<div class="col-sm-4">

		                                        <div class="req-pro gray-bg p-f-30 text-center create-job-shadow">

		                                        	<h3 class="req-pro-tit">{{tr('request_type_location')}}</h3>

		                                        	<p class="req-pro-txt">
		                                        		{{tr('nearby_provider_description')}}
		                                        	</p>

		                                        	<a onclick="saveProviders({{REQUEST_TYPE_LOCATION}}, {{REQUEST_STEP_5}}), $(this).attr('disabled', true)" class="req-pro-link common-bg-link">{{tr('select_book')}}</a>
		                                        </div>
		                                    </div>
		                                @endif

 										@if (Setting::get('request_type_category') == APPROVED)
		                                    <div class="col-sm-4">
		                                        <div class="req-pro gray-bg p-f-30 text-center create-job-shadow">
		                                        	<h3 class="req-pro-tit">{{tr('request_type_category')}}</h3>
		                                        	<p class="req-pro-txt">
		                                        	{{tr('all_provider_description')}}
		                                        	</p>
		                                        	<a onclick="saveProviders({{REQUEST_TYPE_CATEGORY}}, {{REQUEST_STEP_5}}), $(this).attr('disabled', true)" class="req-pro-link common-bg-link">{{tr('select_book')}}</a>
		                                        </div>
		                                    
		                                    </div>
		                                @endif

										@if (Setting::get('request_type_direct') == APPROVED)
		                                    <div class="col-sm-4">
		                                        <div class="req-pro gray-bg p-f-30 text-center create-job-shadow">
		                                        	<h3 class="req-pro-tit">{{tr('request_type_direct')}}</h3>
		                                        	<p class="req-pro-txt">{{tr('select_provider_description')}}</p>
		                                        	<a onclick="saveProviders({{REQUEST_TYPE_DIRECT}}, {{REQUEST_STEP_5}})" class="req-pro-link common-bg-link">{{tr('select_continue')}}</a>
		                                        </div>
		                                    </div>
		                                @endif
	                            	</div>
	                            </div>
	                            <!-- End of select req provider tab -->

	                            <!-- Select provider tab -->
	                            <div class="tab-pane fade" id="sel-provider">
	                            	
	                            </div>
	                            <!-- End of select provider tab -->
	                        </div>
	                        <div class="wizard-footer row m-0">
	                            <div class="pull-right">
	                                <input type='button' class='btn btn-next btn-fill btn-success btn-wd' name='next' value='Next' style="display: none"/>
	                                <input type='button' class='btn btn-fill btn-success btn-wd' name='Book' value='Book' style="display: none" id="final_step" onclick="saveJobDetails({{REQUEST_STEP_4}})"/>
	                                <input type='button' class='btn btn-fill btn-success btn-wd' name='next' value='Next' style="display: none" id="job_details" onclick="saveJobDetails({{REQUEST_STEP_4}})"/>
	                                <!-- <input type='button' class='btn btn-finish btn-fill btn-success btn-wd' name='finish' value='Finish' /> -->
	                            </div>

	                            <div class="pull-left">
	                                <input type='button' class='btn btn-previous btn-fill btn-default btn-wd' name='previous' value='Previous' />
	                            </div>
	                            <div class="clearfix"></div>
	                        </div>
	                    </form>
	                </div>
	            </div> <!-- wizard container -->
	        </div>
        </div><!-- end row -->
    
    </div> 

    <!--  big container -->

</div>

@endsection

@section('before-scripts')

<script src="{{asset('common/assets/js/jquery.bootstrap.js')}}" type="text/javascript"></script>

<!--  Plugin for the Wizard -->
<script src="{{asset('common/assets/js/material-bootstrap-wizard.js')}}"></script>

<!--  More information about jquery.validate here: http://jqueryvalidation.org/	 -->
<script src="{{asset('common/assets/js/jquery.validate.min.js')}}"></script>
<script src="{{asset('common/js/moment-with-locales.js')}}"></script>
<script src="{{asset('common/js/bootstrap-datetimepicker.min.js')}}"></script>

@endsection

@section('after-scripts')

<script type="text/javascript">
/**
 * Header defined variables
 * @var id 				Logged in user id
 * @var token			Logged in user token
 * @var step3   		Third step of the job (value - 3)
 * @var request_now 	Type of Request (value - 1)
 * @var directProvider	Request type for Provider (value - 3)
 */
var id = "{{Auth::user()->id}}";
var token = "{{Auth::user()->token}}";
var step3 = "{{REQUEST_STEP_3}}";
var request_now = "{{REQUEST_NOW}}";
var directProvider = "{{REQUEST_TYPE_DIRECT}}"; 

var now = new Date();

now.setHours(now.getHours() + parseInt("{{Setting::get('request_date_time')}}"));
// alert(now);

//DATE TIME PICKER
$(document).ready(function(){
	$("#request_date").datetimepicker({
		format : 'dd-mm-yyyy hh:ii',
		startDate:now,
	}).on('dp.change', function(e){ 
	    var requestDate = $("#request_date").val();
	    if (requestDate != '' && requestDate != undefined) {
	    	$("#request_date").parent().addClass("is-focused");
	    	$("#request_date").parent().removeClass("is-empty");
	    } else {
	    	$("#request_date").parent().removeClass("is-focused");	
	    	$("#request_date").parent().addClass("is-empty");
	    }
	})
});
</script>

<script type="text/javascript">
	// provider map view
	$('.pro-map-view').hide();
	$('.map-view').click( function(){
	    $('.pro-view-sec').hide();
	    $('.pro-map-view').fadeIn(300);
	    $('.map-view').addClass('active');
	    $('.list-view').removeClass('active');
	});

	// provider list view
	$('.list-view').click( function(){
	    $('.pro-map-view').hide();
	    $('.pro-view-sec').fadeIn(300);
	    $('.list-view').addClass('active');
	    $('.map-view').removeClass('active');
	});
</script>

<script>
	$('.pro-view-sec').on('show.bs.collapse', function () {
    $(this).addClass('active');
	    });

    $('.pro-view-sec').on('hide.bs.collapse', function () {
         $(this).removeClass('active');
	});

	var before_url = "{{url('/')}}";
</script>

<script type="text/javascript" src="{{asset('common/js/create_jobs.js')}}"></script>

<script type="text/javascript" src="{{asset('common/assets/js/bootstrap-dialog.min.js')}}"></script>

<script src="https://maps.googleapis.com/maps/api/js?key={{ envfile('GOOGLE_API_KEY') }}&libraries=places&callback=initMap" async defer></script>



@endsection
