@extends('layouts.user')

@section('after-styles')

<style>
	.truncate {
	  width: 15em;
	  white-space: nowrap;
	  overflow: hidden;
	  text-overflow: ellipsis;
	}
</style>

@endsection

@section('content')

	<div class="content-wrap gray-bg">

		<div class="container">

			@include('notification.notify')

			<div class="jobs white-bg m-30 p-f-30">

				<div class="tab-content job-content">

					<!-- Drafts tab -->
					<div role="tabpanel" class="tab-pane fade in active" id="new-requests">
					
						<!-- Job details-list -->
						<div class="job-details-list-row row m-0">

							<h3 class="job-main-tit" style="margin-bottom: 10px">

								{{tr('history')}} ( {{count($requests)}} {{tr('jobs')}})

								<a href="{{route('user.history',['cancelled_jobs' => YES])}}" class="btn text-uppercase text-underline pull-right">
									<i class="fa fa-ban"></i> {{tr('cancelled_jobs')}}
								</a>

							</h3>

							<div class="dashboard-list-outer">
								<!-- DAshboard list -->

								@if($requests)

									@foreach($requests as $pr => $request_details)
								
										<div class="dashboard-list row m-0 create-job-shadow">

											<!-- Dashboard-list-box -->
											<div class="dashboard-list-col col-lg-5 col-md-12 col-sm-12 col-xs-12">
												<div class="dashboard-list-box">
													<h3 class="dashboard-list-tit job_name">{{$request_details->name}}</h3>
													<p class="dashboard-list-txt">
														<span><b>{{tr('request_date')}} : </b> {{$request_details->request_date}} </span>
													</p>
												</div>
											</div>
											<!-- End of dashboard-list-box -->

											<!-- Dashboard-list-box -->
											<div class="dashboard-list-col col-lg-2 col-md-12 col-sm-12 col-xs-12">
												<div class="dashboard-list-box">
													<p class="dashboard-list-txt">
														<i class="ion-arrow-graph-up-left truncate"></i> {{Setting::get('currency')}} {{$request_details->total}}{{$request_details->price_per_symbol}}
													</p>
													<p class="dashboard-list-txt">
														<i class="ion-arrow-graph-down-left"></i> {{$request_details->provider_name}}
													</p>
												</div>
											</div>
											<!-- End of dashboard-list-box -->

											<!-- Dashboard-list-box -->
											<div class="dashboard-list-col col-lg-2 col-md-12 col-sm-12 col-xs-12">
												<div class="dashboard-list-box">
													<p class="dashboard-list-txt m-t-20">
													 	<i class="fa fa-thumbs-up"></i>
													 	{{request_status($request_details->status)}}
													</p>
												</div>
											</div>
											<!-- End of dashboard-list-box -->

											<!-- Dashboard-list-box -->
											<div class="dashboard-list-col col-lg-3 col-md-12 col-sm-12 col-xs-12">
												<div class="dashboard-list-box">

													<a href="{{route('user.jobs.view' , ['request_unique_id' => $request_details->unique_id])}}" class="view-link theme-btn m-t-20"><i class="fa fa-eye"></i> {{tr('view')}}</a>	

																					
												</div>
											</div>
											<!-- End of dashboard-list-box -->
										</div>

									@endforeach

								@else

									<!-- <h1 class="text-center theme-color"></h1> -->

									<h3 class="text-center">{{tr('no_result_content')}}</h3>
								@endif
							
							</div>

						</div>

						<!-- End of job details list -->
					
					</div>

				</div>

			</div>

		</div>

	</div>

@endsection