@extends('layouts.user')

@section('after-styles')
<style>
	.truncate {
	  width: 15em;
	  white-space: nowrap;
	  overflow: hidden;
	  text-overflow: ellipsis;
	}
</style>
@endsection

@section('content')

<div class="content-wrap gray-bg">

		<div class="container">

			@include('notification.notify')

			<h3>
				<span>{{tr('dashboard')}}</span>

				@if($display)
					<span class="pull-right">
						<a href="{{route('user.dashboard')}}" class="btn btn-success"> {{tr('now')}}</a>
					</span>
				@endif
			</h3>

			<div class="jobs white-bg m-30 p-f-30">


				<!-- jobs-head -->
				<div class="jobs-head row m-0">


					<ul class="nav nav-tabs job-tabs" role="tablist" id="tab">
						
						<li role="presentation" class="{{$job_active == 'drafts' ? 'active' : ''}} col-lg-3 col-md-3 col-sm-3 col-xs-12 p-0">
							<a href="{{route('user.jobs.index', array('active'=>'drafts'))}}">{{tr('drafts')}}
							</a>
						</li>

						<li role="presentation" class="{{$job_active == 'posted-jobs' ? 'active' : ''}} col-lg-3 col-md-3 col-sm-3 col-xs-12 p-0">
							<a href="{{route('user.jobs.index', array('active'=>'posted-jobs'))}}">{{tr('posted_requests')}}
							</a>
						</li>
						<li role="presentation" class="{{$job_active == 'confirm-jobs' ? 'active' : ''}} col-lg-3 col-md-3 col-sm-3 col-xs-12 p-0">
							<a href="{{route('user.jobs.index', array('active'=>'confirm-jobs'))}}" style="position: relative;" id="confirmed_job_badge">
								{{tr('confirmed_requests')}}
								<div class="notify_badge confirmed_job_badge" style="display: none">{{confirmed_job_notifications()}}</div>
							</a>
						</li>
						<li role="presentation" class="{{$job_active == 'ongoing-jobs' ? 'active' : ''}} col-lg-3 col-md-3 col-sm-3 col-xs-12 p-0" id="ongoing_job_badge">
							<a href="{{route('user.jobs.index', array('active'=>'ongoing-jobs'))}}" style="position: relative;">{{tr('ongoing_requests')}}
								<div class="notify_badge ongoing_job_badge" style="display: none">{{ongoing_job_notifications()}}</div>
							</a>
						</li>
					</ul>
				</div>
				<!-- End of jobs-head -->

				<!-- Job content -->
				<div class="tab-content job-content">

					<!-- Drafts tab -->
					<div role="tabpanel" class="tab-pane fade {{$job_active == 'drafts' ? 'in active' : ''}}" id="drafts">
						<!-- Job details-list -->
						<div class="job-details-list-row row m-0 p-30">

							<h3 class="job-main-tit"></h3>

							<!-- <h4 class="job-sub-tit">{{count($drafts)}} Results</h4> -->

							<div class="dashboard-list-outer">

								<!-- DAshboard list -->

								@if($drafts)
								
									<div class="row">
										<div class="col-md-3">
										</div>
										<div class="col-md-3">
										</div>
										<div class="col-sm-6 col-md-3 top">
											<input type="text" name="draft_job_search" id="draft_job_search" class="form-control" placeholder="{{tr('search_job_title')}}" onkeyup="searchDraft(this.value, false, 0)">
										</div>
										<div class="col-sm-6 col-md-3 top">
											<select class="form-control" id="draft_sorting_key" name="sorting" onchange="searchDraft(this.value, true, 0)">
												<option value="">{{tr('sort')}}</option>
												<option value="asc">{{tr('sort_by_a_z')}}</option>
												<option value="desc">{{tr('sort_by_z_a')}}</option>
												<option value="{{REQUEST_NOW}}">{{tr('only_ondemand_request')}}</option>
												<option value="{{REQUEST_LATER}}">{{tr('only_later_request')}}</option>
											</select>
										</div>
									</div>
									<br>


									<div class="clearfix"></div> 

									<div id="default_draft">
									@foreach($drafts as $pr => $draft)
								
										<div class="dashboard-list row m-0 create-job-shadow">

											<!-- Dashboard-list-box -->
											<div class="dashboard-list-col col-lg-5 col-md-12 col-sm-12 col-xs-12">
												<div class="dashboard-list-box">
													<h3 class="dashboard-list-tit job_name">{{$draft->name}}</h3>
													@if($draft->request_date != "0000-00-00 00:00:00")

													<p class="dashboard-list-txt">
														<span><b>{{tr('request_date')}} : </b> @if($draft->request_date) {{$draft->request_date}} @endif </span>
													</p>

													@endif
												</div>
											</div>
											<!-- End of dashboard-list-box -->

											<!-- Dashboard-list-box -->
											<div class="dashboard-list-col col-lg-2 col-md-12 col-sm-12 col-xs-12">
												<div class="dashboard-list-box">
													<p class="dashboard-list-txt">
														<i class="ion-arrow-graph-up-left"></i> {{job_type($draft->job_type)}}
													</p>
													<p class="dashboard-list-txt">
														<i class="ion-arrow-graph-down-left"></i> {{request_type($draft->request_type)}}
													</p>
												</div>
											</div>
											<!-- End of dashboard-list-box -->

											<!-- Dashboard-list-box -->
											<div class="dashboard-list-col col-lg-2 col-md-12 col-sm-12 col-xs-12">
												<div class="dashboard-list-box">
													<p class="dashboard-list-txt m-t-20">
													 	<i class="fa fa-info"></i>
													 	{{request_step($draft->step)}}
													</p>
												</div>
											</div>
											<!-- End of dashboard-list-box -->

											<!-- Dashboard-list-box -->
											<div class="dashboard-list-col col-lg-3 col-md-12 col-sm-12 col-xs-12">
												<div class="dashboard-list-box">


													<a href="{{route('user.requests.draft.edit' , ['request_id' => $draft->temp_request_id])}}" class="btn btn-warning m-t-15"><i class="fa fa-edit"></i> {{tr('edit')}}</a>

													<a href="{{route('user.requests.draft.delete' , $draft->temp_request_id)}}" class="btn btn-danger m-t-15"><i class="fa fa-times"></i> {{tr('delete')}}</a>									
												</div>
											</div>
											<!-- End of dashboard-list-box -->
										

										</div>

									@endforeach

									</div>

									<div id="draft_requests"></div>

									<div id="draft_loader"></div>

								@else
									<h3 class="text-center">{{tr('no_result_content')}}</h3>
								@endif
							
							</div>
						</div>
						<!-- End of job details list -->
					
					</div>
					<!-- End of Drafts tab -->

					<!-- Active jobs tab -->
					<div role="tabpanel" class="tab-pane fade {{$job_active == 'posted-jobs' ? 'in active' : ''}}" id="posted-jobs">
						<!-- Job details-list -->
						<div class="job-details-list-row row m-0 p-30">

							<h3 class="job-main-tit"></h3>

							<div class="dashboard-list-outer">

								<!-- DAshboard list -->

								@if($posted_requests)

									<div class="row">

										<div class="col-md-3">
											<h4 class="job-sub-tit">{{tr('total_posted_jobs')}} {{count($posted_requests)}}</h4>
										</div>

										<div class=" col-md-3"></div>

										<div class="top col-sm-6 col-md-3">
											<input type="text" name="posted_job_search" id="posted_job_search" class="form-control" placeholder="{{tr('search_job_title')}}" onkeyup="searchPosted(this.value, false, 0)">
										</div>
										<div class="top col-sm-6 col-md-3">
											<select class="form-control" id="posted_sorting_key" name="sorting" onchange="searchPosted(this.value, true, 0)">
												<option value="">{{tr('sort')}}</option>
												<option value="asc">{{tr('sort_by_a_z')}}</option>
												<option value="desc">{{tr('sort_by_z_a')}}</option>
											</select>
										</div>
									</div>
									<br>


									<div class="clearfix"></div> 

									<div id="default_posted">

									@foreach($posted_requests as $pr => $posted_request)

										<div class="dashboard-list row m-0 create-job-shadow">

											<!-- Dashboard-list-box -->
											<div class="dashboard-list-col col-lg-4 col-md-12 col-sm-12 col-xs-12">
												<div class="dashboard-list-box">
													<h3 class="dashboard-list-tit truncate">{{$posted_request->name}}</h3>
													<p class="dashboard-list-txt">
														<span><b>{{tr('request_date')}} : </b> {{$posted_request->request_date}} </span>
													</p>
												</div>
											</div>
											<!-- End of dashboard-list-box -->

											<!-- Dashboard-list-box -->
											<div class="dashboard-list-col col-lg-3 col-md-12 col-sm-12 col-xs-12">
												<div class="dashboard-list-box">
													<p class="dashboard-list-txt">
														<i class="ion-arrow-graph-up-left"></i> 
														{{$posted_request->category_name}}
													</p>
													<p class="dashboard-list-txt">
														<i class="ion-arrow-graph-down-left"></i> 
														{{request_type($posted_request->request_type)}}
													</p>
												</div>
											</div>
											<!-- End of dashboard-list-box -->

											<!-- Dashboard-list-box -->
											<div class="dashboard-list-col col-lg-2 col-md-12 col-sm-12 col-xs-12">
												<div class="dashboard-list-box">
													<p class="dashboard-list-txt m-t-20">
													 	<i class="fa fa-info-circle"></i>
													 	{{request_status($posted_request->status)}}
													</p>
												</div>
											</div>
											<!-- End of dashboard-list-box -->

											<!-- Dashboard-list-box -->
											<div class="dashboard-list-col col-lg-3 col-md-12 col-sm-12 col-xs-12">
												<div class="dashboard-list-box">

													<!-- <a href="{{route('user.jobs.view' , ['request_unique_id' => $posted_request->unique_id])}}" class="view-link theme-btn">View</a> -->

													<a title="View Job" href="{{route('user.jobs.view' , ['request_unique_id' => $posted_request->unique_id])}}" class="btn btn-success m-t-15"><i class="fa fa-eye"></i></a>

													<a title="Edit Job" href="{{route('user.requests.update' , ['request_unique_id' => $posted_request->unique_id])}}" class="btn btn-warning m-t-15"><i class="fa fa-edit"></i></a>

													<form action="{{route('user.jobs.cancel')}}" method="POST" class="job-form m-t-15">

														<input type="hidden" name="request_id" value="{{$posted_request->request_id}}">

														<button class="btn btn-danger m-t-15" onclick="return confirm(&apos;{{tr('request_cancel_confirm')}}&apos;)" title="Cancel Job">

														<i class="fa fa-times"></i>
															
														</button>
													</form>

												</div>
											</div>
											<!-- End of dashboard-list-box -->
										</div>

									@endforeach

									</div>
									
  									<!-- <div class="pagination">  </div> -->

  									<div id="posted_requests"></div>

									<div id="posted_loader"></div>

								@else

									<h3 class="text-center">{{tr('no_result_content')}}</h3>

								@endif
							
							</div>
						</div>
						<!-- End of job details list -->
					</div>
					<!-- End of active jobs tab -->

					<!-- Confirmed Jobs -->
					<div role="tabpanel" class="tab-pane fade {{$job_active == 'confirm-jobs' ? 'in active' : ''}}" id="confirm-jobs">
						<!-- Job details-list -->
						<div class="job-details-list-row row m-0 p-30">

							<!-- <h3 class="job-main-tit">Confirm Jobs</h3> -->

							<div class="dashboard-list-outer">

								@if($confirmed_requests)

									<div class="row">
										<div class="col-md-3">
											<h4 class="job-sub-tit">{{count($confirmed_requests)}} {{tr('result')}}</h4>
										</div>
										<div class="col-md-3">
										</div>
										<div class="top col-sm-6 col-md-3">
											<input type="text" name="confirmed_job_search" id="draft_job_search" class="form-control" placeholder="{{tr('search_job_title')}}" onkeyup="searchConfirmed(this.value, false, 0)">
										</div>
										<div class="top col-sm-6 col-md-3">
											<select class="form-control" id="confirmed_sorting_key" name="sorting" onchange="searchConfirmed(this.value, true, 0)">
												<option value="">{{tr('sort')}}</option>
												<option value="asc">{{tr('sort_by_a_z')}}</option>
												<option value="desc">{{tr('sort_by_z_a')}}</option>
											</select>
										</div>
									</div>
									<br>

									<div id="default_confirmed">

									@foreach($confirmed_requests as $pr => $confirmed_request)

										<div class="dashboard-list row m-0 create-job-shadow">

											<!-- Dashboard-list-box -->
											<div class="dashboard-list-col col-lg-4 col-md-12 col-sm-12 col-xs-12">
												<div class="dashboard-list-box">
													<h3 class="dashboard-list-tit truncate">{{$confirmed_request->name}}</h3>
													<p class="dashboard-list-txt">
														<span><b>{{tr('request_date')}} : </b> {{$confirmed_request->request_date}} </span>
													</p>
												</div>
											</div>
											<!-- End of dashboard-list-box -->

											<!-- Dashboard-list-box -->
											<div class="dashboard-list-col col-lg-3 col-md-12 col-sm-12 col-xs-12">
												<div class="dashboard-list-box">
													<p class="dashboard-list-txt">
														<i class="ion-arrow-graph-up-left"></i> 
														{{$confirmed_request->category_name}}
													</p>
													<p class="dashboard-list-txt">
														<i class="ion-arrow-graph-down-left"></i> 
														{{request_type($confirmed_request->request_type)}}
													</p>
												</div>
											</div>
											<!-- End of dashboard-list-box -->

											<!-- Dashboard-list-box -->
											<div class="dashboard-list-col col-lg-2 col-md-12 col-sm-12 col-xs-12">
												<div class="dashboard-list-box">
													<p class="dashboard-list-txt m-t-20">
													 	<i class="fa fa-info-circle"></i>
													 	{{request_status($confirmed_request->status)}}
													</p>
												</div>
											</div>
											<!-- End of dashboard-list-box -->

											<!-- Dashboard-list-box -->
											<div class="dashboard-list-col col-lg-3 col-md-12 col-sm-12 col-xs-12">

												<div class="dashboard-list-box">

													<a href="{{route('user.jobs.view' , ['request_unique_id' => $confirmed_request->unique_id])}}" class="btn btn-success m-t-15"><i class="fa fa-eye"></i></a>

													<!-- <a href="#" class="btn btn-warning m-t-15"><i class="fa fa-edit"></i></a> -->

													<a href="{{route('user.jobs.view' , ['request_unique_id' => $confirmed_request->unique_id])}}" class="btn btn-danger m-t-15"><i class="fa fa-times"></i></a>									
												</div>
											</div>
											<!-- End of dashboard-list-box -->
										</div>

									@endforeach

									</div>

									<div id="confirmed_requests"></div>

									<div id="confirmed_loader"></div>

								@else

									<h3 class="text-center">{{tr('no_result_content')}}</h3>

								@endif
							</div>
						</div>
						<!-- End of job details list -->
					</div>
					<!-- End of Confirmed Jobs -->

					<!-- Confirmed Jobs -->
					<div role="tabpanel" class="tab-pane fade {{$job_active == 'ongoing-jobs' ? 'in active' : ''}}" id="ongoing-jobs">
						<!-- Job details-list -->
						<div class="job-details-list-row row m-0 p-30">

							<h3 class="job-main-tit"></h3>

							<div class="dashboard-list-outer">

								@if($ongoing_requests)

									<div class="row">
										<div class="col-md-3">
											<h4 class="job-sub-tit">{{count($ongoing_requests)}} {{tr('result')}}</h4>
										</div>
										<div class="col-md-3">
										</div>
										<div class="top col-sm-6 col-md-3">
											<input type="text" name="ongoing_job_search" id="draft_job_search" class="form-control" placeholder="{{tr('search_job_title')}}" onkeyup="searchOngoing(this.value, false, 0)">
										</div>
										<div class="top col-sm-6 col-md-3">
											<select class="form-control" id="ongoing_sorting_key" name="sorting" onchange="searchOngoing(this.value, true, 0)">
												<option value="">{{tr('sort')}}</option>
												<option value="asc">{{tr('sort_by_a_z')}}</option>
												<option value="desc">{{tr('sort_by_z_a')}}</option>
											</select>
										</div>
									</div>
									<br>

									<div id="default_ongoing">

									@foreach($ongoing_requests as $pr => $ongoing_request)

										<div class="dashboard-list row m-0 create-job-shadow">

											<!-- Dashboard-list-box -->
											<div class="dashboard-list-col col-lg-4 col-md-12 col-sm-12 col-xs-12">
												<div class="dashboard-list-box">
													<h3 class="dashboard-list-tit truncate">{{$ongoing_request->name}}</h3>
													<p class="dashboard-list-txt">
														<span><b>{{tr('request_date')}} : </b> {{$ongoing_request->request_date}} </span>
													</p>
												</div>
											</div>
											<!-- End of dashboard-list-box -->

											<!-- Dashboard-list-box -->
											<div class="dashboard-list-col col-lg-3 col-md-12 col-sm-12 col-xs-12">
												<div class="dashboard-list-box">
													<p class="dashboard-list-txt">
														<i class="ion-arrow-graph-up-left"></i> 
														{{$ongoing_request->category_name}}
													</p>
													<p class="dashboard-list-txt">
														<i class="ion-arrow-graph-down-left"></i> 
														{{request_type($ongoing_request->request_type)}}
													</p>
												</div>
											</div>
											<!-- End of dashboard-list-box -->

											<!-- Dashboard-list-box -->
											<div class="dashboard-list-col col-lg-2 col-md-12 col-sm-12 col-xs-12">
												<div class="dashboard-list-box">
													<p class="dashboard-list-txt m-t-20">
													 	<i class="fa fa-info-circle"></i>
													 	{{$ongoing_request->currency}} {{$ongoing_request->price_per_hour}} {{$ongoing_request->price_per_symbol}}
													</p>
												</div>
											</div>
											<!-- End of dashboard-list-box -->

											<!-- Dashboard-list-box -->
											<div class="dashboard-list-col col-lg-3 col-md-12 col-sm-12 col-xs-12">
											
												<div class="dashboard-list-box">

													<a href="{{route('user.jobs.view' , ['request_unique_id' => $ongoing_request->unique_id])}}" class="btn btn-success m-t-15 text-center"><i class="fa fa-eye"></i> {{tr('view')}}</a>
									
												</div>
											</div>
											<!-- End of dashboard-list-box -->
										</div>

									@endforeach

									</div>

									<div id="ongoing_requests"></div>

									<div id="ongoing_loader"></div>

								@else

									<h3 class="text-center">{{tr('no_result_content')}}</h3>

								@endif
								
							</div>


						</div>
						<!-- End of job details list -->
					</div>
					<!-- End of Confirmed Jobs -->

				</div>
				<!-- end of Job content  -->
			</div>
		</div>
	</div>

@endsection

@section('after-scripts')

<script type="text/javascript">

var draftLength = "{{count($drafts)}}";

var postedLength = "{{count($posted_requests)}}";

var confirmedLength = "{{count($confirmed_requests)}}";

var ongoingLength = "{{count($ongoing_requests)}}";

var stopScroll = false;

var searchLength = 0;
	
function draftRequests(value) {

	console.log("skip value"+value);

	$.ajax ({

		type : "POST",

		url : "{{route('user.ajax_draft_requests')}}",

		beforeSend : function () {

			$("#draft_loader").html('<h1 class="text-center theme-color"><i class="fa fa-spinner fa-spin"></i></h1>');
		},

		data : {skip : value},

		async : false,

		success : function (data) {

			$("#draft_requests").append(data.view);

			if (data.length == 0) {

				stopScroll = true;

			} else {

				stopScroll = false;

				draftLength = parseInt(draftLength) + data.length;

			}

		}, 

		complete : function() {

			$("#draft_loader").html('');

		},

		error : function (data) {


		},

	});

}


function postedRequests(value) {

	console.log("skip value"+value);

	console.log(searchLength);

	$.ajax ({

		type : "POST",

		url : "{{route('user.ajax_posted_requests')}}",

		beforeSend : function () {

			$("#posted_loader").html('<h1 class="text-center theme-color"><i class="fa fa-spinner fa-spin"></i></h1>');
		},

		data : {skip : value},

		async : false,

		success : function (data) {

			$("#posted_requests").append(data.view);

			if (data.length == 0) {

				stopScroll = true;

			} else {

				stopScroll = false;

				postedLength = parseInt(postedLength) + data.length;

				console.log(postedLength);

			}

		}, 

		complete : function() {

			$("#posted_loader").html('');

		},

		error : function (data) {


		},

	});

}


function confirmRequests(value) {

	console.log("skip value"+value);

	$.ajax ({

		type : "POST",

		url : "{{route('user.ajax_confirmed_requests')}}",

		beforeSend : function () {

			$("#confirmed_loader").html('<h1 class="text-center theme-color"><i class="fa fa-spinner fa-spin"></i></h1>');
		},

		data : {skip : value},

		async : false,

		success : function (data) {

			$("#confirmed_requests").append(data.view);

			if (data.length == 0) {

				stopScroll = true;

			} else {

				stopScroll = false;

				confirmedLength = parseInt(confirmedLength) + data.length;

			}

		}, 

		complete : function() {

			$("#confirmed_loader").html('');

		},

		error : function (data) {


		},

	});

}


function ongoingRequests(value) {

	console.log("skip value"+value);

	$.ajax ({

		type : "POST",

		url : "{{route('user.ajax_ongoing_requests')}}",

		beforeSend : function () {

			$("#ongoing_loader").html('<h1 class="text-center theme-color"><i class="fa fa-spinner fa-spin"></i></h1>');
		},

		data : {skip : value},

		async : false,

		success : function (data) {

			$("#ongoing_requests").append(data.view);

			if (data.length == 0) {

				stopScroll = true;

			} else {

				stopScroll = false;

				confirmedLength = parseInt(confirmedLength) + data.length;

			}

		}, 

		complete : function() {

			$("#ongoing_loader").html('');

		},

		error : function (data) {


		},

	});

}

function reset() {

	stopScroll = false;

	draftLength = "{{count($drafts)}}";

	postedLength = "{{count($posted_requests)}}";

	confirmedLength = "{{count($confirmed_requests)}}";

	ongoingLength = "{{count($ongoing_requests)}}";

	$("#draft_requests").html("");

	$("#posted_requests").html("");

	$("#confirmed_requests").html("");

	$("#ongoing_requests").html("");

	$("#draft_job_search").val("");

	$("#draft_sorting_key").val("");

	searchLength = 0;

	if ($("#default_draft").html() == ""){ 

		draftRequests(0);

	}

}

$(window).scroll(function() {

    if($(window).scrollTop() == $(document).height() - $(window).height()) {

    	var jobs_type = $('ul#tab').find('li.active').data('value');

    	if (!stopScroll) {


    		switch(jobs_type) {

    			case 'drafts' :

    				console.log(searchLength);

    				if (searchLength > 0) {

    					var draftKeyWord = $("#draft_job_search").val();

    					var draftSearchWord = $("#draft_sorting_key").val();

    					if (draftKeyWord != '') {

    						var status = false;

    						var word = draftKeyWord;

    					} else {

    						var status = true;

    						var word = draftSearchWord;

    					}

    					searchDraft(word, status, searchLength);

    				} else {

    					draftRequests(draftLength);

    				}

    				break;


    			case 'posted-jobs' :

    				if (searchLength > 0) {

    					var postKeyWord = $("#posted_job_search").val();

    					var postSearchWord = $("#posted_sorting_key").val();

    					if (postKeyWord != '') {

    						var status = false;

    						var word = postKeyWord;

    					} else {

    						var status = true;

    						var word = postSearchWord;

    					}

    					searchPosted(word, status, searchLength);

    				} else {

    					postedRequests(postedLength);

    				}

    				break;

    			case 'confirm-jobs' :

    				
    				if (searchLength > 0) {

    					var confirmedKeyWord = $("#confirmed_job_search").val();

    					var confirmedSearchWord = $("#confirmed_sorting_key").val();

    					if (confirmedKeyWord != '') {

    						var status = false;

    						var word = confirmedKeyWord;

    					} else {

    						var status = true;

    						var word = confirmedSearchWord;

    					}

    					searchConfirmed(word, status, searchLength);

    				} else {

    					confirmRequests(confirmedLength);

    				}

    				break;

    			case 'ongoing-jobs' :

    				if (searchLength > 0) {

    					var ongoingKeyWord = $("#ongoing_job_search").val();

    					var ongoingSearchWord = $("#ongoing_sorting_key").val();

    					if (ongoingKeyWord != '') {

    						var status = false;

    						var word = ongoingKeyWord;

    					} else {

    						var status = true;

    						var word = ongoingSearchWord;

    					}

    					searchOngoing(word, status, searchLength);

    				} else {

    					ongoingRequests(ongoingLength);

    				}

    				break;

    			default :

    				postedRequests(postedLength);

    				break;

    		}

	    	

    	}
    }
});




function searchDraft(val, status, searchLength) {

	$("#default_draft").html("");

	$("#draft_requests").html("");

	if (status) {

		var sorting_key = val;

		var searching_key = $("#draft_job_search").val();

	} else {

		var sorting_key = $("#draft_sorting_key").val();

		var searching_key = val;
	}

	$.ajax ({

		type : "POST",

		url : "{{route('user.ajax_draft_requests')}}",

		beforeSend : function () {

			$("#draft_loader").html('<h1 class="text-center theme-color"><i class="fa fa-spinner fa-spin"></i></h1>');
		},

		data : {skip : searchLength, search_key : searching_key, sorting_status : status, sorting_key : sorting_key},

		async : false,

		success : function (data) {

			$("#draft_requests").append(data.view);

			if (data.length == 0) {

				stopScroll = true;

			} else {

				stopScroll = false;

				searchLength = parseInt(searchLength) + data.length;

			}

		}, 

		complete : function() {

			$("#draft_loader").html('');

		},

		error : function (data) {


		},

	});
}

function searchPosted(val, status, searchLength) {

	$("#default_posted").html("");

	$("#posted_requests").html("");

	if (status) {

		var sorting_key = val;

		var searching_key = $("#posted_job_search").val();

	} else {

		var sorting_key = $("#posted_sorting_key").val();

		var searching_key = val;
	}

	$.ajax ({

		type : "POST",

		url : "{{route('user.ajax_posted_requests')}}",

		beforeSend : function () {

			$("#posted_loader").html('<h1 class="text-center theme-color"><i class="fa fa-spinner fa-spin"></i></h1>');
		},

		data : {skip : searchLength, search_key : searching_key, sorting_status : status, sorting_key : sorting_key},

		async : false,

		success : function (data) {

			$("#posted_requests").append(data.view);

			console.log(parseInt(data.length) == 0);

			if (parseInt(data.length) == 0) {

				stopScroll = true;

			} else {

				stopScroll = false;

				searchLength = parseInt(searchLength) + data.length;

			}

		}, 

		complete : function() {

			$("#posted_loader").html('');

		},

		error : function (data) {


		},

	});
}


function searchConfirmed(val, status, searchLength) {

	$("#default_confirmed").html("");

	$("#confirmed_requests").html("");

	if (status) {

		var sorting_key = val;

		var searching_key = $("#confirmed_job_search").val();

	} else {

		var sorting_key = $("#confirmed_sorting_key").val();

		var searching_key = val;
	}

	$.ajax ({

		type : "POST",

		url : "{{route('user.ajax_confirmed_requests')}}",

		beforeSend : function () {

			$("#confirmed_loader").html('<h1 class="text-center theme-color"><i class="fa fa-spinner fa-spin"></i></h1>');
		},

		data : {skip : searchLength, search_key : searching_key, sorting_status : status, sorting_key : sorting_key},

		async : false,

		success : function (data) {

			$("#confirmed_requests").append(data.view);

			console.log(parseInt(data.length) == 0);

			if (parseInt(data.length) == 0) {

				stopScroll = true;

			} else {

				stopScroll = false;

				searchLength = parseInt(searchLength) + data.length;

			}

		}, 

		complete : function() {

			$("#confirmed_loader").html('');

		},

		error : function (data) {


		},

	});
}

function searchOngoing(val, status, searchLength) {

	$("#default_ongoing").html("");

	$("#ongoing_requests").html("");

	if (status) {

		var sorting_key = val;

		var searching_key = $("#ongoing_job_search").val();

	} else {

		var sorting_key = $("#ongoing_sorting_key").val();

		var searching_key = val;
	}

	$.ajax ({

		type : "POST",

		url : "{{route('user.ajax_ongoing_requests')}}",

		beforeSend : function () {

			$("#ongoing_loader").html('<h1 class="text-center theme-color"><i class="fa fa-spinner fa-spin"></i></h1>');
		},

		data : {skip : searchLength, search_key : searching_key, sorting_status : status, sorting_key : sorting_key},

		async : false,

		success : function (data) {

			$("#ongoing_requests").append(data.view);

			console.log(parseInt(data.length) == 0);

			if (parseInt(data.length) == 0) {

				stopScroll = true;

			} else {

				stopScroll = false;

				searchLength = parseInt(searchLength) + data.length;

			}

		}, 

		complete : function() {

			$("#ongoing_loader").html('');

		},

		error : function (data) {


		},

	});
}


 $("#confirmed_job_badge").click(function() {

 	var confirmed_job_badge = $('.confirmed_job_badge').html();

 	if (parseInt(confirmed_job_badge) > 0) {

	    $.ajax({
	        'url' : '{{ url("/api/user/change_confirmed_notifications") }}',
	        'type' : 'post',
	        data : {id : "{{Auth::user()->id}}", token : "{{Auth::user()->token}}"},    
	        'success' : function(response) {

	            console.log(response);

	        }
	    
	    });

	}

});


$("#ongoing_job_badge").click(function() {

 	var ongoing_job_badge = $('.ongoing_job_badge').html();

 	if (parseInt(ongoing_job_badge) > 0) {

	    $.ajax({
	        'url' : '{{ url("/api/user/change_ongoing_notifications") }}',
	        'type' : 'post',
	        data : {id : "{{Auth::user()->id}}", token : "{{Auth::user()->token}}"},    
	        'success' : function(response) {

	            console.log(response);

	        }
	    
	    });

	}

});


</script>
@endsection