@extends('layouts.user')

@section('content')

<div class="content-wrap gray-bg">

	<div class="container col-lg-7 col-md-offset-3">
 
		<div class="jobs white-bg m-30 p-f-30">

                <div class="box box-success">
                    <div class="box-header">
                      <i class="fa fa-comments-o"></i>

                      <h3 class="box-title">{{tr('see_all_notifications')}}</h3>

                    </div>

                    <hr>
                    <div class="box-body chat" id="chat-box">

                    @foreach($model as $notify)
                      <!-- chat item -->
                      <div class="item">
                        
                          <img src="{{$notify->picture ? $notify->picture : asset('placeholder.png')}}" alt="user image" class="online">

                          <div class="message">
                            <a href="{{route('user.jobs.view' , ['request_unique_id' => $notify->unique_id])}}" class="name">
                              <small class="text-muted pull-right"><i class="fa fa-clock-o"></i> {{$notify->created_at->diffForHumans()}}</small>
                              {{$notify->name}}
                            </a>
                            <?= $notify->notification ;?>
                          </div>
                          
                          <!-- /.attachment -->
                      </div>
                      <hr>
                    @endforeach
                      
                      <!-- /.item -->
                    </div>
                    <!-- /.chat -->
           
                </div>



        		

        		@if(count($model) > 0)


        			 <div class="row">
                        <div class="col-md-12">
                            <div align="center" id="paglink"><?php echo $model->links(); ?></div>
                        </div>
                    </div>
                    

        		@endif

        		@if(count($model) == 0)

        			<div class="dashboard-list-outer">
						<!-- DAshboard list -->

						
							<h1 class="text-center theme-color"><i class="fa fa-spinner fa-spin"></i></h1>

							<h3 class="text-center">{{tr('no_result_content')}}</h3>
													
					</div>

        		@endif
 
        	</div>

      </div>

      <div class="clearfix"></div>
</div>

@endsection