@extends('layouts.user')

@section('after-styles')
<style>
	.truncate {
	  width: 15em;
	  white-space: nowrap;
	  overflow: hidden;
	  text-overflow: ellipsis;
	}
</style>
@endsection

@section('content')

<div class="content-wrap gray-bg">

	<div class="container">

		@include('notification.notify')
		
		<h3>

			<span>{{tr('ongoing_requests')}} </span>

			<a href="{{route('user.jobs.index')}}" class="pull-right btn btn-success">{{tr('back')}}</a>

		</h3>

		<div class="jobs white-bg m-30 p-f-30">

			<!-- jobs-head -->

			<div class="jobs-head row m-0">


				<ul class="nav nav-tabs job-tabs" role="tablist">

					<li role="presentation" class="active col-lg-3 col-md-3 col-sm-3 col-xs-12 p-0">
						<a href="#ondemand_requests" aria-controls="confirm-jobs" role="tab" data-toggle="tab">
							{{tr('ondemand_requests')}}
						</a>
					</li>

					<li role="presentation" class="col-lg-3 col-md-3 col-sm-3 col-xs-12 p-0">
						<a href="#later_requests" aria-controls="later_requests" role="tab" data-toggle="tab">{{tr('later_requests')}}
						</a>
					</li>
				</ul>
			
			</div>
			<!-- End of jobs-head -->

			<!-- Job content -->

			<div class="tab-content job-content">

				<!-- Drafts tab -->
				<div role="tabpanel" class="tab-pane fade in active" id="ondemand_requests">
					<!-- Job details-list -->
					<div class="job-details-list-row row m-0 p-30">

						<h3 class="job-main-tit"></h3>

						<!-- <h4 class="job-sub-tit">{{count($ondemand_requests)}} Results</h4> -->

						<div class="dashboard-list-outer">
							<!-- DAshboard list -->

							@if($ondemand_requests)

								@foreach($ondemand_requests as $pr => $now_request)
							
									<div class="dashboard-list row m-0 create-job-shadow">

										<!-- Dashboard-list-box -->
										<div class="dashboard-list-col col-lg-5 col-md-12 col-sm-12 col-xs-12">
											<div class="dashboard-list-box">
												<h3 class="dashboard-list-tit job_name">{{$now_request->name}}</h3>
												<p class="dashboard-list-txt">
													<span><b>{{tr('request_date')}} : </b> @if($now_request->request_date) {{$now_request->request_date}} @endif </span>
												</p>
											</div>
										</div>
										<!-- End of dashboard-list-box -->

										<!-- Dashboard-list-box -->
										<div class="dashboard-list-col col-lg-2 col-md-12 col-sm-12 col-xs-12">
											<div class="dashboard-list-box">
												<p class="dashboard-list-txt">
													<i class="ion-arrow-graph-up-left"></i> {{job_type($now_request->job_type)}}
												</p>
												<p class="dashboard-list-txt">
													<i class="ion-arrow-graph-down-left"></i> {{request_type($now_request->request_type)}}
												</p>
											</div>
										</div>
										<!-- End of dashboard-list-box -->

										<!-- Dashboard-list-box -->
										<div class="dashboard-list-col col-lg-2 col-md-12 col-sm-12 col-xs-12">
											<div class="dashboard-list-box">
												<p class="dashboard-list-txt m-t-20">
												 	<i class="fa fa-info"></i>
												 	{{tr('waiting')}}
												</p>
											</div>
										</div>
										<!-- End of dashboard-list-box -->

										<!-- Dashboard-list-box -->
										<div class="dashboard-list-col col-lg-3 col-md-12 col-sm-12 col-xs-12">
											<div class="dashboard-list-box">

												<a href="{{route('user.jobs.view' , ['request_unique_id' => $now_request->unique_id])}}" class="btn btn-success m-t-15" title="View Job"><i class="fa fa-eye"></i></a>

												<a href="{{route('user.requests.update' , ['request_id' => $now_request->unique_id])}}" class="btn btn-warning m-t-15" title="Edit Job"><i class="fa fa-edit"></i></a>

												<form class="job-form m-t-15" action="{{route('user.jobs.cancel')}}" method="POST">

													<input type="hidden" name="request_id" value="{{$now_request->request_id}}" >
													<button type="submit" onclick="return confirm('Are You Sure??')}}')" class="btn btn-danger m-t-15" class="" title="Cancel Job"><i class="fa fa-times"></i></button>


												</form>

											</div>
										</div>
										<!-- End of dashboard-list-box -->
									</div>

								@endforeach

							@else
								<h3 class="text-center">{{tr('no_result_content')}}</h3>
							@endif
						
						</div>
					</div>
					<!-- End of job details list -->
				
				</div>
				<!-- End of Drafts tab -->

				<!-- Confirmed Jobs -->

				<div role="tabpanel" class="tab-pane fade" id="later_requests">
					<!-- Job details-list -->
					<div class="job-details-list-row row m-0 p-30">

						<h3 class="job-main-tit"></h3>

						@if($later_requests)

							<h4 class="job-sub-tit">{{count($later_requests)}} Results</h4>
							
						@endif

						<div class="dashboard-list-outer">

							@if($later_requests)

								@foreach($later_requests as $pr => $later_request)

									<div class="dashboard-list row m-0 create-job-shadow">

										<!-- Dashboard-list-box -->
										<div class="dashboard-list-col col-lg-4 col-md-12 col-sm-12 col-xs-12">
											<div class="dashboard-list-box">
												<h3 class="dashboard-list-tit truncate">{{$later_request->name}}</h3>
												<p class="dashboard-list-txt">
													<span><b>Created : </b> {{$later_request->request_date}} </span>
												</p>
											</div>
										</div>
										<!-- End of dashboard-list-box -->

										<!-- Dashboard-list-box -->
										<div class="dashboard-list-col col-lg-3 col-md-12 col-sm-12 col-xs-12">
											<div class="dashboard-list-box">
												<p class="dashboard-list-txt">
													<i class="ion-arrow-graph-up-left"></i> 
													{{$later_request->category_name}}
												</p>
												<p class="dashboard-list-txt">
													<i class="ion-arrow-graph-down-left"></i> 
													{{request_type($later_request->request_type)}}
												</p>
											</div>
										</div>
										<!-- End of dashboard-list-box -->

										<!-- Dashboard-list-box -->
										<div class="dashboard-list-col col-lg-2 col-md-12 col-sm-12 col-xs-12">
											<div class="dashboard-list-box">
												<p class="dashboard-list-txt m-t-20">
												 	<i class="fa fa-info-circle"></i>
												 	{{request_status($later_request->status)}}
												</p>
											</div>
										</div>
										<!-- End of dashboard-list-box -->

										<!-- Dashboard-list-box -->
										<div class="dashboard-list-col col-lg-3 col-md-12 col-sm-12 col-xs-12">
										
											<div class="dashboard-list-box">

												<a href="{{route('user.jobs.view' , ['request_unique_id' => $later_request->unique_id])}}" class="btn btn-success m-t-15 text-center"><i class="fa fa-eye"></i> {{tr('view')}}</a>
								
											</div>
										</div>
										<!-- End of dashboard-list-box -->
									</div>

								@endforeach

							@else

								<h3 class="text-center">{{tr('no_result_content')}}</h3>

							@endif
							
						</div>


					</div>
					<!-- End of job details list -->
				
				</div>

				<!-- End of Confirmed Jobs -->

			</div>

			<!-- end of Job content  -->
		
		</div>
	
	</div>

</div>

@endsection

@section('after-scripts')

<script type="text/javascript">

/***
 * This function used to check any request is entered for ongoing
 *
 *
 *
 ***/
	
	var provider_id = "{{Auth::user()->id}}";
	var token = "{{Auth::user()->token}}";

	var ondemand_requests = "{{count($ondemand_requests)}}";

	var later_requests = "{{count($later_requests)}}";

    window.setInterval(function() {

        $.ajax({
            'url' : '{{ url("/api/user/request_status_check_now") }}',
            'data' : {id : provider_id , token : token },
            'type' : 'POST',
            'success' : function(response) {

                if (response.success == true) {

                	// alert(response.data.length == ondemand_requests);

                	// Check the current ondemand == new ondemand count

                    if(response.data.length == ondemand_requests) {
                       	console.log('No LOAD');
                    } else {
                        // location.reload(); 
                    }
                }
            }
        });

        $.ajax({
            'url' : '{{ url("/api/user/request_status_check_later") }}',
            'data' : {id : provider_id , token : token },
            'type' : 'POST',
            'success' : function(response) {

                if (response.success == true) {

                	// alert(response.data.length == later_requests);
                	
                	// Check the current ondemand == new ondemand count

                    if(response.data.length == later_requests) {
                       	console.log('No LOAD');
                    } else {
                        //location.reload(); 
                    }
                }
            }
        });
    
    }, 3000);

</script>

@endsection