@extends('layouts.user')

@section('after-styles')

<link rel="stylesheet" type="text/css" href="{{asset('common/css/grid-gallery.css')}}">

@endsection

@section('content')

<div class="content-wrap gray-bg">
	<div class="container">

		<div class="other-profiles m-30 white-bg p-f-30">

			<div class="other-profiles-inner row m-0">

				<h4 class="others-prof-tit">
					{{tr('provider_profile')}}
				</h4>
				
				<!-- profile -->
				<div class="otherprofile-sec">
					
					<div class="other_profile_img">
						<img src="{{$provider->picture}}">
					</div>

					<div class="otherprofile-details">

						<h3 class="other_profile_name">{{$provider->name}}</h3>

						<h4 class="other_profile_details"><i class="fa fa-phone mr-5"></i>&nbsp;
							{{$provider->mobile}}
						</h4>

						<h4 class="other_profile_details"><i class="fa fa-envelope mr-5"></i>&nbsp;

							{{$provider->email}}
						</h4>

						<h4 class="other_profile_details">
							<i class="fa fa-suitcase mr-5"></i>&nbsp;
							<span class="theme-color">{{count($provider->completed)}} {{tr('completed_jobs')}}</span>
						</h4>
					</div>
				</div>
				<!-- profile -->

				<!-- tab content -->

				<ul class="nav nav-tabs otherprofile_tab">

				    <li class="active"><a data-toggle="tab" href="#about">{{tr('about')}}</a></li>

				    <li><a data-toggle="tab" href="#gallery">{{tr('gallery')}}</a></li>

				    <li><a data-toggle="tab" href="#reviews">{{tr('reviews')}}</a></li>

				</ul>

				<div class="tab-content">

				    <div id="about" class="tab-pane fade in active">

				      	<div class="otherprofile_secspace">

				      		<h4 class="otherprofile_tabhead">{{tr('how_can_i_help')}}</h4>

				      		<p class="otherprofile_tabdesc">
				      			{{$provider->description}}
				      		</p>

				      		@if($provider->promo_video)

					      		<!-- <p class="otherprofile_tabhead">{{tr('promo_video')}}</p> -->

					      		<!-- 16:9 aspect ratio -->
								 <iframe class="embed-responsive-item" width="560" height="315" src="{{$provider->promo_video}}" allowfullscreen></iframe>

				      		@endif

				      	</div>
				    
				    </div>

				    <div id="gallery" class="tab-pane fade">

				    	<div class="otherprofile_secspace">
					      	
					      	<div id="gg-screen"></div>

					      	<div class="gg-box">

					      		@if(count($provider->providerGalleries))

						      		@foreach($provider->providerGalleries as $provider_gallery_details)

										<div class="gg-element">

											<img src="{{$provider_gallery_details->picture}}">

										</div>

									@endforeach

								@endif
								
						    
						    </div>

					    </div>
				    
				    </div>

				    <div id="reviews" class="tab-pane fade">

					    <div class="otherprofile_secspace">

					      	<h4 class="otherprofile_tabhead">{{tr('reviews')}}</h4>

					      	@if(count($reviews) != 0)

					 			@foreach($reviews as $r => $profile_review)

							      	<div class="otherprofile_review">

							      		<div class="left">
							      			<img src="{{$profile_review->user->picture}}">
							      		</div>

							      		<div class="right">

							      			<h5 class="reviews-desc">{{$profile_review->comment}}</h5>

							      			<p class="reviews-date">{{$profile_review->created_at ? $profile_review->created_at->diffForHumans() : ""}}</p>

							      		</div>

							      	</div>

							    @endforeach

								<div align="right">{{$reviews->links()}}</div>

							@endif

					    </div>
				    </div>
				    
				</div>

				<!-- tab content -->
			</div>
		</div>
	
	</div>
</div>

<!-- review modal -->

<!-- Modal -->

@endsection

@section('after-scripts')

<script type="text/javascript" src="{{asset('common/js/grid-gallery.min.js')}}"></script>

@endsection