@extends('layouts.user')

@section('after-styles')

<link href="{{asset('common/css/star.rating.min.css')}}" rel="stylesheet">

<style>

	.btn-default.active {
		color: #fff !important;
	    background-color: #51af33 !important;
	    border-color: #51af33 !important;
	}

    html, body {
        height: 100%;
        margin: 0;
        padding: 0;
    }

    #map {
        height: 100%;
        min-height: 400px; 
    }

    table {
	    border-collapse: collapse;
	    border-spacing: 0;
	    width: 100%;
	    border: 1px solid #ddd;
	}

	th, td {
	    text-align: center;
	    padding: 16px;
	}

	th:first-child, td:first-child {
	    text-align: left;
	    color: gray;
	    text-transform: uppercase;
	}

	tr:nth-child(even) {
	    background-color: #32b90e0d;
	}


</style>

@endsection

@section('content')

<div class="content-wrap gray-bg">

	<div class="container">

		<div class="jobs white-bg m-30 p-f-30">

			@include('notification.notify')

			<!-- Job content -->
			<div class="provider-work-details">

				<div class="provider-work-row row m-0">
					<h3 class="job-main-tit row m-0">

						<span class="job-name pull-left">{{$request_details->name}}</span>

						<span></span>

						<span class="pull-right">{{common_date($request_details->request_date, Auth::user()->timezone)}}</span>
					</h3>

					@if($request_details->description)
					
						<p class="job-des">{{$request_details->description}}</p>

					@endif

					@if($request_details->cancelled_by)
					
						<p class="job-des text-danger">

							<span class="text-uppercase">{{tr('cancelled_by')}} - {{$request_details->cancelled_by}}</span>

							<br>

							<span class="text-danger">{{$request_details->cancelled_reason}}</span>

							<br>

							<span class="text-gray">{{common_date($request_details->cancelled_date , Auth::user()->timezone)}}</span>

						</p>

						<p></p>

					@endif

					@if($request_details->note)
					
						<br>
						<p class="theme-color">{{tr('note')}} : {{$request_details->note}}</p>

					@endif

					<!-- tracking details -->
					<div class="tracking-details row m-0 m-30">

						@if($tracking = tracking($request_details->status , $request_details->provider_status))

							@foreach($tracking as $t => $value)

								<!-- 0 - disabled , 1 - active status , 2 = completed status -->

								<div class="track-details-col col-lg-2 col-md-2 col-sm-4 col-xs-12 p-0">
									<a href="javascript:void(0);" class="track-tab @if($value == 0) disabled @elseif($value == 1) active @else complete @endif">{{tr($t)}}</a>
								</div>

							@endforeach

						@endif


					</div>
					<!-- End of tracking details -->

					<div class="job-details-row row m-0">

						<!-- job-details-left -->
						<div class="job-details-left-col col-lg-6 col-md-6 col-sm-12 col-xs-12 p-l-0">

							<div class="job-details-left gray-bg p-f-30">

								<dl class="job-details row">

			        				@if($request_details->provider_id)

										<div class="job-details-sec">

											<a href="{{route('user.tasker.profile' , ['provider_id' => $request_details->provider->unique_id , 'request_id' => $request_details->unique_id])}}" target="_blank">

												<div class="incoming-img bg-img" style="background-image: url({{$request_details->provider->picture}});">

						        				</div>

					        				</a>

					        				<dd class="col-sm-12"></dd>

				        				</div>

				        				<div class="clear-fix"></div>

										<div class="job-details-sec">

											<dt class="col-sm-4">{{tr('provider')}} :</dt>
											
											<dd class="col-sm-8 theme-color">
												<a href="{{route('user.tasker.profile' , ['provider_id' => $request_details->provider->unique_id , 'request_id' => $request_details->unique_id])}}" class="theme-a" style="">{{$request_details->provider->name}}</a>
											</dd>
										</div>

										<div class="clear-fix"></div>
									@endif

									<div class="job-details-sec">

										<dt class="col-sm-4">{{tr('job_type')}} :</dt>

										<dd class="col-sm-8">{{job_type($request_details->job_type)}}</dd>
										
									</div>

									<div class="clear-fix"></div>

									@if($request_details->job_type != REQUEST_NOW)

										<div class="job-details-sec">
											<dt class="col-sm-4">{{tr('request_type')}} :</dt>
											<dd class="col-sm-8">{{request_type($request_details->request_type)}}</dd>
										</div>

										<div class="clear-fix"></div>

									@endif

									<div class="job-details-sec">
										<dt class="col-sm-4">{{tr('request_status')}} :</dt>
										
										<dd class="col-sm-8 theme-color">
											{{request_status($request_details->status)}}
										</dd>
									</div>

									<div class="clear-fix"></div>

									<div class="job-details-sec">
										<dt class="col-sm-4">{{tr('provider_status')}} :</dt>
										
										<dd class="col-sm-8 theme-color">
											{{provider_status($request_details->provider_status)}}
										</dd>
									</div>

									<div class="clear-fix"></div>

									<div class="job-details-sec">
										<dt class="col-sm-4">{{tr('category')}} :</dt>
										<dd class="col-sm-8">{{$request_details->category->name}}</dd>
									</div>

									<div class="clear-fix"></div>

									<div class="job-details-sec">
										<dt class="col-sm-4">{{tr('sub_category')}} :</dt>
										<dd class="col-sm-8">{{$request_details->subCategory->name}}</dd>
									</div>

									<div class="clear-fix"></div>

									<div class="job-details-sec">
										<dt class="col-sm-4">{{tr('address')}} :</dt>
										<dd class="col-sm-8">{{$request_details->s_address}}</dd>
									</div>

									<div class="clear-fix"></div>

									<div class="job-details-sec">
										<dt class="col-sm-4">{{tr('payment_mode')}} :</dt>
										<dd class="col-sm-8 uppercase">
											{{$request_details->payment_mode ? $request_details->payment_mode : "-"}}
										</dd>
									</div>

									<div class="clear-fix"></div>

									<div class="job-details-sec">
										<dt class="col-sm-4">{{tr('price_type')}}:</dt>
										<dd class="col-sm-8">{{$request_details->price_type}}</dd>
									</div>

									<div class="clear-fix"></div>
									
									@if($request_details->job_type != REQUEST_NOW)

									<div class="job-details-sec">
										<dt class="col-sm-4">{{tr('initial_per_hour_price')}}:</dt>
										<dd class="col-sm-8">{{$request_details->currency}}{{$request_details->user_price}}{{$request_details->price_per_symbol}}</dd>
									</div>
									<div class="clear-fix"></div>

									@endif									

									<div class="job-details-sec">
										<dt class="col-sm-4">{{tr('final_per_hour_price')}}:</dt>
										<dd class="col-sm-8">
											@if($request_details->price_per_hour) 
												{{$request_details->currency}}{{$request_details->price_per_hour}}{{$request_details->price_per_symbol}}
											@else 
												-
											@endif
										</dd>
									</div>

									@if($request_details->status == REQUEST_COMPLETED)

										<div class="clear-fix"></div>

										<div class="job-details-sec">
											<dt class="col-sm-4">{{tr('is_fav_provider')}}:</dt>
											<dd class="col-sm-8">
												@if($request_details->is_fav_provider) 
													{{tr('yes')}}
												@else 
													{{tr('no')}}
												@endif
											</dd>
										</div>
										<div class="job-details-sec">
											<dt class="col-sm-4">{{tr('is_abused_provider')}}:</dt>
											<dd class="col-sm-8">
												@if($request_details->is_abused_provider) 
													{{tr('yes')}}
												@else 
													{{tr('no')}}
												@endif
											</dd>
										</div>

									@endif

								</dl>

							</div>
						
						</div>

						<!-- End of details-left -->

						<!-- job-details-right -->

						<div class="job-details-right-col col-lg-6 col-md-6 col-sm-12 col-xs-12">

							@if($request_details->provider_status > 0 && $request_details->status < REQUEST_COMPLETE_PENDING  || $request_details->request_type == REQUEST_TYPE_DIRECT)

								@if($request_details->provider_id)

									<a class="btn btn-success" target="_blank" href="{{route('user.chat' , ['request_id' => $request_details->unique_id , 'provider_id' => $request_details->provider->unique_id])}}" style="width: 100%;margin-bottom: 10px;padding: 10px;">
										{{tr('chat')}}
									</a>

								@endif

							@endif

							<!-- Until provider started from they location, user can cancel the request -->

							@if($request_details->status <= REQUEST_ONGOING && $request_details->provider_status < PROVIDER_STARTED )

								<button type="button" class="btn btn-danger" data-toggle="modal" data-target="#cancelRequestModel{{$request_details->id}}" style="width: 100%;margin-bottom: 10px; padding: 10px;">
									{{tr('cancel')}}
								</button>

							@endif

							@if($request_details->provider_status < PROVIDER_SERVICE_COMPLETED && $request_details->status <= REQUEST_ONGOING || in_array($request_details->status , [REQUEST_CANCELLED , REQUEST_NO_PROVIDER_AVAILABLE , REQUEST_TIME_EXCEED_CANCELLED]))
						
								<div class="job-details-right">
	                                <div id="map"></div>
								</div>

							@endif

							<!-- Invoice -->

							@if(in_array($request_details->status , [REQUEST_COMPLETE_PENDING,WAITING_PAYMENT_CONFIRM , REQUEST_RATING , REQUEST_COMPLETED]))
								
								<div class="job-details-right">

									<table>

										<tr>
											<h3 class="create-job-shadow p-5">{{tr('invoice')}}</h3>
										</tr>
										<tr>
										    <th style="width:50%">{{tr('payment_mode')}}</th>
										    <th class="text-uppercase">{{$request_details->payment_mode}}</th>
										</tr>
										<tr>
											<td>{{tr('total_time')}}</td>
											<td>{{$request_details->payments->total_time}} hrs</td>
										</tr>

										<tr>
											<td>{{tr('price_per_hour')}}</td>
											<td>
											{{$request_details->currency}} {{$request_details->price_per_hour}} {{$request_details->price_per_symbol}}
											</td>
										</tr>

										<tr>
											<td>{{tr('sub_total')}}</td>
											<td>
											{{$request_details->currency}} {{$request_details->payments->sub_total}}
											</td>
										</tr>

										<tr>
											<td>{{tr('tax_price')}}</td>
											<td>
											{{$request_details->currency}} {{$request_details->payments->tax_price}}
											</td>
										</tr>

										@if($request_payment_details->is_coupon_applied == YES)

											<tr>
												<td>{{tr('coupon_code')}}</td>
												<td>
												
													{{$request_payment_details->coupon_code}} 
												</td>
											</tr>

											<tr>
												<td>{{tr('coupon_amount')}}</td>
												<td>
												
													{{$request_details->currency}} {{$request_payment_details->coupon_amount}} 
												</td>
											</tr>

										@else

											<tr class="invoice_coupon_section" style="display: none;">
												<td>{{tr('coupon_code')}}</td>

												<td id="invoice_coupon_code"> - </td>

											</tr>

											<tr class="invoice_coupon_section" style="display: none;">

												<td>{{tr('coupon_amount')}}</td>

												<td id="invoice_coupon_amount"> - </td>
											</tr>

												
										@endif

										<tr>
											<td>{{tr('total')}}</td>
											<td>
												{{$request_details->currency}} 
												<span id="invoice_total">{{$request_details->payments->total}}</span>
											</td>
										</tr>

									</table>

									@if($request_details->status == REQUEST_COMPLETE_PENDING)

										<form action="{{route('user.requests.payment')}}" method="post">

											<input type="hidden" name="request_id" value="{{$request_details->id}}">

											<input type="hidden" name="is_paid" value="0">

											<input type="hidden" name="coupon_code" id="final_coupon_code" value="">

											<br>

											<p>{{tr('do_u_have_coupon_code')}}	

											<a href="#" class="" data-toggle="modal" data-target="#applyCouponModal">
												<span class="link-clr text-uppercase"><b>{{tr('apply_coupon')}}</b></span>
											</a>

											</p>

											<div class="btn-group" data-toggle="buttons">

												<h4><b>{{tr('choose_payment_mode')}}</b></h4>

												@if(Setting::get('cod'))

										        <label id="payment_mode_cod" class="btn btn-default @if(Auth::user()->payment_mode == 'cod') active @endif">
										            <input type="radio" name="payment_mode" value="cod" @if(Auth::user()->payment_mode == 'cod') checked="checked" @endif">{{tr('cod')}}
										        </label>

										        @endif

												@if(Setting::get('card')==1)

											        @if(count(Auth::user()->userCards) > 0)

											        <label id="payment_mode_card" class="btn btn-default @if(Auth::user()->payment_mode == 'card') active @endif">
											            <input type="radio" name="payment_mode" value="card" @if(Auth::user()->payment_mode == 'card') checked="checked" @endif">{{tr('card')}}
											        </label>

											        @endif

										        @endif

								    		</div>

								    		<br>

								    		<br>
        									
        									<button type="reset" class="btn btn-danger">{{tr('reset')}}</button>

											<button type="submit" class="btn btn-success text-uppercase">{{tr('paynow')}}</button>

										</form>

									@elseif($request_details->status == WAITING_PAYMENT_CONFIRM)

										<h4 style="color: brown;margin-top: 10px !important" class="text-center">
											<b>Waiting for Provider Confirmation</b>
										</h4>

									@elseif($request_details->status == REQUEST_RATING)

										<form class="" method="POST" action="{{route('user.requests.rating')}}">

											<input type="hidden" name="request_id" value="{{$request_details->id}}">

											<input type="hidden" name="provider_id" value="{{$request_details->provider_id}}">

											<div class="rating-sec">

												<h3 class="">{{tr('rate_provider')}}</h3>

												<input id="rating-system" name="rating" type="number" class="rating" min="1" max="5" step="1">

											</div>

											<div class="comment-sec">

												<h3 class="">{{tr('comment')}}</h3>

												<div class="form-group">
													<textarea class="form-control" required name="comment" style="resize: none" rows="3" placeholder="{{tr('comment')}}"></textarea>
												</div>

												<div class="form-check">
												    <label class="form-check-label">
														<input type="checkbox" id="is_abuse" name="is_abuse" value="1"> 
														<span class="text-danger">{{tr('mark_as_abuse')}}</span>
													</label>

													<label class="form-check-label">
														<input type="checkbox" id="is_fav_provider" name="is_fav_provider" value="1"> <span class="text-success">{{tr('mark_as_fav_provider')}}</span>
													</label>
												</div>

												<div class="form-check">
												    
												</div>

											</div>

											<button type="submit" class="common-bg-link">{{tr('submit')}}</button>

										</form>

									@else


									@endif

								</div>

							@endif
						
						</div>
						<!-- end of job-details right -->
					</div>
					
					<!-- Job details-list -->

					@if(count($bids = $request_details->bids))

						<div class="job-details-list-row row m-0 p-30">
							
							<div class="tracking-details row m-0 m-30">

								<div class="track-details-col col-lg-12 col-md-3 col-sm-6 col-xs-12 p-0">

									<a href="javascript:void(0);" class="track-tab complete create-job-shadow bid-heading">
										<i class="fa fa-hand-o-right"></i>
										{{tr('bid_providers')}}
									</a>
								</div>

							</div>

							@foreach($request_details->bids as $bid)

								<?php $provider = provider_details($bid->provider_id); ?>

								<div class="dashboard-list row m-0 create-job-shadow">

									<div class="dashboard-list-col col-lg-1 col-md-2 col-sm-5 col-xs-12">

										<div class="dashboard-list-box">

											<img class="img-circle img-responsive" width="100%" height="100%" src="{{$provider->picture}}">
										</div>
									</div>
									<!-- Dashboard-list-box -->
									<div class="dashboard-list-col col-lg-3 col-md-5 col-sm-5 col-xs-12">
										<div class="dashboard-list-box">
											<h3 class="dashboard-list-tit">
												<a href="{{route('user.tasker.profile' , ['provider_id' => $provider->unique_id  , 'request_id' => $request_details->unique_id])}}" class="theme-a">{{$provider->name}}</a>
											</h3>
											<p class="dashboard-list-txt">
												@if($bid->status == REQUEST_META_ASSIGNED)
													<span>{{tr('waiting_provider_response')}}</span>
												@endif
											</p>
										</div>
									</div>
									<!-- End of dashboard-list-box -->

									<!-- Dashboard-list-box -->
									<div class="dashboard-list-col col-lg-3 col-md-2 col-sm-2 col-xs-12">
										<div class="dashboard-list-box">
											<h3 class="dashboard-list-tit">{{tr('request_date')}}</h3>
											<p class="dashboard-list-txt">
												<span> <b>{{common_date($request_details->request_date, Auth::user()->timezone)}}</b> </span>

											</p>
										</div>
									</div>
									<!-- End of dashboard-list-box -->
									
									<!-- Dashboard-list-box -->
									<div class="dashboard-list-col col-lg-2 col-md-2 col-sm-2 col-xs-12">
										<div class="dashboard-list-box">
											<p class="dashboard-list-txt  p-t-20">
												{{$request_details->currency}}{{$bid->bid_amount}}{{$request_details->price_per_symbol}}
											</p>
										</div>
									</div>
									<!-- End of dashboard-list-box -->
									<!-- Dashboard-list-box -->
									<div class="dashboard-list-col col-lg-3 col-md-3 col-sm-3 col-xs-12">

										<div class="dashboard-list-box" style="margin-top: 10px">

											@if($bid->status == REQUEST_META_BID)

												<!-- Small modal -->

												<div class="modal fade" tabindex="-1" role="dialog" id="acceptRequest{{$bid->id}}" aria-labelledby="acceptRequestLabel">
												  	
												  	<div class="modal-dialog" role="document">

												    	<div class="modal-content">
												    		<form action="{{route('user.jobs.assign')}}" method="POST" class="job-form">

												      		<div class="modal-header btn-success">

												        		<button type="button" class="close" data-dismiss="modal" aria-label="Close">
												        			<span aria-hidden="true">&times;</span>

												        		</button>

												        		<h4 class="modal-title" id="acceptRequestLabel">{{tr('accept_bid')}} - {{$request_details->currency}}{{$bid->bid_amount}}{{$request_details->price_per_symbol}}</h4>
												      		
												      		</div>

															<div class="modal-body">

																<input type="hidden" name="request_id" value="{{$request_details->id}}">
																
																<input type="hidden" name="request_meta_id" value="{{$bid->id}}">

																<p> {{tr('note')}} : {{tr('final_price_accept_content')}}</p>

																<label><b>{{tr('final_per_hour_price')}} {{$request_details->price_per_symbol}}</b></label>

																<input type="number" step="any" min="1" pattern="[0-9]+(\.[0-9]{0,2})?%?" title="This must be a number with up to 2 decimal places and/or %" class="form-control" name="price_per_hour" class="form-control" placeholder="{{tr('final_per_hour_price')}}">
																
															</div>

													      	<div class="modal-footer">

																<button type="submit" class="btn btn-success">{{tr('accept')}}</button>
													        														      	
													      	</div>
															
															</form>					     

												    	</div>
												  	</div>
												
												</div>

												<button type="button" class="btn btn-success" data-toggle="modal" data-target="#acceptRequest{{$bid->id}}">{{tr('accept')}}</button>

												<form action="{{route('user.jobs.reject')}}" method="POST" class="job-form">

													<input type="hidden" name="request_id" value="{{$request_details->id}}">

													<input type="hidden" name="request_meta_id" value="{{$bid->id}}">
													
													<button type="submit" class="btn btn-danger">{{tr('reject')}}</button>

												</form>

											@else

											@endif

											<a target="_blank" href="{{route('user.chat' , ['request
											' => $request_details->unique_id , 'provider_id' => $provider->unique_id])}}" class="btn btn-info">{{tr('chat')}}</a>

										</div>
									</div>
									<!-- End of dashboard-list-box -->
								
								</div>

							@endforeach

									
						</div>

					@endif

					@if($request_details->before_image || $request_details->after_image)

						<div class="tracking-details row m-0 m-30">

							<div class="track-details-col col-lg-12 col-md-3 col-sm-6 col-xs-12 p-0">

								<a href="javascript:void(0);" class="track-tab complete create-job-shadow bid-heading">
									<i class="fa fa-picture-o"></i>
									{{tr('service_image')}}

								</a>
							</div>

						</div>

						<div class="job-details-row row m-0">

							@if($request_details->before_image)

								<!-- job-details-left -->
								<div class="job-details-left-col col-lg-6 col-md-6 col-sm-12 col-xs-12 p-l-0">

									<h3>{{tr('before_image')}}</h3>

									<div class="bg-img before-img" style="background-image: url({{$request_details->before_image}});">
										
									</div>

								</div>

							@endif

							@if($request_details->after_image)

								<div class="job-details-right-col col-lg-6 col-md-6 col-sm-12 col-xs-12">

									<h3>{{tr('after_image')}}</h3>

									<div class="bg-img before-img" style="background-image: url({{$request_details->after_image}});">
										
									</div>

								</div>

							@endif

						</div>	

					@endif


				</div>
			</div>
			<!-- end of Job content  -->
		</div>
	
	</div>

</div>

<div class="modal fade" tabindex="-1" role="dialog" id="cancelRequestModel{{$request_details->id}}" aria-labelledby="cancelRequestModelLabel">
												  	
  	<div class="modal-dialog" role="document">

    	<div class="modal-content">

    		<form action="{{route('user.jobs.cancel')}}" method="POST" class="job-form">
			
	      		<div class="modal-header btn-success">

	        		<button type="button" class="close" data-dismiss="modal" aria-label="Close">
	        			<span aria-hidden="true">&times;</span>

	        		</button>

	        		<h4 class="modal-title" id="cancelRequestModelLabel">{{tr('confirm_to_cancel_the_job')}}</h4>
	      		
	      		</div>

				<div class="modal-body">

					<input type="hidden" name="request_id" value="{{$request_details->id}}">
					
					<p class="text-gray"> {{tr('note')}} : {{tr('job_cancel_note')}}</p>

					<label>{{tr('job_cancel_label')}}</label>

					<input type="text" name="cancelled_reason" class="form-control">
					
				</div>

		      	<div class="modal-footer">

					<button type="submit" class="btn btn-danger" onclick="return confirm(&apos;{{tr('request_cancel_confirm')}}&apos;)" >{{tr('submit')}}
					</button>
		        														      	
		      	</div>
			
			</form>					     

    	</div>
  	
  	</div>

</div>

<!-- Modal -->
<div id="applyCouponModal" class="modal fade" role="dialog">

<div class="modal-dialog">

<!-- Modal content-->
<div class="modal-content">
  	<div class="modal-header">
    	<button type="button" class="close" data-dismiss="modal">&times;</button>
    	<h4 class="modal-title text-uppercase">{{tr('apply_coupon')}}</h4>
  	</div>
  	<div class="modal-body">
    	<form>

    		<input type="hidden" name="request_id" value="{{$request_details->id}}">

    		<div class="form-group">

                <label for="coupon_code">{{tr('enter_coupon_code')}}</label>

                <input id="coupon_code" class="form-control" placeholder="{{tr('type_coupon_code_here')}}" type="text">
                
            </div>

            <p id="coupon_code_apply_error" class="text-danger" style="display: none;"></p>

            <p id="coupon_code_apply_success" class="text-success" style="display: none;">
            	
            	{{tr('web_coupon_code_apply_success')}} 

            	<b><span id="coupon_code_discount_section"></span></b>
            </p>

        	<div class="text-right mt-20">

        		<button type="button" class="btn btn-default" data-dismiss="modal">{{tr('close')}}</button>

        		<button type="button" onclick="applyCoupon()" class="btn btn-success">{{tr('apply')}}</button>
        	</div>
        </form>
  	</div>
</div>

</div>

</div>

@endsection

@section('after-scripts')

<script src="{{asset('common/js/star.rating.min.js')}}"></script>

<script type="text/javascript">

	$(document).on("keypress", ":input:not(textarea)", function(event) {
	    if (event.keyCode == 13) {
	        event.preventDefault();
	    }
	});

	$(document).ready(function() {
		
		$('#rating-system').rating('refresh', 
			{
				disabled: false, 
				showClear: false, 
				showCaption: false,

			}
		);

		$('#is_abuse').change(function() {
	        if($(this).is(":checked")){
	          $('#is_fav_provider').attr('checked', false);
	        }    
	    });
	    
	    $('#is_fav_provider').change(function() {
	        if($(this).is(":checked")){
	          $('#is_abuse').attr('checked', false);
	        }    
	    });
	
	});

/****************** Request Details ****************************/

var providerStatus = "{{ $request_details->provider_status }}";

var serviceStatus = "{{ $request_details->status }}";

var request_id = "{{ $request_details->id }}";

window.setInterval(function() {

    $.ajax({
        'url' : '{{ route("user.requests.refresh.single") }}',
        'data' : {request_id : request_id},
        'type' : 'POST',
        'success' : function(response) {

            if (response.success == true) {

                if(response.requests != "") {

                	if(response.requests.status != serviceStatus) {

                		location.reload();	

                	} else if(response.requests.provider_status != providerStatus) {

                		location.reload();
                		
                	} else if(response.requests.provider_status == providerStatus && response.requests.status == serviceStatus) {

                    	console.log('No LOAD');

                    } else {

                    	console.log("No Load");
                        
                    } 

                } else {

                    location.reload(); 
                }
            }
        }
    });

}, 3000);

/****************** ****************************/

    var map;
    
    var serviceLocation = {lat: parseFloat("{{ $request_details->s_latitude }}"), lng: parseFloat("{{ $request_details->s_longitude }}")};

    function initMap() {
        map = new google.maps.Map(document.getElementById('map'), {
            center: serviceLocation,
            zoom: 15
        });

        var marker = new google.maps.Marker({
            map: map,
            position: serviceLocation,
            visible: true,
            animation: google.maps.Animation.DROP,
        });

        var infowindow = new google.maps.InfoWindow({
            content: "{{$request_details->s_address}}",
        });

        infowindow.open(map, marker);
    }

    function applyCoupon() {

    	var coupon_code = $('#coupon_code').val();

    	var request_id = "{{$request_details->id}}";

    	$.ajax({
            'url' : '{{ route("user.coupon.apply") }}',
            'data' : {request_id : request_id , coupon_code: coupon_code},
            'type' : 'POST',
            'success' : function(response) {

                if (response.success == true) {

                	$('#coupon_code_apply_error').val("").hide();

                	$('#coupon_code_apply_success').show();

                	$('#final_coupon_code').val(coupon_code);

                	$('#coupon_code_discount_section').html(response.data.original_coupon_amount);

                	// Invoice update

                	$('.invoice_coupon_section').show();

                	$('#invoice_coupon_code').html(response.data.coupon_code);

                	$('#invoice_coupon_amount').html(response.data.coupon_amount);

                	$('#invoice_total').html(response.data.remaining_amount);

                } else {

                	$('#coupon_code, #final_coupon_code').val("");

                	$('#coupon_code_apply_error').html(response.error).show();

                	$('#coupon_code_apply_success, .invoice_coupon_section').hide();

                }
            }
        });

    }
</script>

<script src="https://maps.googleapis.com/maps/api/js?key={{ envfile('GOOGLE_API_KEY') }}&libraries=places&callback=initMap" async defer></script>

@endsection

