var app = require('express')(); 
var server = require('http').Server(app);
var io = require('socket.io')(server);
var debug = require('debug')('Gentack:Chat');
var request = require('request');
var dotenv = require('dotenv').config();

var port = process.env.PORT || '3003';

var chat_save_url = process.env.CHAT_URL;

process.env.DEBUG = '*';

server.listen(port);

io.on('connection', function (socket) {

    // console.log(socket.id);

    console.log('new connection established');

    socket.reqid = socket.handshake.query.reqid;
    
    socket.join(socket.handshake.query.myid);

    socket.emit('connected', {'sessionID' : socket.id});

    socket.on('update sender', function(data) {

        console.log("Update Sender START");

        console.log('update sender', data);

        socket.handshake.query.myid = data.myid;

        socket.handshake.query.reqid = data.reqid;

        socket.reqid = socket.handshake.query.reqid;

        socket.join(socket.handshake.query.myid);

        socket.emit('sender updated', 'Sender Updated ID:'+data.myid, 'Request ID:'+data.reqid);

        console.log("Update Sender END");

    });

    socket.on('send message', function(data) {

        console.log("send message Start");

        if(data.type == 'up') {
            receiver = 'pu' + data.provider_id;
        } else {
            receiver = 'up' + data.user_id;
        }

        console.log('data', data);

        console.log('receiver', receiver);

        var sent_status = socket.broadcast.to(receiver).emit('message', data);

        url = chat_save_url+'message/save?user_id='+data.user_id
        +'&provider_id='+data.provider_id
        +'&message='+data.message
        +'&type='+data.type
        +'&request_id='+socket.reqid;

        console.log(url);

        request.get(url, function (error, response, body) {

        });

        console.log("send message END");

    });

    socket.on('disconnect', function(data) {

        console.log('disconnect', data);

    });
});