f<nav class="navbar navbar-default navbar-fixed-top" role="navigation">

	<div class="container">
		<div class="navbar-header">
			 
			<button type="button" class="navbar-toggle" data-toggle="collapse" data-target="#bs-example-navbar-collapse-1">
				<span class="sr-only">Toggle navigation</span>
				<span class="icon-bar"></span>
				<span class="icon-bar"></span>
				<span class="icon-bar"></span>
			</button> 

			<a class="navbar-brand" href="<?php echo e(url('/')); ?>">
				<div class="bg-img logo" style="background-image: url(<?php echo e(Setting::get('site_logo')); ?>);"></div>

			</a>

		</div>
		
		<div class="collapse navbar-collapse" id="bs-example-navbar-collapse-1">

			<ul class="nav navbar-nav navbar-right">

				<?php if(Auth::check()): ?>

					<li>
						<a href="<?php echo e(route('user.profile')); ?>"><?php echo e(tr('user')); ?></a>
					</li>

				<?php elseif(Auth::guard('provider')->check()): ?>

					<li>
						<a href="<?php echo e(route('provider.profile')); ?>"><?php echo e(tr('provider')); ?></a>
					</li>

				<?php else: ?>

					<li>
						<a href="<?php echo e(route('user.register.form')); ?>"><?php echo e(tr('signup')); ?></a>
					</li>
					
					<li>
						<a href="<?php echo e(route('user.login.form')); ?>"><?php echo e(tr('login')); ?></a>
					</li>

					<li>
						<a class="btn become-tasker-btn" href="<?php echo e(route('provider.register.form')); ?>"><?php echo e(tr('become_a_provider')); ?></a>
					</li>

				<?php endif; ?>
				
				<?php if(Setting::get('admin_language_control') == 0): ?>

					<?php if(count($languages = getActiveLanguages()) > 1): ?> 
					
						<li class="dropdown">
		                    
					        <a href="#" class="dropdown-toggle" data-toggle="dropdown" aria-expanded="false"><i class="fa fa-globe"></i>&nbsp;  <b class="caret"></b></a>
					        <ul class="dropdown-menu">
					        	<?php foreach($languages as $h => $language): ?>
					          		<li class="<?php echo e((\Session::get('locale') == $language->folder_name) ? 'active' : ''); ?>" ><a href="<?php echo e(route('user_session_language', $language->folder_name)); ?>" style="<?php echo e((\Session::get('locale') == $language->folder_name) ? 'background-color: #51af33' : ''); ?>"><?php echo e($language->folder_name); ?></a></li>
					          	<?php endforeach; ?>
					        </ul>
						     
						</li>

					<?php endif; ?>
				
				<?php endif; ?>
			
			</ul>
			
		</div>
	</div>
</nav>

