<!Doctype html>
<html class="no-js" lang="">
<head>
    <meta charset="utf-8">

    <title><?php echo $__env->yieldContent('title'); ?></title>
    
    <meta name="robots" content="noindex">

    <meta name="robots" content="noindex">
    
    <!-- Tell the browser to be responsive to screen width -->
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">

    <meta name="description" content="<?php echo e(Setting::get('meta_description')); ?>">

    <meta name="author" content="<?php echo e(Setting::get('meta_author')); ?>">

    <meta name="keywords" content="<?php echo e(Setting::get('meta_keywords')); ?>">

    <link rel="shortcut icon" href=" <?php if(Setting::get('site_icon')): ?> <?php echo e(Setting::get('site_icon')); ?> <?php else: ?> <?php echo e(asset('favicon.png')); ?> <?php endif; ?>">

    <link rel="apple-touch-icon" sizes="57x57" href="<?php echo e(asset('icons/apple-icon-57x57.png')); ?>">
    <link rel="apple-touch-icon" sizes="60x60" href="<?php echo e(asset('icons/apple-icon-60x60.png')); ?>">
    <link rel="apple-touch-icon" sizes="72x72" href="<?php echo e(asset('icons/apple-icon-72x72.png')); ?>">
    <link rel="apple-touch-icon" sizes="76x76" href="<?php echo e(asset('icons/apple-icon-76x76.png')); ?>">
    <link rel="apple-touch-icon" sizes="114x114" href="<?php echo e(asset('icons/apple-icon-114x114.png')); ?>">
    <link rel="apple-touch-icon" sizes="120x120" href="<?php echo e(asset('icons/apple-icon-120x120.png')); ?>">
    <link rel="apple-touch-icon" sizes="144x144" href="<?php echo e(asset('icons/apple-icon-144x144.png')); ?>">
    <link rel="apple-touch-icon" sizes="152x152" href="<?php echo e(asset('icons/apple-icon-152x152.png')); ?>">
    <link rel="apple-touch-icon" sizes="180x180" href="<?php echo e(asset('icons/apple-icon-180x180.png')); ?>">
    <link rel="icon" type="image/png" sizes="192x192"  href="<?php echo e(asset('icons/android-icon-192x192.png')); ?>">
    <link rel="icon" type="image/png" sizes="32x32" href="<?php echo e(asset('icons/favicon-32x32.png')); ?>">
    <link rel="icon" type="image/png" sizes="96x96" href="<?php echo e(asset('icons/favicon-96x96.png')); ?>">
    <link rel="icon" type="image/png" sizes="16x16" href="<?php echo e(asset('icons/favicon-16x16.png')); ?>">
    <link rel="manifest" href="<?php echo e(asset('icons/manifest.json')); ?>">
    <meta name="msapplication-TileColor" content="#ffffff">
    <meta name="msapplication-TileImage" content="<?php echo e(asset('icons/ms-icon-144x144.png')); ?>">
    <meta name="theme-color" content="#ffffff">


    <link rel="stylesheet" href="<?php echo e(asset('admin-css/bootstrap/css/bootstrap.min.css')); ?>">

    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.5.0/css/font-awesome.min.css">

    <!-- Ionicons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/ionicons/2.0.1/css/ionicons.min.css">

    <link rel="stylesheet" href="<?php echo e(asset('admin-css/plugins/jvectormap/jquery-jvectormap-1.2.2.css')); ?>">

    <!-- DataTables -->
    <link rel="stylesheet" href="<?php echo e(asset('admin-css/plugins/datatables/dataTables.bootstrap.css')); ?>">

    <?php echo $__env->yieldContent('mid-styles'); ?>

    <link rel="stylesheet" href="<?php echo e(asset('admin-css/plugins/select2/select2.min.css')); ?>">

      <!-- Theme style -->
    <link rel="stylesheet" href="<?php echo e(asset('admin-css/dist/css/AdminLTE.min.css')); ?>">

    <link rel="stylesheet" href="<?php echo e(asset('admin-css/dist/css/skins/_all-skins.min.css')); ?>">

    <link rel="stylesheet" href="<?php echo e(asset('admin-css/plugins/iCheck/all.css')); ?>">

    <link rel="stylesheet" href="<?php echo e(asset('admin-css/dist/css/custom.css')); ?>">

    <!--Datapicker -->

    <link rel="stylesheet" href="<?php echo e(asset('admin-css/plugins/datepicker/datepicker3.css')); ?>">

    <?php echo $__env->yieldContent('styles'); ?>

    <style>
        .star-rating-active s:hover:before, .star-rating s.rated:before {
            color: #bf0572;
        }
    </style>

</head>


<body class="hold-transition skin-green sidebar-mini">

    <div class="wrapper">

        <!-- @--include('layouts.admin.header') -->

        <!-- @--include('layouts.admin.nav') -->
     
        <?php if(Auth::guard('admin')->user()->role == ADMIN): ?>

            <?php echo $__env->make('layouts.admin.header', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

            <?php echo $__env->make('layouts.admin.nav', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

        <?php else: ?> 

            <?php echo $__env->make('layouts.admin.subadmin-header', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

            <?php echo $__env->make('layouts.admin.subadmin-nav', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

        <?php endif; ?>

        <div class="content-wrapper">

            <section class="content-header">
                <h1><?php echo $__env->yieldContent('content-header'); ?><small><?php echo $__env->yieldContent('content-sub-header'); ?></small></h1>
                <ol class="breadcrumb"><?php echo $__env->yieldContent('breadcrumb'); ?></ol>
            </section>

            <!-- Main content -->
            <section class="content">
                <?php echo $__env->yieldContent('content'); ?>
            </section>

        </div>

        <!-- include('layouts.admin.footer') -->

        <!-- include('layouts.admin.left-side-bar') -->

    </div>


    <!-- jQuery 2.2.0 -->
    <script src="<?php echo e(asset('admin-css/plugins/jQuery/jQuery-2.2.0.min.js')); ?>"></script>
    <!-- Bootstrap 3.3.6 -->
    <script src="<?php echo e(asset('admin-css/bootstrap/js/bootstrap.min.js')); ?>"></script>

    <script src="<?php echo e(asset('admin-css/plugins/datatables/jquery.dataTables.min.js')); ?>"></script>

    <script src="<?php echo e(asset('admin-css/plugins/datatables/dataTables.bootstrap.min.js')); ?>"></script>

    <!-- Select2 -->
    <script src="<?php echo e(asset('admin-css/plugins/select2/select2.full.min.js')); ?>"></script>
    <!-- InputMask -->
    <script src="<?php echo e(asset('admin-css/plugins/input-mask/jquery.inputmask.js')); ?>"></script>
    <script src="<?php echo e(asset('admin-css/plugins/input-mask/jquery.inputmask.date.extensions.js')); ?>"></script>

    <script src="<?php echo e(asset('admin-css/plugins/input-mask/jquery.inputmask.extensions.js')); ?>"></script>

    <!-- SlimScroll -->
    <script src="<?php echo e(asset('admin-css/plugins/slimScroll/jquery.slimscroll.min.js')); ?>"></script>
    <!-- FastClick -->
    <script src="<?php echo e(asset('admin-css/plugins/fastclick/fastclick.js')); ?>"></script>
    <!-- AdminLTE App -->
    <script src="<?php echo e(asset('admin-css/dist/js/app.min.js')); ?>"></script>

    <!-- jvectormap -->
    <script src="<?php echo e(asset('admin-css/plugins/jvectormap/jquery-jvectormap-1.2.2.min.js')); ?>"></script>

    <script src="<?php echo e(asset('admin-css/plugins/jvectormap/jquery-jvectormap-world-mill-en.js')); ?>"></script>

    <script src="<?php echo e(asset('admin-css/plugins/chartjs/Chart.min.js')); ?>"></script>
    <!-- Datapicker -->
    <script src = "<?php echo e(asset('admin-css/plugins/datepicker/bootstrap-datepicker.js')); ?>"></script> 

    <script src="<?php echo e(asset('admin-css/plugins/iCheck/icheck.min.js')); ?>"></script>

    <!-- AdminLTE dashboard demo (This is only for demo purposes) -->
    <!-- <script src="<?php echo e(asset('admin-css/dist/js/pages/dashboard2.js')); ?>"></script> -->

    <script src="<?php echo e(asset('admin-css/dist/js/demo.js')); ?>"></script>

    <!-- page script -->
    <script>
        $(function () {
            $("#example1").DataTable();
            
            $("#datatable-withoutpagination").DataTable({

                "paging":false,
                "lengthChange":false,
                "language":{

                    "info":""
                }
            });
            $('#example2').DataTable({
                "paging": true,
                "lengthChange": false,
                "searching": false,
                "ordering": true,
                "info": true,
                "autoWidth": false
            });
        });
    </script>
    <script type="text/javascript">
        
        $(document).ready(function() {
        $('#expiry_date').datepicker({
            autoclose:true,
            format : 'dd-mm-yyyy',
            startDate: 'today',
        });
    });
    </script>
    <?php echo $__env->yieldContent('scripts'); ?>

    <script type="text/javascript">
        $("#<?php echo e($page); ?>").addClass("active");
        <?php if(isset($sub_page)): ?> $("#<?php echo e($sub_page); ?>").addClass("active"); <?php endif; ?>
    </script>

    <!-- Once click the button automatically disabled -->
    <script>
        $('#disable_button').on('click', function(){
          
            // $('#disable_button').attr("disabled", true);
        });
    </script>

    <script type="text/javascript">
        
        $(function () {
            //Initialize Select2 Elements
            $(".select2").select2();
            $(".select-sub").select2();

            //Datemask dd/mm/yyyy
            $("#datemask").inputmask("dd:mm:yyyy", {"placeholder": "hh:mm:ss"});
            //Datemask2 mm/dd/yyyy
            // $("#datemask2").inputmask("hh:mm:ss", {"placeholder": "hh:mm:ss"});
            //Money Euro
            $("[data-mask]").inputmask();
        });

        //iCheck for checkbox and radio inputs
        $('input[type="checkbox"].minimal, input[type="radio"].minimal').iCheck({
            checkboxClass: 'icheckbox_minimal-blue',
            radioClass: 'iradio_minimal-blue'
        });
        
        //Red color scheme for iCheck
        $('input[type="checkbox"].minimal-red, input[type="radio"].minimal-red').iCheck({
            checkboxClass: 'icheckbox_minimal-red',
            radioClass: 'iradio_minimal-red'
        });

        //Flat red color scheme for iCheck
        $('input[type="checkbox"].flat-red, input[type="radio"].flat-red').iCheck({
            checkboxClass: 'icheckbox_flat-green',
            radioClass: 'iradio_flat-green'
        });
    </script>

    <script>

        // function isNumber(evt) {
        //       evt = (evt) ? evt : window.event;
        //       var charCode = (evt.which) ? evt.which : evt.keyCode;
        //       if (charCode > 31 && (charCode < 48 || charCode > 57 ) && charCode != 45) {
        //           return false;
        //       }
        //       return true;
        // }

        // function alphaOnly(event) {
        //   var key = event.keyCode;
        //   return ((key >= 65 && key <= 90) || key == 8 || key == 32);
        // };

        function loadFile(event) {

            var ext=$("#picture").val();

            var fileExtension = ['jpeg','jpg','png'];
          
            if($.inArray(ext.split('.').pop().toLowerCase(), fileExtension) == -1) {
                
                alert("Only formats allowed are : "+fileExtension.join(','));
               
                document.getElementById("picture").value = null;                    
                
                return false;
            }  
        }

    </script>

    <?php echo Setting::get('google_analytics'); ?>

</body>

</html>
