<?php $__env->startSection('title', tr('view_documents')); ?>

<?php $__env->startSection('content-header'); ?>

<?php echo e(tr('view_documents')); ?>


<?php if($provider_details): ?>

<a href="<?php echo e(route('admin.providers.view' , [ 'provider_id' => $provider_details->id])); ?>"> 
    - <?php echo e($provider_details ? $provider_details->name : ""); ?>

</a>

<?php endif; ?>

<?php if($document_details): ?>

<a href="<?php echo e(route('admin.documents.index')); ?>"> 
   - <?php echo e($document_details ? $document_details->name : ""); ?>

</a>

<?php endif; ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <li><a href="<?php echo e(route('admin.dashboard')); ?>"><i class="fa fa-dashboard"></i><?php echo e(tr('home')); ?></a></li>
    <li><a href="<?php echo e(route('admin.providers.index')); ?>"><i class="fa fa-users"></i> <?php echo e(tr('providers')); ?></a></li>
    <li class="active"><i class="fa fa-file-o"></i> <?php echo e(tr('view_documents')); ?></li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <?php echo $__env->make('notification.notify', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

    <div class="row">
        <div class="col-xs-12">

            <div class="box box-success">

                <div class="box-header with-border admin-panel-success">

                </div>

                <div class="box-body">

                    <?php if(count($provider_documents) > 0): ?>

                        <table id="datatable-withoutpagination" class="table table-bordered table-striped">

                            <thead>
                                <tr>
                                    <th><?php echo e(tr('id')); ?></th>
                                    <th><?php echo e(tr('provider')); ?></th>
                                    <th><?php echo e(tr('document_type')); ?></th>
                                    <th><?php echo e(tr('view')); ?></th>
                                </tr>
                            </thead>

                            <tbody>

                                <?php foreach($provider_documents as $index => $provider_document_details): ?>

                                    <tr>
                                        <td><?php echo e(showEntries($_GET,$index+1)); ?></td>

                                        <td><a href="<?php echo e(route('admin.providers.view' , ['provider_id' => $provider_document_details->provider_id])); ?>"> <?php echo e($provider_document_details->provider ? $provider_document_details->provider->name : ""); ?></a></td>

                                        <td><?php echo e($provider_document_details->document->name); ?></td>

                                        <td><a href="<?php echo e($provider_document_details->document_url); ?>" target="_blank"><span class="btn btn-info btn-large"><?php echo e(tr('view')); ?></span></a></td>

                                    </tr>

                                <?php endforeach; ?>

                            </tbody>

                        </table>

                        <div align="right"><?php echo e($provider_documents->links()); ?></div>

                    <?php else: ?>

                        <h3 class="no-result"><?php echo e(tr('no_result_found')); ?></h3>

                    <?php endif; ?>
               
                </div>

            </div>
            
        </div>

    </div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>