    <form class="form-horizontal" action="<?php echo e(route('admin.provider_subscriptions.save')); ?>" method="POST" enctype="multipart/form-data" role="form">

        <input type="hidden" name="provider_subscription_id" value="<?php echo e($provider_subscription_details->id); ?>">

        <div class="box-body">
            
            <div class="form-group">

                <div class="col-md-6">

                    <label for="title" class="">* <?php echo e(tr('title')); ?></label>

                    <input type="text" name="title" class="form-control" id="title" value="<?php echo e(old('title') ?: $provider_subscription_details->title); ?>" placeholder="<?php echo e(tr('title')); ?>" required >
                    
                </div>
                                
                <div class="form-group">

                    <div class="col-md-6">

                        <label><?php echo e(tr('select_category')); ?> * </label>
                        
                        <select name="category_id" required class="form-control select2" autofocus>

                            <option value=""><?php echo e(tr('select_category')); ?> </option>

                            <?php foreach($categories as $category): ?>

                                <?php if( $provider_subscription_details->category_id == $category->category_id): ?>
                                    <option value="<?php echo e($category->category_id); ?>" selected><?php echo e($category->category_name); ?></option>
                                <?php else: ?>
                                    <option value="<?php echo e($category->category_id); ?>"><?php echo e($category->category_name); ?></option>
                                <?php endif; ?>

                            <?php endforeach; ?>

                        </select>                           
                        
                    </div>

                </div>
            </div>

            <div class="form-group">
                
                <!-- <div class="form-group"> -->
                <div class="col-md-6">

                    <label for="plan">* <?php echo e(tr('plan')); ?></label>

                    <input type="number" min="1" max="12" required name="plan" class="form-control" id="plan" value="<?php echo e(old('plan') ?: $provider_subscription_details->plan); ?>" title="<?php echo e(tr('no_of_months')); ?>" placeholder="<?php echo e(tr('no_of_months')); ?>">
                </div>
                
                <div class="col-md-6">

                    <label for="amount" class="">* <?php echo e(tr('amount')); ?></label>

                    <input type="number" value="<?php echo e(old('amount') ?: $provider_subscription_details->amount); ?>" name="amount" class="form-control" id="amount" placeholder="<?php echo e(tr('amount')); ?>" step="any" required>
                </div>

                <!-- <div class="form-group"> -->
                <div class="col-md-6" style="display: none">

                    <label for="expiry_date"> * <?php echo e(tr('expiry_date')); ?></label>
                
                    <input type="text" id="expiry_date" name="expiry_date"  class="form-control" placeholder="<?php echo e(tr('expiry_date')); ?>" value="<?php echo e(old('expiry_date') ?: date('d-m-Y',strtotime($provider_subscription_details->expiry_date))); ?>" required readonly>
                
                </div>
            </div>

            
            <!-- 
            <div class="form-group">
                <label for="image" class="">
                    <?php echo e(tr('image')); ?> 
                    <br>
                </label>

                <input type="file" name="image" class="form-control" id="image" value="<?php echo e(old('image')); ?>" placeholder="<?php echo e(tr('image')); ?>" accept="image/png, image/jpeg" onchange="loadFile(this, 'image_preview')">

                <br>

                <img src="<?php echo e($provider_subscription_details->image); ?>" id="image_preview" style="width:100px;height:100px;">
            </div> -->

            <div class="form-group">
            
                <div class="col-md-12">

                    <label for="description" class=""><?php echo e(tr('description')); ?></label>

                    <textarea id="ckeditor" name="description" class="form-control" placeholder="<?php echo e(tr('description')); ?>."><?php echo e(old('description') ?: $provider_subscription_details->description); ?></textarea>

                </div>

            </div>

        </div>

        <div class="box-footer">
             <button type="reset" class="btn btn-danger"><?php echo e(tr('cancel')); ?></button>
        
            <button type="submit" class="btn btn-success pull-right" <?php if(Setting::get('admin_delete_control') == YES): ?> disabled <?php endif; ?>) ><?php echo e(tr('submit')); ?></button>  
        </div>
    </form>