<?php $__env->startSection('title', tr('provider_subscriptions')); ?>

<?php $__env->startSection('content-header'); ?>

<?php echo e(tr('provider_subscriptions')); ?>


    <?php if($category_details): ?> -

    <a href="<?php echo e(route('admin.categories.index')); ?>">
        <?php echo e($category_details->name); ?>

    </a>

    <?php endif; ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb'); ?>
     
    <li class="active"><i class="fa fa-key"></i><?php echo e(tr('provider_subscriptions')); ?></li>
    
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

	<?php echo $__env->make('notification.notify', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

	<div class="row">

        <div class="col-xs-12">

            <div class="box box-success solid">

                <div class="box-header with-border admin-panel-success">
                    
                    <h3 class="box-title"><?php echo e(tr('provider_subscriptions')); ?></h3>

                    <a href="<?php echo e(route('admin.provider_subscriptions.create')); ?>" class="btn bg-navy pull-right"><?php echo e(tr('add_provider_subscription')); ?></a>

                </div>
 
            	<div class="box-body">

					<?php if(count($provider_subscriptions) > 0): ?>

		              	<table id="example1" class="table table-bordered table-striped">

							<thead>
							    <tr>
    							    <th><?php echo e(tr('id')); ?></th>
    							    <th><?php echo e(tr('title')); ?></th>
    							    <th><?php echo e(tr('amount')); ?></th>
    							    <th><?php echo e(tr('plan')); ?></th>
                                    <th><?php echo e(tr('status')); ?></th>
                                    <!-- <th><?php echo e(tr('is_popular')); ?></th> -->
    							    <th><?php echo e(tr('action')); ?></th>
							    </tr>
							</thead>

							<tbody>

								<?php foreach($provider_subscriptions as $i =>  $provider_subscription_details): ?>

								    <tr>
								      	<td><?php echo e($i+1); ?></td>

								      	<td>                                            
                                            <a href="<?php echo e(route('admin.provider_subscriptions.view', ['provider_subscription_id' => $provider_subscription_details->id])); ?>" class=""> <?php echo e($provider_subscription_details->title); ?> </a> 
                                        </td>

								      	<td>
								      		<?php echo e(Setting::get('currency')); ?> <?php echo e($provider_subscription_details->amount); ?>

								      	</td>

                                        <td>
                                            <?php echo e($provider_subscription_details->plan); ?> <?php echo e($provider_subscription_details->plan_type); ?>

                                        </td>

                                        <td>
                                            <?php if($provider_subscription_details->status == APPROVED): ?>

                                                <span class="label label-success"><?php echo e(tr('approved')); ?></span> 
                                            
                                            <?php else: ?>
                                                
                                                <span class="label label-warning"><?php echo e(tr('pending')); ?></span> 

                                            <?php endif; ?>

                                        </td> 

                                        <!-- <td>
                                            <?php if($provider_subscription_details->is_popular == YES ): ?>

                                                <span class="label label-success"><?php echo e(tr('yes')); ?></span> 
                                                
                                            <?php else: ?>
                                                <span class="label label-warning"><?php echo e(tr('no')); ?></span> 

                                            <?php endif; ?>

                                        </td> -->


									    <td>
 											
 											<div class="dropdown"  id="showBtnGroup">

                                            	<button class="btn btn-default dropdown-toggle" type="button" id="dropdownMenu" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                <?php echo e(tr('action')); ?>

                                                <span class="caret"></span>
                                            	</button>

                                            	<ul class="dropdown-menu" aria-labelledby="dropdownMenu">

                                            	<li>
                                                    <a href="<?php echo e(route('admin.provider_subscriptions.view' , ['provider_subscription_id' => $provider_subscription_details->id] )); ?>">
                                                        <b><?php echo e(tr('view')); ?></b>
                                                    </a>
                                                </li>    

                                                <?php if(Setting::get('admin_delete_control') == YES): ?>

                                                    <li>
                                                    	<a href="javascript:;" class="btn disabled text-green" style="text-align: left">
                                                    		<b><?php echo e(tr('edit')); ?></b>
                                                    	</a>
                                                    </li>
                                                    <li>
                                                    	<a href="javascript:;" class="btn disabled text-red">
                                                        	<b><?php echo e(tr('delete')); ?></b>
                                                    	</a>
                                                    </li>

                                                <?php else: ?>

                                                    <li>
                                                    	<a href="<?php echo e(route('admin.provider_subscriptions.edit' , ['provider_subscription_id' => $provider_subscription_details->id] )); ?>">
                                                    		<b><?php echo e(tr('edit')); ?></b>
                                                    	</a> 
                                                    </li>
                                                    <li>
                                                    	<a onclick="return confirm(&quot;<?php echo e(tr('admin_provider_subscription_delete_confirmation', $provider_subscription_details->title)); ?> ?&quot;)" href="<?php echo e(route('admin.provider_subscriptions.delete', ['provider_subscription_id' => $provider_subscription_details->id] )); ?>">
                                                        	<b><?php echo e(tr('delete')); ?></b>
                                                   		</a>
                                                    </li>

                                                <?php endif; ?>

									    		<?php if($provider_subscription_details->status == APPROVED): ?>

                                                    <li>
                                                        <a href="<?php echo e(route('admin.provider_subscriptions.status.change' ,[ 'provider_subscription_id' => $provider_subscription_details->id] )); ?>" onclick="return confirm(&quot;<?php echo e($provider_subscription_details->title); ?> <?php echo e(tr('admin_provider_subscription_decline_confirmation')); ?> &quot;);">
                                                            <b><?php echo e(tr('decline')); ?></b>
                                                        </a>
                                                    </li>

                                                <?php else: ?>

                                                	<li>
                                                		<a href="<?php echo e(route('admin.provider_subscriptions.status.change' , [ 'provider_subscription_id' => $provider_subscription_details->id] )); ?>">
                                                			<b><?php echo e(tr('approve')); ?></b>
                                                		</a>
                                                	</li>

                                                <?php endif; ?>

                                                <li>
                                                    <a href="<?php echo e(route('admin.provider_subscriptions.payments', [ 'provider_subscription_id' => $provider_subscription_details->id])); ?>"> 
                                                        <b><?php echo e(tr('payments')); ?></b>
                                                    </a>

                                                </li>


                                                <!-- ! ! ! !FOR LATER PURPOSE. Don't REMOVE % % % % -->

                                                <!-- <?php if($provider_subscription_details->is_popular == YES): ?>

                                                     <li>
                                                        <a href="<?php echo e(route('admin.provider_subscriptions.is_popular' , [ 'provider_subscription_id' => $provider_subscription_details->id] )); ?>">
                                                            <b><?php echo e(tr('remove_populor')); ?></b>
                                                        </a>
                                                    </li>

                                                <?php else: ?>

                                                    <li>
                                                        <a href="<?php echo e(route('admin.provider_subscriptions.is_popular' , [ 'provider_subscription_id' => $provider_subscription_details->id] )); ?>">
                                                            <b><?php echo e(tr('add_populor')); ?></b>
                                                        </a>
                                                    </li>

                                                <?php endif; ?> -->

									    		
									    		</ul>
									    	</div>

									    </td>

								    </tr>

								<?php endforeach; ?>
							</tbody>

						</table>

					<?php else: ?>

						<h3 class="no-result"><?php echo e(tr('no_provider_subscription_found')); ?></h3>

					<?php endif; ?>
			
            	</div>

          </div>

        </div>

    </div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>