<?php $__env->startSection('title', tr('languages')); ?>

<?php $__env->startSection('content-header', tr('languages')); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <li><a href="<?php echo e(route('admin.dashboard')); ?>"><i class="fa fa-dashboard"></i><?php echo e(tr('home')); ?></a></li>
    <li class="active"><i class="fa fa-globe"></i> <?php echo e(tr('languages')); ?></li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    
    <div class="row">
        
        <div class="col-xs-12">
    
            <ul>
                <li style="list-style-type: none;">Note: English and default language - The following options are disabled</li>
                <li>Delete option</li>
                <li>Decline option</li>
            </ul>
            
            <?php echo $__env->make('notification.notify', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

            <div class="box box-success">

                <div class="box-header with-border admin-panel-success">
                
                    <b><?php echo e(tr('languages')); ?></b>
                    
                    <a href="<?php echo e(route('admin.languages.create')); ?>" style="float:right" class="btn btn-warning">
                        <b><i class="fa fa-plus"></i> <?php echo e(tr('create_language')); ?></b>
                    </a>

                    
                </div>

                <div class="box-body">
                    
                    <?php if(count($languages) != 0): ?>
                    
                    <table id="example1" class="table table-bordered table-striped">

                        <thead>
                            <tr>
                                <th><?php echo e(tr('id')); ?></th>
                                <th><?php echo e(tr('language')); ?></th>
                                <th><?php echo e(tr('short_name')); ?></th>
                                <th><?php echo e(tr('auth_file')); ?></th>
                                <th><?php echo e(tr('messages_file')); ?></th>
                                <th><?php echo e(tr('pagination_file')); ?></th>
                                <th><?php echo e(tr('passwords_file')); ?></th>
                                <th><?php echo e(tr('validation_file')); ?></th>
                                <th><?php echo e(tr('status')); ?></th>
                                <th><?php echo e(tr('action')); ?></th>
                            </tr>
                        
                        </thead>

                        <tbody>
                                                        
                            <?php foreach($languages as $i => $language_details): ?>
                           
                            <tr>
                                <td><?php echo e($i+1); ?></td>

                                <td>
                                    <?php echo e($language_details->language); ?>


                                    <?php if(Setting::get('default_lang') == $language_details->folder_name): ?>

                                        <span class="text-green pull-right"><i class="fa fa-check-circle"></i></span>

                                    <?php endif; ?>

                                </td>

                                <td><?php echo e($language_details->folder_name); ?></td>

                                <td>
                                    <a href="<?php echo e(route('admin.languages.download', ['folder_name' => $language_details->folder_name, 'file_name'=>'auth'] )); ?>" target="_blank">
                                        <?php echo e(tr('download_here')); ?>

                                    </a>

                                </td>                
                                <td>
                                    <a href="<?php echo e(route('admin.languages.download', ['folder_name' => $language_details->folder_name, 'file_name'=>'messages'] )); ?>" target="_blank">
                                        <?php echo e(tr('download_here')); ?>

                                    </a>

                                </td>
                                
                                <td>
                                    <a href="<?php echo e(route('admin.languages.download', ['folder_name'=>$language_details->folder_name, 'file_name'=>'pagination'] )); ?>" target="_blank">
                                        <?php echo e(tr('download_here')); ?>

                                    </a>
                                </td>
                                
                                <td>
                                    <a href="<?php echo e(route('admin.languages.download', ['folder_name'=>$language_details->folder_name, 'file_name'=>'passwords'] )); ?>" target="_blank">
                                        <?php echo e(tr('download_here')); ?>

                                    </a>

                                </td>
                                
                                <td>
                                    <a href="<?php echo e(route('admin.languages.download', ['folder_name'=>$language_details->folder_name, 'file_name'=>'validation'] )); ?>" target="_blank">
                                        <?php echo e(tr('download_here')); ?>

                                    </a>

                                </td>
                                <td>
                                    <?php if($language_details->status == APPROVED): ?>
                                        <span class="label label-success"><?php echo e(tr('active')); ?></span>
                                    <?php else: ?>
                                        <span class="label label-warning"><?php echo e(tr('inactive')); ?></span>
                                    <?php endif; ?>
                                </td>

                                <td>

                                   <div class="dropdown">
                                    
                                        <button class="btn btn-default dropdown-toggle" type="button" id="dropdownMenu" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                            <?php echo e(tr('action')); ?>

                                            <span class="caret"></span>
                                        </button>

                                        <ul class="dropdown-menu" aria-labelledby="dropdownMenu">
                                                <!-- For default language - Only edit option -->
                                                <?php if(Setting::get('default_lang') == $language_details->folder_name): ?>
                                                    <?php if(Setting::get('admin_delete_control') == YES): ?>

                                                        <li>
                                                            <a href="javascript:;" class="btn disabled" style="text-align: left"><b><i class="fa fa-edit"></i>&nbsp;<?php echo e(tr('edit')); ?></b></a>
                                                        </li> 
                                                    <?php else: ?>

                                                        <li>
                                                            <a href="<?php echo e(route('admin.languages.edit', ['language_id' => $language_details->id ] )); ?>"><b><i class="fa fa-edit"></i>&nbsp;<?php echo e(tr('edit')); ?></b></a>
                                                        </li>

                                                    <?php endif; ?>

                                                <?php else: ?>

                                                    <?php if(Setting::get('admin_delete_control') == YES): ?>

                                                        <li>
                                                            <a href="javascript:;" class="btn disabled" style="text-align: left"><b><i class="fa fa-edit"></i>&nbsp;<?php echo e(tr('edit')); ?></b></a>
                                                        </li>

                                                        <li>
                                                            <a href="javascript:;" class="btn disabled" style="text-align: left"><b><i class="fa fa-trash"></i>&nbsp;<?php echo e(tr('delete')); ?></b></a>
                                                        </li>

                                                    <?php else: ?>

                                                        <li>
                                                            <a href="<?php echo e(route('admin.languages.edit', ['language_id' => $language_details->id ] )); ?>"><b><i class="fa fa-edit"></i>&nbsp;<?php echo e(tr('edit')); ?></b></a>
                                                        </li>

                                                        <?php if($language_details->folder_name != "en"): ?>

                                                        <li>
                                                            <a onclick="return confirm(&quot;<?php echo e(tr('admin_language_delete_confirmation' , $language_details->language)); ?>&quot;);" href="<?php echo e(route('admin.languages.delete', ['language_id' => $language_details->id ] )); ?>"><b><i class="fa fa-trash"></i>&nbsp;<?php echo e(tr('delete')); ?></b></a>
                                                        </li>
                                                <?php endif; ?>    

                                                        <li>
                                                            <a href="<?php echo e(route('admin.languages.set_default', ['language_file' => $language_details->folder_name] )); ?>"><b>
                                                                <i class="fa fa-globe"></i>&nbsp;<?php echo e(tr('set_default_language')); ?>

                                                                </b>
                                                            </a>
                                                        </li>

                                                        <li>
                                                            <a href="<?php echo e(route('admin.languages.status', ['language_id' => $language_details->id ] )); ?>">

                                                                <?php if($language_details->status == APPROVED ): ?>
                                                                    <b><i class="fa fa-close"></i>&nbsp;<?php echo e(tr('decline')); ?></b>
                                                                <?php else: ?>
                                                                    <b><i class="fa fa-check"></i>&nbsp;<?php echo e(tr('approve')); ?></b>
                                                                <?php endif; ?>
                                                            </a>
                                                        </li>

                                                    <?php endif; ?>

                                                <?php endif; ?>

                                            </ul>
                                    </div>

                                </td>

                            </tr>
                        
                            <?php endforeach; ?>
                        </tbody>

                    </table>

                    <?php else: ?>

                        <h3 class="no-result"><?php echo e(tr('no_language_found')); ?></h3>
                    <?php endif; ?>
                
                </div>

            </div>
        
        </div>
    
    </div>

<?php $__env->stopSection(); ?>

<?php if(Session::has('flash_language')): ?>

<?php $__env->startSection('scripts'); ?>

<script type="text/javascript" src="<?php echo e(asset('common/js/bootbox.min.js')); ?>"></script>
<script type="text/javascript">

bootbox.confirm("Do you want to reload the page to view default language ?", function(result){ 
    if (result == true) {
        window.location.reload(true);
    }
    console.log('This was logged in the callback: ' + result); 
});

</script>
<?php $__env->stopSection(); ?>

<?php endif; ?>
<?php echo $__env->make('layouts.admin', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>