<?php if(isset($name)): ?>

  <?php $__env->startSection('title', tr('user_review')); ?>

<?php else: ?>

  <?php $__env->startSection('title', tr('provider_review')); ?>

<?php endif; ?>

<?php if(isset($name)): ?>

  <?php $__env->startSection('content-header', tr('user_review')); ?>

<?php else: ?>

  <?php $__env->startSection('content-header', tr('provider_review')); ?>

<?php endif; ?>


<?php $__env->startSection('breadcrumb'); ?>
    <li><a href="<?php echo e(route('admin.dashboard')); ?>"><i class="fa fa-dashboard"></i><?php echo e(tr('home')); ?></a></li>
    <?php if(isset($name)): ?>
      <li class="active"><i class="fa fa-thumbs-up"></i> <?php echo e(tr('user_review')); ?></li>
    <?php else: ?>
      <li class="active"><i class="fa fa-thumbs-up"></i> <?php echo e(tr('provider_review')); ?></li>
    <?php endif; ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('styles'); ?>

<link rel="stylesheet" href="<?php echo e(asset('admin-css/dist/css/star-rating.css')); ?>">

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <?php echo $__env->make('notification.notify', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

    <div class="row">

        <div class="col-xs-12">

            <div class="box box-success">

                <div class="box-header with-border admin-panel-success">

                    <?php if(isset($name)): ?> <b><?php echo e(tr('user_review')); ?></b> <?php else: ?> <b><?php echo e(tr('provider_review')); ?></b> <?php endif; ?>

                </div>

                <div class="box-body">

                    <?php if(count($reviews) > 0): ?>

                        <table id="datatable-withoutpagination" class="table table-bordered table-striped">

                            <thead>
                              <tr>
                                <th><?php echo e(tr('id')); ?></th>
                                <?php if(isset($name)): ?>
                                <th><?php echo e(tr('title')); ?></th>
                                <th class="min"><?php echo e(tr('provider')); ?></th>
                                <th class="min"><?php echo e(tr('user')); ?></th>
                                <?php else: ?>
                                <th><?php echo e(tr('title')); ?></th>
                                <th><?php echo e(tr('user')); ?></th>
                                <th><?php echo e(tr('provider')); ?></th>
                                <?php endif; ?>
                               
                                <th><?php echo e(tr('rating')); ?></th>
                                <th class="min"><?php echo e(tr('date')); ?></th>
                                <th class="min"><?php echo e(tr('comment')); ?></th>
                                <th><?php echo e(tr('action')); ?></th>
                                </tr>
                            
                            </thead>

                            <tbody>
                               
                                <?php foreach($reviews as $index => $review): ?>
                                
                                    <tr>
                                        <td><?php echo e(showEntries($_GET,$index+1)); ?></td>

                                        <?php if(isset($name)): ?>
                                           
                                            <td>
                                                <?php if($review->requests): ?>

                                                    <a href="<?php echo e(route('admin.requests.view', ['request_unique_id' => $review->requests->unique_id ,'job_type' => $review->requests->job_type])); ?>"> <?php echo e($review->requests->name); ?>

                                                <?php else: ?>
                                                    <center> - </center>
                                                <?php endif; ?>
                                            </td>

                                            <td>
                                                <?php if($review->provider_name): ?>

                                                    <a href="<?php echo e(route('admin.providers.view' , ['provider_id' => $review->provider_id])); ?>">
                                                        <?php echo e($review->provider_name); ?>

                                                    </a>
                                                <?php else: ?>
                                                     <center> - </center>
                                                <?php endif; ?>
                                            </td>

                                            <td> 
                                                    <a href="<?php echo e(route('admin.users.view' , 
                                                    ['user_id' => $review->user_id ] )); ?>">
                                                        <?php echo e($review->user_name); ?>

                                                    </a>
                                            </td>

                                        <?php else: ?>

                                            <td>

                                                <?php if($review->requests): ?>

                                                    <a href="<?php echo e(route('admin.requests.view', ['request_unique_id' => $review->requests->unique_id ,'job_type' => $review->requests->job_type])); ?>"><?php echo e($review->requests->name); ?>

                                                <?php else: ?>
                                                   -
                                                    
                                                <?php endif; ?>
                                            </td>

                                            <td>
                                                
                                                <a href="<?php echo e(route('admin.users.view' , [ 'user_id' => $review->user_id ] )); ?>">
                                                    <?php echo e($review->user_name); ?>


                                                </a>
                                            </td>

                                            <td>
                                                <a href="<?php echo e(route('admin.providers.view' , ['provider_id' => $review->provider_id])); ?>">
                                                    <?php echo e($review->provider_name); ?>

                                                </a>
                                            </td>

                                        <?php endif; ?>

                                        <!-- <td><?php echo e($review->rating); ?></td> -->

                                        <td>
                                            <span style="display: none;"><?php echo e($review->rating); ?></span>
                                            <input id="view_rating" name="rating" type="number" class="rating view_rating" min="1" max="5" step="1" value="<?php echo e($review->rating); ?>">
                                        </td>

                                        <td><?php echo e($review->created_at); ?></td>

                                        <td><?php echo e($review->comment); ?></td>

                                        <td>

                                            <div class="input-group-btn">

                                                <?php if(isset($name)): ?>

                                                    <a class="btn btn-danger" onclick="return confirm('<?php echo e(tr('user_review_delete_confirmation')); ?>')" href="<?php echo e(route('admin.user_reviews.delete', ['user_rating_id' => $review->review_id] )); ?>">
                                                        <?php echo e(tr('delete')); ?> 
                                                    </a>

                                                <?php else: ?>

                                                    <a class="btn btn-danger" onclick="return confirm('<?php echo e(tr('provider_review_delete_confirmation')); ?>')" href="<?php echo e(route('admin.provider_reviews.delete', [ 'provider_rating_id' => $review->review_id] )); ?>">
                                                        <?php echo e(tr('delete')); ?>

                                                    </a> 

                                                <?php endif; ?>

                                            </div>

                                        </td>

                                    </tr>
                                
                                <?php endforeach; ?>

                            </tbody>
                        
                        </table>

                        <div align="right"><?php echo e($reviews->links()); ?></div>

                    <?php else: ?>

                        <h3 class="no-result"><?php echo e(tr('no_result_found')); ?></h3>

                    <?php endif; ?>
                
                </div>

            </div>
        
        </div>
    
    </div>

<?php $__env->stopSection(); ?>


<?php $__env->startSection('scripts'); ?>

    <script type="text/javascript" src="<?php echo e(asset('admin-css/dist/js/star-rating.js')); ?>"></script>

    <script type="text/javascript">
        $('.view_rating').rating({disabled: true, showClear: false});
    </script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>