<!DOCTYPE html>

<html lang="en">

    <head>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1">

        <title><?php echo e(Setting::get('site_name')); ?></title>

        <meta name="robots" content="noindex">

        <meta name="description" content="<?php echo e(Setting::get('meta_description')); ?>">

        <meta name="author" content="<?php echo e(Setting::get('meta_author')); ?>">

        <meta name="keywords" content="<?php echo e(Setting::get('meta_keywords')); ?>">

        <link rel="shortcut icon" href="<?php echo e(Setting::get('site_icon') ?: asset('favicon.png')); ?>">

        <link href="<?php echo e(asset('common/css/bootstrap.min.css')); ?>" rel="stylesheet">
        <link href="<?php echo e(asset('common/font-awesome/css/font-awesome.min.css')); ?>" rel="stylesheet">
        <link href="<?php echo e(asset('common/ionicons/css/ionicons.min.css')); ?>" rel="stylesheet">
        <link href="<?php echo e(asset('common/css/slick-theme.css')); ?>" rel="stylesheet">
        <link href="<?php echo e(asset('common/css/slick.css')); ?>" rel="stylesheet">
        <link href="<?php echo e(asset('common/css/style.css')); ?>" rel="stylesheet">
        <link href="<?php echo e(asset('common/css/responsive.css')); ?>" rel="stylesheet">

    </head>

    <body>

        <div class="main-content">

            <?php echo $__env->make('layouts.common.header', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

            <?php echo $__env->yieldContent('content'); ?>

            <?php echo $__env->make('layouts.common.footer', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

        </div>

        <script src="<?php echo e(asset('common/js/jquery.min.js')); ?>"></script>
        <script src="<?php echo e(asset('common/js/bootstrap.min.js')); ?>"></script>
        <script src="<?php echo e(asset('common/js/slick.min.js')); ?>"></script>
        <script src="<?php echo e(asset('common/js/scripts.js')); ?>"></script>
    </body>

</html>