<?php $__env->startSection('after-styles'); ?>
<link rel="stylesheet" type="text/css" href="<?php echo e(asset('common/css/grid-gallery.css')); ?>">

<style>

	.switch {
		position: relative;
		display: inline-block;
		width: 60px;
		height: 34px;
	}

	.switch input {display:none;}

	.slider {
		position: absolute;
		cursor: pointer;
		top: 0;
		left: 0;
		right: 0;
		bottom: 0;
		background-color: #ccc;
		-webkit-transition: .4s;
		transition: .4s;
	}

	.slider:before {
		position: absolute;
		content: "";
		height: 26px;
		width: 26px;
		left: 4px;
		bottom: 4px;
		background-color: white;
		-webkit-transition: .4s;
		transition: .4s;
	}

	input:checked + .slider {
		background-color: #51af33;
	}

	input:focus + .slider {
		box-shadow: 0 0 1px #2196F3;
	}

	input:checked + .slider:before {
		-webkit-transform: translateX(26px);
		-ms-transform: translateX(26px);
		transform: translateX(26px);
	}

	/* Rounded sliders */
	.slider.round {
		border-radius: 34px;
	}

	.slider.round:before {
		border-radius: 50%;
	}

	.block{
        text-align: center;
        vertical-align: middle;
    }
    .circle{
        background: #51af33;
        border-radius: 50%;
        color: white;
        height: 150px;
        font-weight: bold;
        width: 150px;
    }
	.circle span{
		display: table-cell;
		padding-top:40%;
		font-size: 20px;
	}

	.card-button {
		margin-left: 4%;
		margin-top: 3%;

	}
	.redeem-image{
		background-position: center;
		background-size: cover;
		background-repeat: no-repeat;
		height: 200px;
		width: 200px;
		margin: 0 auto;
		display: flex;
		align-items: center;
		justify-content: center;
	}

</style>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<div class="content-wrap gray-bg">

	<div class="dashboard row m-0 p-30">
		
		<div class="container">

		    <?php if(Auth::guard('provider')->user()->is_approved == PROVIDER_STATUS_PENDING): ?>
		    
		        <div class="alert alert-danger text-uppercase">
		            <?php echo e(tr('provider_waiting_for_admin_approval')); ?>

		        </div>

		    <?php endif; ?>			    

			<?php echo $__env->make('notification.notify', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

			<?php if( Auth::guard('provider')->user()->step == PROVIDER_STEP_COMPLETE): ?>

			    <h3 class="dashboard-main-tit"><?php echo e(tr('your_account')); ?></h3>
			
			<?php endif; ?>
			<!-- Dashboard Left -->
			<div class="dashboard-left-col col-lg-3 col-md-3 col-sm-12 col-xs-12">
			
				<div class="dashboard-left">
					<!-- Nav tabs -->
					
					<?php echo $__env->make('provider.account.profile-nav', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

				</div>

			</div>
			<!-- end of dashboard left -->

			<!-- Dashboard Right -->

			<div class="dashboard-right-col col-lg-9 col-md-9 col-sm-12 col-xs-12">
				
				<div class="dashboard-right tab-content white-bg p-f-30">
					
					<!-- Gallery Tab -->
					<div>

						<div class="row m-0 border-bot">
							
							<h3 class="dashboard-sub-tit pull-left"><?php echo e(tr('gallery')); ?></h3>

							<a href="#" class="edit-link block pull-right green-border-link" data-toggle="modal" data-target="#uploadGalleryImage"><?php echo e(tr('upload')); ?></a>

						</div>

						<div class="billing-sec dashboard-tab-sec row m-0">
						
							<div class="gal-description">
								
							</div>
						
							<div class="gg-box">

								<div id="gg-screen"></div>

								<?php if(count($galleries) > 0): ?>

									<?php foreach($galleries as $gallery_details): ?>

										<div class="gg-element">

											<img src="<?php echo e($gallery_details->picture); ?>">

											<div class="gallery-delete">

												<a href="<?php echo e(route('provider.gallery.delete' , ['provider_gallery_id' => $gallery_details->id])); ?>" onclick="return confirm('Are you Sure?');">
													<span class="fa-stack fa-lg">
													  	<i class="fa fa-circle fa-stack-2x"></i>
													  	<i class="fa fa-trash fa-stack-1x fa-inverse"></i>
													</span>
												</a>
											</div>
										</div>
								
									<?php endforeach; ?>

								<?php else: ?>

									<p><?php echo e(tr('gallery_empty')); ?></p>

								<?php endif; ?>

						    </div>
						
						</div>

						<!-- Modal -->
						<div class="modal fade" id="uploadGalleryImage" role="dialog">
						    
						    <div class="modal-dialog">
						    
						      	<div class="modal-content">
						        	
						        	<div class="modal-header">

						          		<button type="button" class="close" data-dismiss="modal">&times;</button>

						          		<h4 class="modal-title"><?php echo e(tr('gallery_note')); ?></h4>
						        	</div>

						        	<div class="modal-body">
						          		<form class="" method="POST" action="<?php echo e(route('provider.gallery.save')); ?>" enctype="multipart/form-data">
						          			<div class="mb-20">
												<label class="size-16"><?php echo e(tr('choose_pitcure')); ?></label>
												<span class="text-rights" style="color: #999;
float: right;"><?php echo e(tr('pitcure_note')); ?></span>
												<input id="uploadFile1" placeholder="Choose File" disabled="disabled" class="form-control upload-file" />

												<div class="fileUpload upload-btn btn btn-success btn-lg relative">

												    <span><?php echo e(tr('upload')); ?></span>

												    <input id="uploadBtn1" name="picture" type="file" accept="image/*" class="upload" />

												</div>

												<div class="clearfix"></div>
											</div>

						          			<div class="form-group mb-20">
											</div>

											<div class="text-right">

												<button  type="submit" class="btn btn-success"><?php echo e(tr('submit')); ?></button>

												<button type="button" class="btn btn-default pull-left" data-dismiss="modal"><?php echo e(tr('close')); ?></button>
											</div>
						          		</form>
						        	</div>

						      	</div>

						    </div>

						</div>
						<!-- modal -->
					</div>
				</div>
				
			</div>
			<!-- End of dashboard right -->
		
		</div>
	
	</div>

</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('after-scripts'); ?>

<script type="text/javascript">

	document.getElementById("uploadBtn").onchange = function () {
	    document.getElementById("uploadFile").value = this.value;
	};
	
	document.getElementById("uploadBtn1").onchange = function () {
	    document.getElementById("uploadFile1").value = this.value;
	};
</script>

<script type="text/javascript" src="<?php echo e(asset('common/js/grid-gallery.min.js')); ?>"></script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.provider', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>