<?php $__env->startSection('content'); ?>

<div class="content-wrap gray-bg">

    <div class="dashboard row m-0 p-30">
        
        <div class="container">

            <?php if(Auth::guard('provider')->user()->is_approved == PROVIDER_STATUS_PENDING): ?>
            
                <div class="alert alert-danger text-uppercase">
                    <?php echo e(tr('provider_waiting_for_admin_approval')); ?>

                </div>

            <?php endif; ?>
                
            <?php echo $__env->make('notification.notify', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

            <div class="dashboard-right-col col-lg-10 col-md-10 col-sm-12 col-xs-12 col-lg-offset-1 col-md-offset-1">   

                <div class="main">

                    <div class="col-md-12">
             
                        <h2 class="m-0 top"><?php echo e(tr('subscriptions')); ?>

                        <?php if($category_details): ?>   
                            -                     
                            <?php echo e($category_details->name); ?>

                        <?php endif; ?>
                        </h2>

                        <p class="top text-grey"><?php echo e(tr('provider_subscriptions_content')); ?></p>

                    </div>
                                
                    <div class="clearfix"></div>
                    
                    <?php if(count($provider_subscriptions) > 0): ?>
                    
                        <div class="spacing">

                            <?php foreach($provider_subscriptions as $s => $provider_subscription_details): ?>

                                <div class="columns col-lg-4">
                                    <ul class="price">
                                        <li class="header"><?php echo e($provider_subscription_details->title); ?></li>
                                        
                                        <li class="grey">
                                            <?php echo e(Setting::get('currency')); ?> <?php echo e($provider_subscription_details->amount); ?>

                                            / <?php echo e($provider_subscription_details->plan); ?> <?php echo e($provider_subscription_details->plan_type); ?>

                                        </li>
                                                                            
                                        <li style="max-height: 80px;min-height: 80px">
                                            <?php echo e(substr($provider_subscription_details->description, 0 , 90)); ?>

                                        </li>
                                        
                                        <li class="grey">

                                            <a href="<?php echo e(route('provider.subscriptions.invoice',[ 'provider_subscription_id' => $provider_subscription_details->provider_subscription_id ])); ?>" class="button"><?php echo e(tr('pay_now')); ?></a>

                                        </li>

                                    </ul>
                                
                                </div> 

                            <?php endforeach; ?>

                        </div>
                    
                    <?php endif; ?>
                
                    <div class="clearfix"></div>

                </div>

            </div>

        </div>
    
    </div>

</div>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.provider', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>