<?php $__env->startSection('title', tr('users')); ?>

<?php $__env->startSection('content-header', tr('users')); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <li><a href="<?php echo e(route('admin.dashboard')); ?>"><i class="fa fa-dashboard"></i><?php echo e(tr('home')); ?></a></li>
    <li class="active"><i class="fa fa-user"></i> <?php echo e(tr('users')); ?></li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

	<?php echo $__env->make('notification.notify', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

	<div class="row">
		
        <div class="col-xs-12">

	        <div class="box box-success">

            	<div class="box-header with-border admin-panel-success">
                
	                <b><?php echo e(tr('users')); ?></b>

	                
	                <a href="<?php echo e(route('admin.users.create')); ?>" style="float:right" class="btn btn-warning">
	                	<b><i class="fa fa-plus"></i> <?php echo e(tr('add_user')); ?></b>
	                </a>

	                <!-- EXPORT OPTION START -->

					<?php if(count($users) > 0 ): ?>
	                
		                <ul class="admin-action btn btn-danger pull-right" style="margin-right: 20px">
		                 	
							<li class="dropdown">
				                <a class="dropdown-toggle text-white" data-toggle="dropdown" href="#">
				                  	<b>
				                  		<?php echo e(tr('export')); ?>

				                  		<span class="caret"></span>
				                  	</b>
				                </a>
				                <ul class="dropdown-menu">
				                  	<li role="presentation">
				                  		<a role="menuitem" tabindex="-1" href="<?php echo e(route('admin.users.export' , ['format' => 'xlsx'])); ?>">
				                  			<span class="text-red"><b><?php echo e(tr('excel_sheet')); ?></b></span>
				                  		</a>
				                  	</li>

				                  	<li role="presentation">
				                  		<a role="menuitem" tabindex="-1" href="<?php echo e(route('admin.users.export' , ['format' => 'csv'])); ?>">
				                  			<span class="text-blue"><b><?php echo e(tr('csv')); ?></b></span>
				                  		</a>
				                  	</li>
				                </ul>
							</li>
						</ul>

					<?php endif; ?>

		            <!-- EXPORT OPTION END -->
	           
            	</div>
            
	            <div class="box-body">

	              	<table id="datatable-withoutpagination" class="table table-bordered table-striped">

						<thead>

						    <tr>
						      	<th><?php echo e(tr('id')); ?></th>
						      	<th><?php echo e(tr('username')); ?></th>
						      	<th><?php echo e(tr('email')); ?></th>
						      	<th><?php echo e(tr('mobile')); ?></th>
						      	<th><?php echo e(tr('total_jobs')); ?></th>
						      	<?php if(Setting::get('email_verify_control')): ?>
							      	<th><?php echo e(tr('email_verification')); ?></th>
							    <?php endif; ?>
						      	<th><?php echo e(tr('status')); ?></th>
						      	<th><?php echo e(tr('action')); ?></th>
						    </tr>

						</thead>

						<tbody>

							<?php if(count($users) > 0 ): ?>

								<?php foreach($users as $i => $user_details): ?>

								    <tr>
								      	<td><?php echo e(showEntries($_GET,$i + 1)); ?></td>

								      	<td>
								      		<a href="<?php echo e(route('admin.users.view' , ['user_id' => $user_details->id ] )); ?>"> 
								      			<?php echo e($user_details->name); ?>


												<?php if($user_details->status == USER_APPROVED): ?>
								      				<span class="text-green pull-right"><i class="fa fa-check-circle"></i></span>

								      			<?php else: ?>
								      				<span class="text-red pull-right"><i class="fa fa-times"></i></span>

								      			<?php endif; ?>

								      		</a>

								      	</td>

								      	<td><?php echo e($user_details->email); ?></td>

								      	<td><?php echo e($user_details->mobile); ?></td>

								      	<td><a href="<?php echo e(route('admin.users.history', ['user_id' => $user_details->id ] )); ?>"><?php echo e($user_details->userRequests ? $user_details->userRequests->count() : "0"); ?></a></td>

										<?php if(Setting::get('email_verify_control') == EMAIL_VERIFICATION_ON): ?>

									      	<td>

										      	<?php if($user_details->is_verified == USER_EMAIL_NOT_VERIFIED): ?>

										      		<a href="<?php echo e(route('admin.users.verify' , [ 'user_id' => $user_details->id] )); ?>" 
										      		class="btn btn-xs btn-success" onclick="return confirm(&quot;<?php echo e($user_details->name); ?> - <?php echo e(tr('user_email_confirmation')); ?>&quot;);"><?php echo e(tr('verify')); ?>

										      		</a>

										      	<?php else: ?>

										      		<span><?php echo e(tr('verified')); ?></span>

										      	<?php endif; ?>
									      	
									    	</td>

									    <?php endif; ?>

								       	<td>
								      		<?php if($user_details->status == USER_APPROVED): ?>
								      			<span class="label label-success"><?php echo e(tr('approved')); ?></span>
								       		<?php else: ?>
								       			<span class="label label-warning"><?php echo e(tr('pending')); ?></span>
								       		<?php endif; ?>
								       	</td>
								      	
										<td>
											
											<div class="dropdown <?php if($i < 2): ?> dropdown <?php else: ?> dropup <?php endif; ?>">
												
												<button class="btn btn-default dropdown-toggle" type="button" id="dropdownMenu" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">	
													<?php echo e(tr('action')); ?><span class="caret"></span>
												</button>

												<ul class="dropdown-menu" aria-labelledby="dropdownMenu">
													<li>
														<a href="<?php echo e(route('admin.users.view' , [ 'user_id' => $user_details->id ] )); ?>">		
															<b><?php echo e(tr('view')); ?></b>
														</a>
													</li>
													
													<?php if(Setting::get('admin_demo_control')): ?>

														<li>
															<a href="javascript:;" class="btn disabled" style="text-align: left;"><b><?php echo e(tr('edit')); ?></b></a>
														</li>

														<li>
															<a href="javascript:;" class="btn disabled" style="text-align: left">
									                  			<b><?php echo e(tr('delete')); ?></b>
									                  		</a>
														</li>

													<?php else: ?>

														<li>
															<a href="<?php echo e(route('admin.users.edit' , [ 'user_id' => $user_details->id ] )); ?>"><b><?php echo e(tr('edit')); ?></b>
															</a>
														</li>

														<li>
															<a  onclick="return confirm(&quot;<?php echo e(tr('admin_user_delete_confirmation' , $user_details->name)); ?>&quot;);" href="<?php echo e(route('admin.users.delete', [ 'user_id' => $user_details->id ] )); ?>">
								                  				<b><?php echo e(tr('delete')); ?></b>
								                  			</a>
														</li>

													<?php endif; ?>
												
													<li role="separator" class="divider"></li>

								      				<?php if($user_details->status == USER_APPROVED): ?>
								                  	
								                  		<li>
								                  			<a href="<?php echo e(route('admin.users.status' , [ 'user_id' => $user_details->id ] )); ?>" onclick="return confirm(&quot;<?php echo e($user_details->name); ?> - <?php echo e(tr('user_decline_confirmation')); ?>&quot;);"><b><?php echo e(tr('decline')); ?></b></a>
								                  		</li>

								                  	<?php else: ?>

								                  		<li>
								                  			<a href="<?php echo e(route('admin.users.status' , [ 'user_id' => $user_details->id ] )); ?>"><b><?php echo e(tr('approve')); ?></b></a>
								                  		</li>

								                  	<?php endif; ?>

													<li class="divider" role="presentation"></li>

													<li>
									              		<a href="<?php echo e(route('admin.users.history', ['user_id' => $user_details->id ] )); ?>">
									              			<b><?php echo e(tr('view_history')); ?></b>
									              		</a>
									              	</li>
									              	
									              	<li>
									              		<a href="<?php echo e(route('admin.users.fav_providers', [ 'user_id' => $user_details->id ] )); ?>">
									              			<b><?php echo e(tr('fav_providers')); ?></b>
									              		</a>
									              	</li>

												</ul>
											</div>
					
										</td>

								    </tr>
								<?php endforeach; ?>

							<?php else: ?>

								<tr><?php echo e(tr('user_not_found')); ?></tr>

							<?php endif; ?>

						</tbody>
					
					</table>

					<div align="right"><?php echo e($users->links()); ?></div>
	            
	            </div>
         	
         	</div>

        </div>
        
    </div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>