<?php $__env->startSection('after-styles'); ?>

<link rel="stylesheet" href="<?php echo e(asset('common/css/bootstrap-dialog.min.css')); ?>">

<link href="<?php echo e(asset('common/assets/css/material-bootstrap-wizard.css')); ?>" rel="stylesheet" />

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<div class="content-wrap gray-bg">

	<div class="dashboard row m-0 p-30" id="revenues">
		
		<div class="container">

		    <?php if(Auth::guard('provider')->user()->is_approved == PROVIDER_STATUS_PENDING): ?>
		    
		        <div class="alert alert-danger text-uppercase">
		            <?php echo e(tr('provider_waiting_for_admin_approval')); ?>

		        </div>

		    <?php endif; ?>			    

			<?php echo $__env->make('notification.notify', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

			<!-- Dashboard Right -->
			<div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
			    <div class="row">	

	    	    	<!-- total_earnings -->
	    	    	<div class="col-lg-3 col-xs-6">
			    	    <div class="card">
			    	    	<center>
				    	    	<div class="card-header d-flex p-2">
				    	    	<h4><?php echo e(tr('total_earnings')); ?></h4>
				    	    	</div>
				    	        <div class="inner">
				    	            <h4><?php echo e(formatted_amount($revenues->data->total_earnings)); ?></h4>
				    	        </div>
			    	        </center>
			    	    </div>			    	
			    	</div>	

	    	    	<!-- total_upcoming_jobs -->
			    	<div class="col-lg-3 col-xs-6">
			    	    <div class="card">
			    	    	<center>
				    	    	<div class="card-header d-flex p-2"><h4><?php echo e(tr('total_upcoming_jobs')); ?></h4></div>

				    	        <div class="inner">
				    	            <h4><?php echo e($revenues->data->total_upcoming_jobs); ?></h4>
				    	        </div>
			    	        </center>
			    	    </div>			    	
			    	</div>

	    	    	<!-- total_completed_jobs -->
			    	<div class="col-lg-3 col-xs-6">
			    	    <div class="card">
			    	    	<center>
				    	    	<div class="card-header d-flex p-2"><h4><?php echo e(tr('total_completed_jobs')); ?></h4></div>

				    	        <div class="inner">
				    	            <h4><?php echo e($revenues->data->total_completed_jobs); ?></h4>
				    	        </div>
			    	        </center>
			    	    </div>
			    	
			    	</div>
					
					<!-- total_cancelled_jobs -->
			    	<div class="col-lg-3 col-xs-6">
			    	    <div class="card">
			    	    	<center>
				    	    	<div class="card-header d-flex p-2"><h4><?php echo e(tr('total_cancelled_jobs')); ?></h4></div>

				    	        <div class="inner">
				    	            <h4><?php echo e($revenues->data->total_cancelled_jobs); ?></h4>
				    	        </div>
			    	        </center>
			    	    </div>			    	
			    	</div>
			    				
				</div>
			</div>
			
			<div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 p-f-30">
				<div class="tab-content white-bg">
				    <div class="row">			            
			            <div class="col-lg-12 col-md-9 card">						
							<center><h3><?php echo e(tr('service_based_revenue')); ?></h3></center>
							<hr>						
							<?php foreach($revenues->data->service_based_revenues as $key => $value): ?>
								<div class="col-md-3">
									<center>
										<div>
											<img src="<?php echo e($value->sub_category_picture); ?>" style="max-width: 100px; min-height: 100px">
										</div>										
										<h5><?php echo e($value->sub_category_name); ?></h5>
										<h4><?php echo e(formatted_amount($value->total_earnings)); ?></h4>
									</center>
								</div>
							<?php endforeach; ?>
						</div>
					</div>
				</div>
			</div>			

			<div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 p-f-30">
				<div class="tab-content white-bg">
				    <div class="row">			            
			            <div class="col-lg-12 col-md-9 card">						
							<center><h3><?php echo e(tr('revenue_of_x_days')); ?></h3></center>
							<hr>
							<center>
								<div style="width:70%;">
									<canvas id="canvas"></canvas>
								</div>
							</center>
						</div>
					</div>
				</div>			
			</div>
					
			<!-- End of dashboard right -->
		
		</div>
	
	</div>

</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('after-scripts'); ?>

<script src="<?php echo e(asset('assets/charts/Chart.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/charts/utils.js')); ?>"></script>

<script>

	var MONTHS = [
		<?php foreach ($revenues->data->last_x_days_revenues as $key => $value) {
			echo "'".$value->date."'".",";
		} ?>
	];

	var config = {
		type: 'line',
		data: {
			labels: [
				<?php foreach ($revenues->data->last_x_days_revenues as $key => $value) {
					echo "'".$value->date."'".",";
				} ?>
			],
			datasets: [{

					label: 'Revenue of Last 10 Days',
					backgroundColor: window.chartColors.red,
					borderColor: window.chartColors.red,
					data: [

						<?php foreach ($revenues->data->last_x_days_revenues as $key => $value) {
							echo "".$value->total_earnings."".",";
						} ?>
					],
					fill: false,
			}]
		},

		options: {
			responsive: true,
			title: {
				display: true,
				// text: 'Revenue of Last 10 Days'
			},
			tooltips: {
				mode: 'index',
				intersect: false,
			},
			hover: {
				mode: 'nearest',
				intersect: true
			},
			scales: {
				xAxes: [{
					display: true,
					scaleLabel: {
						display: true,
						labelString: 'Date'
					}
				}],
				yAxes: [{
					display: true,
					scaleLabel: {
						display: true,
						labelString: 'Value'
					}
				}]
			}
		}
	};

	window.onload = function() {
		var ctx = document.getElementById('canvas').getContext('2d');
		window.myLine = new Chart(ctx, config);
	};

</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.provider', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>