<?php $__env->startSection('title', tr('email_templates')); ?>

<?php $__env->startSection('content-header', tr('email_templates')); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <li><a href="<?php echo e(route('admin.dashboard')); ?>"><i class="fa fa-dashboard"></i><?php echo e(tr('home')); ?></a></li>
    <li class="active"><i class="fa fa-envelope"></i> <?php echo e(tr('email_templates')); ?></li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <?php echo $__env->make('notification.notify', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

    <div class="row">
        <div class="col-xs-12">

        <div class="box box-success">

            <div class="box-header with-border admin-panel-success">

                <b><?php echo e(tr('email_templates')); ?></b>

            </div>

            <div class="box-body">

                <table id="datatable-withoutpagination" class="table table-bordered table-striped">

                    <thead>
                    
                        <tr>
                            <th>#<?php echo e(tr('id')); ?></th>
                            <th><?php echo e(tr('type')); ?></th>
                            <th><?php echo e(tr('subject')); ?></th>
                            <th><?php echo e(tr('status')); ?></th>
                            <th><?php echo e(tr('action')); ?></th>
                        </tr>

                    </thead>

                    <tbody>

                        <?php foreach($model as $i => $data): ?>
                
                            <tr>
                                <td><?php echo e(showEntries($_GET,$i + 1)); ?></td>

                                <td><?php echo e($data->type); ?></td>

                                <td><?php echo e($data->subject); ?></td>

                                <td>
                                    <?php if($data->status): ?>
                                        <span class="label label-success"><?php echo e(tr('enabled')); ?></span>
                                    <?php else: ?>
                                        <span class="label label-warning"><?php echo e(tr('disabled')); ?></span>
                                    <?php endif; ?>
                                </td>

                                <td>

                                    <div class="dropdown">
                                            
                                        <button class="btn btn-default dropdown-toggle" type="button" id="dropdownMenu" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                            <?php echo e(tr('action')); ?>

                                            <span class="caret"></span>
                                        </button>

                                        <ul class="dropdown-menu" aria-labelledby="dropdownMenu">
                                            <li>
                                                <?php if(Setting::get('admin_demo_control')): ?>
                                                    <a href="javascript:;" class="btn disabled" style="text-align: left"><b><?php echo e(tr('edit')); ?></b></a>
                                                <?php else: ?>
                                                    <a href="<?php echo e(route('admin.templates.email_template_edit', array('id' => $data->id))); ?>"><b><?php echo e(tr('edit')); ?></b></a>
                                                <?php endif; ?>
                                            </li>

                                            <li>
                                               
                                                <a href="<?php echo e(route('admin.templates.email_template_credential', array('id' => $data->id))); ?>"><b>
                                                         <?php if($data->status): ?><?php echo e(tr('disable')); ?><?php else: ?> <?php echo e(tr('enable')); ?> <?php endif; ?></b></a>
                                              
                                                
                                            </li>

                                            <li>
                                                <?php if(Setting::get('admin_demo_control')): ?>
                                                    <a href="javascript:;" class="btn disabled" style="text-align: left"><b><?php echo e(tr('view')); ?></b></a>

                                                <?php else: ?>
                                                    <a href="<?php echo e(route('admin.templates.email_template_view',array('id' => $data->id))); ?>"><b><?php echo e(tr('view')); ?></b></a>

                                                <?php endif; ?>

                                            </li>                                    

                                        </ul>

                                    </div>
                                </td>
                            
                            </tr>

                        <?php endforeach; ?>

                    </tbody>
                </table>
                <div align="right"><?php echo e($model->links()); ?></div>
            </div>
          </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>