    

<?php $__env->startSection('title', tr('services')); ?>

<?php $__env->startSection('content-header'); ?>

<?php echo e(tr('services')); ?>


<a href="<?php echo e(route('admin.providers.view' , ['provider_id' => $provider_details->id])); ?>">

- <?php echo e($provider_details->name); ?>


</a>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb'); ?>

    <li><a href="<?php echo e(route('admin.dashboard')); ?>"><i class="fa fa-dashboard"></i><?php echo e(tr('home')); ?></a></li>

    <li><a href="<?php echo e(route('admin.providers.index')); ?>"><i class="fa fa-users"></i> <?php echo e(tr('providers')); ?></a></li>

    <li class="active"><?php echo e(tr('services')); ?></li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

	<?php echo $__env->make('notification.notify', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

	<div class="row">

        <div class="col-xs-12">
            
            <div class="box box-success">

                <div class="box-header with-border admin-panel-success">

	                <b><?php echo e(tr('services')); ?></b>

	                <a href="<?php echo e(route('admin.providers.index')); ?>" style="float:right" class="btn btn-default"><?php echo e(tr('view_providers')); ?></a>
                    
	            </div>

                <div class="box-body">

                    <table id="datatable-withoutpagination" class="table table-bordered table-striped">

                        <thead>
                            <tr>
                                <th><?php echo e(tr('s_no')); ?></th>
                                <th><?php echo e(tr('category')); ?></th>
                                <th><?php echo e(tr('sub_category')); ?></th>
                                <th><?php echo e(tr('price_per_hour')); ?></th>
                                <th><?php echo e(tr('description')); ?></th>
                                <th><?php echo e(tr('joined')); ?></th>
                                <th><?php echo e(tr('updated')); ?></th>
                                <th><?php echo e(tr('status')); ?></th>
                            </tr>
                        </thead>

                        <tbody>

                            <?php foreach($provider_services as $i => $provider_service_details): ?>
                            
                                <tr>

                                    <td><?php echo e(showEntries($_GET,$i+1)); ?></td>

                                    <td>
                                        <?php echo e($provider_service_details->category ? $provider_service_details->category->name : " - "); ?>

                                    </td>
                                    
                                    <td>
                                        <?php echo e($provider_service_details->subCategory ? $provider_service_details->subCategory->name : "-"); ?>

                                    </td>                        

                                    <td>
                                        <?php echo e($provider_service_details->price_per_hour ? $provider_service_details->price_per_hour : "0.00"); ?>

                                    </td>

                                    <td>
                                        <?php echo e($provider_service_details->description ? $provider_service_details->description : " - "); ?>

                                    </td>

                                    <td>
                                        <?php echo e(date('d-m-Y H:i:s' , strtotime($provider_service_details->created_at))); ?>

                                    </td>

                                    <td>
                                        <?php echo e(date('d-m-Y H:i:s' , strtotime($provider_service_details->updated_at))); ?>

                                    </td>

                                    <td>
                                        <?php if($provider_service_details->status): ?>
                                            <span class="label label-success"><?php echo e(tr('available')); ?></span>
                                        <?php endif; ?>
                                    </td>
                                
                                </tr>
                            
                            <?php endforeach; ?>
                        
                        </tbody>

            		</table>

			         <div align="right"><?php echo e($provider_services->links()); ?></div>
                </div>

            </div>

        </div>
        
    </div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>