
<form action="<?php echo e(Setting::get('admin_demo_control') == YES ? '#' : route('admin.categories.save')); ?>" method="POST" enctype="multipart/form-data" role="form">
                    
    <input type="hidden" name="category_id" value="<?php echo e($category_details->id); ?>">

    <div class="box-body">

        <div class="form-group">

            <label for="categoryname"><?php echo e(tr('name')); ?> * </label>

            <input type="text" required name="name" class="form-control" id="categoryname" value="<?php echo e(old('name') ?: $category_details->name); ?>" placeholder="<?php echo e(tr('category_name')); ?>" autofocus>
        </div>

        <div class="form-group">
            <label for="description"><?php echo e(tr('description')); ?> * </label>
            
            <input type="text" required class="form-control" id="description" name="description" value="<?php echo e(old('description') ?: $category_details->description); ?>" placeholder="<?php echo e(tr('description')); ?>">
        </div>

        <div class="form-group">
            <label for="picture"><?php echo e(tr('picture')); ?> *</label>
            
            <input type="file" class="form-control" name="picture" id="picture" accept="image/png,image/jpeg" onchange="loadFileview(this,'image_preview')" accept="image/*" <?php if(!$category_details->id): ?>required <?php endif; ?>>
            
            <br>

            <?php if( $category_details->id != ''): ?>
                <img id="image_preview" style="height: 90px; margin-bottom: 15px; border-radius:2em;" src="<?php echo e($category_details->picture); ?>">
          	<?php endif; ?>

        </div>
        
    </div>

    <div class="box-footer">

        <button type="reset" class="btn btn-danger"><?php echo e(tr('reset')); ?></button>
        <?php if(Setting::get('admin_demo_control')): ?>
        <button type="button" class="btn btn-success pull-right" disabled><?php echo e(tr('submit')); ?></button>
        <?php else: ?>
        <button type="submit" class="btn btn-success pull-right"><?php echo e(tr('submit')); ?></button>
        <?php endif; ?>
        
    </div>

</form>

            