<?php $__env->startSection('title', tr('abuse_providers')); ?>

<?php $__env->startSection('content-header', tr('abuse_providers')); ?>

<?php $__env->startSection('breadcrumb'); ?>

    <li><a href="<?php echo e(route('admin.dashboard')); ?>"><i class="fa fa-dashboard"></i><?php echo e(tr('home')); ?></a></li>

    <li class="active"><i class="fa fa-info"></i> <?php echo e(tr('abuse_providers')); ?></li>
    
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

	<?php echo $__env->make('notification.notify', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

	<div class="row">

        <div class="col-xs-12">

	        <div class="box box-success">

            	<div class="box-header with-border admin-panel-success">

	                <b><?php echo e(tr('abuse_providers')); ?></b>

	            </div>
            
	            <div class="box-body">

					<?php if(count($abuse_providers) > 0): ?>

		              	<table id="datatable-withoutpagination" class="table table-bordered table-striped">

							<thead>
							    <tr>
							      <th><?php echo e(tr('id')); ?></th>
							      <th><?php echo e(tr('user')); ?></th>
							      <th><?php echo e(tr('provider')); ?></th>
							      <th><?php echo e(tr('request')); ?></th>
							      <th><?php echo e(tr('comment')); ?></th>
							      <th><?php echo e(tr('date')); ?></th>
							      <!-- <th><?php echo e(tr('action')); ?></th> -->
							    </tr>
							</thead>

							<tbody>

								<?php foreach($abuse_providers as $i => $abuse_provider_details): ?>

								    <tr>
								      	<td><?php echo e(showEntries($_GET,$i+1)); ?></td>

								      	<td>
								      		<a href="<?php echo e(route('admin.users.view' , ['user_id' => $abuse_provider_details->user_id] )); ?>">
								      		<?php echo e($abuse_provider_details->user->name ?? ""); ?>

								      		</a>
								      	</td>

								      	<td>
								      		<a href="<?php echo e(route('admin.providers.view' , ['provider_id' => $abuse_provider_details->provider_id] )); ?>">
								      			<?php echo e($abuse_provider_details->provider->name ?? ""); ?>

								      		</a>
								      	</td>

								      	<td>

								      		<?php if($abuse_provider_details->requests): ?>

								      		<a href="<?php echo e(route('admin.requests.view' , [ 'request_unique_id' => $abuse_provider_details->requests->unique_id] )); ?>">
								      			<?php echo e($abuse_provider_details->requests ? $abuse_provider_details->requests->name : ""); ?>

								      		</a>

								      		<?php endif; ?>

								      	</td>

								      	<td>

								      		<?php if($abuse_provider_details->userRating): ?>

								      			<?php echo e($abuse_provider_details->userRating ? $abuse_provider_details->userRating->comment : ""); ?>


								      		<?php endif; ?>

								      	</td>

								     	<td>
								     		<?php echo e($abuse_provider_details->created_at ? $abuse_provider_details->created_at->diffForHumans() : "-"); ?>

								     	</td>

								    </tr>

								<?php endforeach; ?>

							</tbody>

						</table>

						<div align="right"><?php echo e($abuse_providers->links()); ?></div>

					<?php else: ?>

						<h3 class="no-result"><?php echo e(tr('no_result_found')); ?></h3>

					<?php endif; ?>
				
	            </div>

          	</div>

        </div>
        
    </div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>