<nav class="navbar navbar-default navbar-fixed-top" role="navigation">
	<div class="container">
		<div class="navbar-header">
	
			<button type="button" class="navbar-toggle" data-toggle="collapse" data-target="#bs-example-navbar-collapse-1">
				<span class="sr-only">Toggle navigation</span>
				<span class="icon-bar"></span>
				<span class="icon-bar"></span>
				<span class="icon-bar"></span>
			</button> 
			<a class="navbar-brand" href="<?php echo e(route('provider.dashboard')); ?>">
				<div class="bg-img logo" style="background-image: url(<?php echo e(Setting::get('site_logo')); ?>);"></div>
			</a>
		</div>
		
		<div class="collapse navbar-collapse" id="bs-example-navbar-collapse-1">

			<ul class="nav navbar-nav navbar-right">

				<?php if(Auth::guard('provider')->check()): ?>

					<?php if(Auth::guard('provider')->user()->step == PROVIDER_STEP_COMPLETE): ?>

						<li id="provider_dashboard">
							<a href="<?php echo e(route('provider.dashboard' , ['dashboard' => 1])); ?>"><?php echo e(tr('dashboard')); ?></a>
						</li>

						<li id="provider_history">
							<a href="<?php echo e(route('provider.history')); ?>"><?php echo e(tr('history')); ?></a>
						</li>

						<li id="provider_account">
							<a href="<?php echo e(route('provider.profile')); ?>"><?php echo e(tr('account')); ?></a>
						</li>

						<?php if(Setting::get('provider_notification_control')): ?>

						<li>

							<?php $notification = get_provider_notifications(); ?>

							<ul class="nav navbar-nav">

						        <li class="dropdown">

						          	<a  id="notify_click" href="#" class="dropdown-toggle" data-toggle="dropdown" role="button" aria-haspopup="true" aria-expanded="false" style="position: relative;"><i class="fa fa-bell notifi-bell"></i> 
						          	<div class="bell_badge"><span class="cnt" style="<?php echo e($notification['new_notify'] > 0 ? '' : 'display: none'); ?>"><?php echo e($notification['new_notify']); ?></span></div>
						          	</a>

						          	<ul class="dropdown-menu notify-drop">
						            	<div class="notify-drop-title">
							            	<div class="row">
							            		<div class="col-md-12 col-sm-12 col-xs-12 text-uppercase"><?php echo e(tr('notifications')); ?> (<b>&nbsp;<span class="cnt"><?php echo e($notification['new_notify']); ?></span>&nbsp;</b>)</div>
							            		
							            	</div>
						            	</div>
							            <!-- end notify title -->
							            <!-- notify content -->
							            <div class="drop-content">

							            	<span id="append_value" style="font-size: 11px"></span>

							            	<?php if(count($notification['model']) > 0): ?>

								            	<?php foreach($notification['model'] as $notify): ?>
								            	
								            	<li>
								            		<a target="_blank" href="<?php echo e(route('provider.requests.view' , ['request_unique_id' => $notify->unique_id])); ?>">

								            		<div style="padding: 3px 5px">

									            		<div class="col-md-2 col-sm-2 col-xs-2">

									            		<?php $img = $notify->picture ? $notify->picture : asset('placeholder.png');?>

									            			<div class="incoming-img bg-img" style="background-image:url(<?php echo e($img); ?>);width: 40px;height: 40px">
									            			</div>
									            		</div>

									            		<div class="col-md-8 col-sm-8 col-xs-8">

									            			<p class="notification_text"> <?= $notify->notification ;?></p>
									            		
											            		<!-- <hr> pd-l0-->

											            	<p><?php echo e($notify->created_at->diffForHumans()); ?></p>


									            		</div>

									            		<div class="clearfix"></div>

								            		</div>

								            		<!-- <hr> -->

								            		</a>
								            	</li>

								            	<?php endforeach; ?>

							            	<?php else: ?>

							            		<li><p class="text-center"><?php echo e(tr('no_notification_found')); ?></p></li>

							            	<?php endif; ?>
							            </div>
							            <?php if(count($notification['model']) > 10): ?>
								            <div class="notify-drop-footer text-center">
								            	<a href="<?php echo e(route('provider.notification.see_all')); ?>"><i class="fa fa-eye"></i> <?php echo e(tr('see_all_notifications')); ?></a>
								            </div>
							            <?php endif; ?>
						          	</ul>

						        </li>

					     	</ul>

						</li>

						<?php endif; ?>

						<?php if(Setting::get('admin_language_control') == 0): ?>

							<?php if(count($languages = getActiveLanguages()) > 1): ?>

							<li  class="dropdown" id="language">
	                    
						        <a href="#" class="dropdown-toggle" data-toggle="dropdown" aria-expanded="false"><i class="fa fa-globe"></i>&nbsp;  <b class="caret"></b></a>
						        <ul class="dropdown-menu">
						        	<?php foreach($languages as $h => $language): ?>
						          		<li class="<?php echo e((\Session::get('locale') == $language->folder_name) ? 'active' : ''); ?>" ><a href="<?php echo e(route('user_session_language', $language->folder_name)); ?>" style="<?php echo e((\Session::get('locale') == $language->folder_name) ? 'background-color: #51af33' : ''); ?>"><?php echo e($language->folder_name); ?></a></li>
						          	<?php endforeach; ?>
						        </ul>
						     
							</li>

							<?php endif; ?>

						<?php endif; ?>

						<li id="logout">
							<a href="<?php echo e(route('provider.logout')); ?>"><i class="fa fa-sign-out"></i></a>
						</li>

					<?php else: ?> 

						<!-- <li>
							<a class="provider-head-disable" href=""><?php echo e(tr('dashboard')); ?></a>
						</li>

						<li>
							<a class="provider-head-disable" href=""><?php echo e(tr('history')); ?></a>
						</li>

						<li>
							<a class="provider-head-disable" href=""><?php echo e(tr('account')); ?></a>
						</li> -->
						<li id="logout">
							<a href="<?php echo e(route('provider.logout')); ?>"><i class="fa fa-sign-out"></i></a>
						</li>
					<?php endif; ?>

				<?php else: ?>

					<li>
						<a href="<?php echo e(route('choose.register')); ?>"><?php echo e(tr('signup')); ?></a>
					</li>

					<li>
						<a href="<?php echo e(route('how_it_works')); ?>"><?php echo e(tr('how_it_works')); ?></a>
					</li>

					<li>
						<a href="<?php echo e(route('choose.register')); ?>"><?php echo e(tr('login')); ?></a>
					</li>

					<?php if(Setting::get('admin_language_control') == 0): ?>
					
					<li  class="dropdown">
                    
				        <a href="#" class="dropdown-toggle" data-toggle="dropdown" aria-expanded="false"><?php echo e(tr('language')); ?> <b class="caret"></b></a>
				        <ul class="dropdown-menu">
				        	<?php foreach(getActiveLanguages() as $h => $language): ?>
				          		<li class="<?php echo e((\Session::get('locale') == $language->folder_name) ? 'active' : ''); ?>" ><a href="<?php echo e(route('user_session_language', $language->folder_name)); ?>" style="<?php echo e((\Session::get('locale') == $language->folder_name) ? 'background-color: #51af33' : ''); ?>"><?php echo e($language->folder_name); ?></a></li>
				          	<?php endforeach; ?>
				        </ul>
				     
					</li>

					<?php endif; ?>

				<?php endif; ?>
			
			</ul>
			
		</div>
	</div>
</nav>