<?php $__env->startSection('title', tr('pages')); ?>

<?php $__env->startSection('content-header', tr('pages')); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <li><a href="<?php echo e(route('admin.dashboard')); ?>"><i class="fa fa-dashboard"></i>Home</a></li>
    <li class="active"><i class="fa fa-book"></i> <?php echo e(tr('pages')); ?></li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <?php echo $__env->make('notification.notify', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

    <div class="row">

        <div class="col-xs-12">
          
            <div class="box box-success">

                <div class="box-header with-border admin-panel-success">

                    <b style="font-size:18px;"><?php echo e(tr('pages')); ?></b>

                    <a href="<?php echo e(route('admin.static_pages.create')); ?>" class="btn btn-warning pull-right">
                        <b><i class="fa fa-plus"></i> <?php echo e(tr('add_page')); ?></b>
                    </a>

                </div>

                <div class="box-body">

                    <?php if(count($pages) > 0): ?>

                        <table id="datatable-withoutpagination" class="table table-bordered table-striped">

                            <thead>
                                <tr>
                                    <th>#<?php echo e(tr('id')); ?></th>
                                    <th><?php echo e(tr('heading')); ?></th>
                                    <th><?php echo e(tr('page_type')); ?></th>
                                    <th><?php echo e(tr('action')); ?></th>
                                </tr>
                            </thead>

                            <tbody>

                                <?php foreach($pages as $i => $page_details): ?>
                        
                                    <tr>
                                        <td><?php echo e(showEntries($_GET,$i+1)); ?></td>

                                        <td><a href="<?php echo e(route('other.pages' , $page_details->unique_id)); ?>" target="_blank"><?php echo e($page_details->heading); ?></a></td>

                                        <td><?php echo e($page_details->type); ?></td>

                                        <td>
                                            <div class="dropdown <?php if($i < 2): ?> dropdown <?php else: ?> dropup <?php endif; ?>">
                                        
                                                <button class="btn btn-default dropdown-toggle" type="button" id="dropdownMenu" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                    
                                                    <?php echo e(tr('action')); ?>

                                                    <span class="caret"></span>
                                                </button>


                                                <ul class="dropdown-menu" aria-labelledby="dropdownMenu">
                                                
                                                    
                                                    <li role="presentation">
                                                        <a role="menuitem" tabindex="-1" href="<?php echo e(route('admin.static_pages.edit', ['static_page_id' => $page_details->id] )); ?>">
                                                            <b><?php echo e(tr('edit')); ?></b>
                                                        </a>
                                                    </li>

                                                    
                                                    <li role="presentation">
                                                        <?php if(Setting::get('admin_demo_control')): ?>

                                                            <a role="button" href="javascript:;" class="btn disabled" style="text-align: left"><b><?php echo e(tr('delete')); ?></b></a>

                                                        <?php else: ?>
                                                            <a role="menuitem" tabindex="-1" onclick="return confirm(&quot;<?php echo e(tr('admin_page_delete_confirmation' , $page_details->type)); ?>&quot;);" href="<?php echo e(route('admin.static_pages.delete',['static_page_id' => $page_details->id] )); ?>">
                                                                <b><?php echo e(tr('delete')); ?></b>
                                                            </a>
                                                        <?php endif; ?>
                                                    </li>

                                                </ul>
                                                
                                            </div>                                                
                                        </td>
                                    </tr>
                                <?php endforeach; ?>

                            </tbody>
                        
                        </table>

                        <div align="right"><?php echo e($pages->links()); ?></div>
                    <?php else: ?>
                        <h3 class="no-result"><?php echo e(tr('no_result_found')); ?></h3>
                    <?php endif; ?>
                
                </div>

            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>