<?php $__env->startSection('title', tr('galleries')); ?>

<?php $__env->startSection('content-header'); ?>

<?php echo e(tr('galleries')); ?> - 

<a href="<?php echo e(route('admin.providers.view' , ['provider_id' => $provider_details->id])); ?>"> <?php echo e($provider_details->name); ?></a>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <li><a href="<?php echo e(route('admin.dashboard')); ?>"><i class="fa fa-dashboard"></i><?php echo e(tr('home')); ?></a></li>

    <li><a href="<?php echo e(route('admin.providers.index')); ?>"><i class="fa fa-users"></i> <?php echo e(tr('providers')); ?></a></li>

    <li class="active"> <?php echo e(tr('galleries')); ?></li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('after-styles'); ?>

<style>
    .btn:focus, .btn:active, button:focus, button:active {
        outline: none !important;
        box-shadow: none !important;
    }

    #image-gallery .modal-footer{
        display: block;
    }

    .thumb{
        margin-top: 15px;
        margin-bottom: 15px;
    }
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <?php echo $__env->make('notification.notify', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

    <div class="row">

        <div class="col-xs-12">

            <form action="<?php echo e(route('admin.providers.gallery.save')); ?>" method="POST" enctype="multipart/form-data" role="form">

                <input type="hidden" name="provider_id" value="<?php echo e($provider_details->id); ?>">

                <div class="row">

                    <p style="margin: 10px 10px 10px 20px"><?php echo e(tr('upload_picture')); ?></p>

                    <div class="col-md-4">

                        <div class="form-group">

                            <input type="file" name="picture" class="form-control" accept="image/*">

                        </div>
                    </div>

                    <div class="col-md-4">

                        <button type="submit" class="btn btn-success"><?php echo e(tr('upload')); ?></button>

                    </div>

                </div>

            </form>

        </div>

            <?php if(count($galleries) > 0): ?>

                <?php foreach($galleries as $gallery_details): ?>

                <div class="col-lg-3 col-md-4 col-xs-6 thumb">

                    <a class="thumbnail" href="#" data-image-id="" data-toggle="modal" data-title="<?php echo e(Setting::get('site_name')); ?>" data-image="<?php echo e($gallery_details->picture); ?>" data-target="#image-gallery">
                        <img class="img-thumbnail" src="<?php echo e($gallery_details->picture); ?>" alt="<?php echo e(Setting::get('site_name')); ?>" style="width: 500px; height: 200px;">
                    </a>
                </div>

                <?php endforeach; ?>

            <?php else: ?>

                <div class="col-md-12">

                    <h4 style="color: gray"><?php echo e(tr('no_result_found')); ?></h4>

                    <!-- <a href="<?php echo e(route('admin.providers.index')); ?>" class="btn btn-warning text-uppercase"> <i class="fa fa-arrow-left"></i> <?php echo e(tr('view_providers')); ?></a> -->

                </div>

            <?php endif; ?>

        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('after-scripts'); ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>