<?php $__env->startSection('title', tr('documents')); ?>

<?php $__env->startSection('content-header', tr('documents')); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <li><a href="<?php echo e(route('admin.dashboard')); ?>"><i class="fa fa-dashboard"></i><?php echo e(tr('home')); ?></a></li>
    <li class="active"><i class="fa fa-book"></i> <?php echo e(tr('documents')); ?></li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <?php echo $__env->make('notification.notify', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

    <div class="row">
        
        <div class="col-xs-12">

            <div class="box box-success">

                <div class="box-header with-border admin-panel-success">

                    <b><?php echo e(tr('documents')); ?></b>
                    
                    <a href="<?php echo e(route('admin.documents.create')); ?>" style="float:right" class="btn btn-warning">
                        <b><i class="fa fa-plus"></i> <?php echo e(tr('add_document')); ?> </b>
                    </a>
                </div>

                <div class="box-body">

                    <table id="datatable-withoutpagination" class="table table-bordered table-striped">

                        <thead>
                        
                            <tr>
                                <th><?php echo e(tr('id')); ?></th>
                                <th><?php echo e(tr('name')); ?></th>
                                <th><?php echo e(tr('status')); ?></th>
                                <th><?php echo e(tr('action')); ?></th>
                            </tr>

                        </thead>

                        <tbody>

                            <?php foreach($documents as $i => $document_details): ?>
                    
                                <tr>
                                    <td><?php echo e(showEntries($_GET,$i+1)); ?></td>

                                    <td><?php echo e($document_details->name); ?></td>

                                    <td>
                                        <?php if($document_details->status == COMMON_APPROVED): ?>

                                            <span class="label label-success"><?php echo e(tr('approved')); ?></span>

                                        <?php else: ?>
                                            <span class="label label-warning"><?php echo e(tr('pending')); ?></span>

                                        <?php endif; ?>
                                    </td>

                                    <td>

                                        <div class="dropdown">
                                                
                                            <button class="btn btn-default dropdown-toggle" type="button" id="dropdownMenu" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                <?php echo e(tr('action')); ?>

                                                <span class="caret"></span>
                                            </button>

                                            <ul class="dropdown-menu" aria-labelledby="dropdownMenu">
                                                
                                                <li>
                                                    <a href="<?php echo e(route('admin.providers.document' ,['document_id' => $document_details->id] )); ?>"><b><?php echo e(tr('view')); ?></b></a>
                                                </li>

                                                <?php if(Setting::get('admin_demo_control')): ?>
                                                    
                                                    <li>
                                                        <a href="javascript:;" class="btn disabled" style="text-align: left"><b><?php echo e(tr('edit')); ?></b></a>
                                                    </li>

                                                    <li>      
                                                        <a href="javascript:;" class="btn disabled" style="text-align: left"><b><?php echo e(tr('delete')); ?></b></a>
                                                    </li>

                                                    <li class="divider" role="presentation"></li>

                                                    <?php if($document_details->status == COMMON_APPROVED): ?>

                                                        <li>
                                                            <a href="javascript:;" class="btn disabled" style="text-align: left">
                                                            <b><?php echo e(tr('decline')); ?></b>
                                                            </a>
                                                        </li>

                                                    <?php else: ?>

                                                        <li>
                                                            <a href="javascript:;" class="btn disabled" style="text-align: left">
                                                            <b><?php echo e(tr('approve')); ?></b>
                                                            </a>
                                                        </li>

                                                    <?php endif; ?>

                                                <?php else: ?>

                                                    <li>
                                                        <a href="<?php echo e(route('admin.documents.edit', ['document_id' => $document_details->id])); ?>"><b><?php echo e(tr('edit')); ?></b></a>
                                                    </li>

                                                    <li>
                                                        <a onclick="return confirm(&quot;<?php echo e(tr('admin_document_delete_confirmation' , $document_details->name)); ?>&quot;)" href="<?php echo e(route('admin.documents.delete', ['document_id' => $document_details->id])); ?>"><b><?php echo e(tr('delete')); ?></b></a>
                                                    </li>

                                                    <li class="divider" role="presentation"></li>

                                                    <?php if($document_details->status == COMMON_APPROVED): ?>

                                                        <li>
                                                            <a onclick="return confirm(&quot;<?php echo e($document_details->name); ?> - <?php echo e(tr('document_decline_confirmation')); ?>&quot;)" href="<?php echo e(route('admin.documents.status', ['document_id' => $document_details->id] )); ?>"><b><?php echo e(tr('decline')); ?></b></a>
                                                        </li>

                                                    <?php else: ?>

                                                        <li>
                                                            <a href="<?php echo e(route('admin.documents.status', ['document_id' => $document_details->id] )); ?>"><b><?php echo e(tr('approve')); ?></b></a>
                                                        </li>

                                                    <?php endif; ?>

                                                <?php endif; ?>                  

                                            </ul>

                                        </div>

                                    </td>
                                
                                </tr>

                            <?php endforeach; ?>

                        </tbody>

                    </table>

                    <div align="right"><?php echo e($documents->links()); ?></div>
                
                </div>
                
            </div>

        </div>

    </div>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>