<!DOCTYPE html>

<html lang="en">

    <head>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1">

        <title><?php echo e(Setting::get('site_name')); ?></title>
        
        <meta name="robots" content="noindex">

        
        <meta name="description" content="<?php echo e(Setting::get('meta_description')); ?>">

        <meta name="author" content="<?php echo e(Setting::get('meta_author')); ?>">

        <meta name="keywords" content="<?php echo e(Setting::get('meta_keywords')); ?>">

        <link href="<?php echo e(asset('common/css/bootstrap.min.css')); ?>" rel="stylesheet">

        <?php echo $__env->yieldContent('before-styles'); ?>

        <link href="<?php echo e(asset('common/font-awesome/css/font-awesome.min.css')); ?>" rel="stylesheet">

        <link href="<?php echo e(asset('common/ionicons/css/ionicons.min.css')); ?>" rel="stylesheet">

        <link href="<?php echo e(asset('common/css/style.css')); ?>" rel="stylesheet">

        <link href="<?php echo e(asset('common/css/responsive.css')); ?>" rel="stylesheet">

        <link rel="shortcut icon" href="<?php echo e(Setting::get('site_icon') ?: asset('favicon.png')); ?>">

        <link rel="apple-touch-icon" sizes="57x57" href="<?php echo e(asset('icons/apple-icon-57x57.png')); ?>">
        <link rel="apple-touch-icon" sizes="60x60" href="<?php echo e(asset('icons/apple-icon-60x60.png')); ?>">
        <link rel="apple-touch-icon" sizes="72x72" href="<?php echo e(asset('icons/apple-icon-72x72.png')); ?>">
        <link rel="apple-touch-icon" sizes="76x76" href="<?php echo e(asset('icons/apple-icon-76x76.png')); ?>">
        <link rel="apple-touch-icon" sizes="114x114" href="<?php echo e(asset('icons/apple-icon-114x114.png')); ?>">
        <link rel="apple-touch-icon" sizes="120x120" href="<?php echo e(asset('icons/apple-icon-120x120.png')); ?>">
        <link rel="apple-touch-icon" sizes="144x144" href="<?php echo e(asset('icons/apple-icon-144x144.png')); ?>">
        <link rel="apple-touch-icon" sizes="152x152" href="<?php echo e(asset('icons/apple-icon-152x152.png')); ?>">
        <link rel="apple-touch-icon" sizes="180x180" href="<?php echo e(asset('icons/apple-icon-180x180.png')); ?>">
        <link rel="icon" type="image/png" sizes="192x192"  href="<?php echo e(asset('icons/android-icon-192x192.png')); ?>">
        <link rel="icon" type="image/png" sizes="32x32" href="<?php echo e(asset('icons/favicon-32x32.png')); ?>">
        <link rel="icon" type="image/png" sizes="96x96" href="<?php echo e(asset('icons/favicon-96x96.png')); ?>">
        <link rel="icon" type="image/png" sizes="16x16" href="<?php echo e(asset('icons/favicon-16x16.png')); ?>">
        <link rel="manifest" href="<?php echo e(asset('icons/manifest.json')); ?>">
        <meta name="msapplication-TileColor" content="#ffffff">
        <meta name="msapplication-TileImage" content="<?php echo e(asset('icons/ms-icon-144x144.png')); ?>">
        <meta name="theme-color" content="#ffffff">

        <?php echo $__env->yieldContent('after-styles'); ?>

        <style>
            .navbar-nav a {
                text-transform: uppercase;
            }
        </style>

    </head>

    <body>

        <div id="preloader">
            
            <div class="cssload-container">
                <div class="cssload-item cssload-moon"></div>
            </div>

        </div>

        <div class="main-content">

            <?php echo $__env->make('layouts.provider.header', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

            <?php echo $__env->yieldContent('content'); ?>

            <?php echo $__env->make('layouts.common.footer', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

        </div>

        <script src="<?php echo e(asset('common/js/jquery.min.js')); ?>"></script>

        <script src="<?php echo e(asset('common/js/bootstrap.min.js')); ?>"></script>

        <?php echo $__env->yieldContent('before-scripts'); ?>

        <script src="<?php echo e(asset('common/js/slick.min.js')); ?>"></script>

        <script src="<?php echo e(asset('common/js/scripts.js')); ?>"></script>

        <script type="text/javascript">
            <?php if(isset($header_page)): ?>
                $("#<?php echo e($header_page); ?>").addClass("header-active");

            <?php endif; ?>
        </script>

        <?php echo $__env->yieldContent('after-scripts'); ?>

        <script>            
            $(window).load(function() {
                $('#preloader').fadeOut(2000);
            });
        </script>

        <!-- Modal -->

        <div class="modal bd-example-modal-lg fade" id="incomingRequest" tabindex="-1" role="dialog">

            <div class="modal-dialog modal-lg">

                <div class="modal-content">

                    <div class="modal-header">

                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>

                        <h4 class="modal-title text-center" id="request_time_left"> 

                            <?php echo e(tr('provider_new_job_notification')); ?>


                        </h4>

                    </div>

                    <div class="modal-body text-center row m-0">

                        <div class="col-md-5">

                            <div class="map-responsive-trip" style="padding-bottom: 120%;">
                                <div id="map" style="height:400px;"></div>
                            </div>

                        </div>

                        <div class="incoming-left col-md-7">

                            <div class="incoming-img bg-img" id="request_user_image"></div>

                            <div class="table-responsive incoming-table">

                                <table class="table table-responsive">
                                    <thead>
                                        <tr>
                                            <th><?php echo e(tr('name')); ?></th>
                                            <th id="request_user_name"></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        
                                        <tr>
                                            <th scope="row"><?php echo e(tr('job_type')); ?></th>
                                            <td id="request_job_type"></td>
                                        </tr>

                                        <!-- <tr>
                                            <th scope="row"><?php echo e(tr('request_type')); ?></th>
                                            <td id="request_request_type"></td>
                                        </tr> -->

                                        <tr>
                                            <th scope="row"><?php echo e(tr('category')); ?></th>
                                            <td id="request_category"></td>
                                        </tr>

                                        <tr>
                                            <th scope="row"><?php echo e(tr('sub_category')); ?></th>
                                            <td id="request_sub_category"></td>
                                        </tr>

                                        <tr>
                                            <th scope="row"><?php echo e(tr('title')); ?></th>
                                            <td id="request_title"></td>
                                        </tr>

                                        <tr>
                                            <th scope="row"><?php echo e(tr('description')); ?></th>
                                            <td id="request_description"></td>
                                        </tr>

                                        <tr style="display: none;">
                                            <th scope="row"><?php echo e(tr('price')); ?> <?php echo e(tr('per_hour_symbol')); ?></th>
                                            <td id="request_price"></td>
                                        </tr>
                                    </tbody>
                                </table>
                            
                            </div>

                        </div>

                    </div>

                    <div class="modal-footer">

                        <a href="" id="request_decline_url" class="btn btn-default incoming-btn incoming-rej-btn col-xs-12"><?php echo e(tr('reject')); ?></a>

                        <a href="" id="request_accept_url" class="btn btn-primary incoming-btn incoming-save-btn"><?php echo e(tr('accept')); ?></a>

                    </div>
                </div>
            </div>
        
        </div>

        <script type="text/javascript" src="https://maps.googleapis.com/maps/api/js?v=3.exp&key=<?php echo e(envfile('GOOGLE_API_KEY')); ?>&libraries=places"></script>

        <script type="text/javascript">

            var globalOnPopup = 0;
            
            var maps = ['incomeMap'];

            function incomeMap(lat,lng) {
                var map;
        
                map = new google.maps.Map(document.getElementById('map'), {
                    center: new google.maps.LatLng(lat,lng),
                    zoom: 15
                });

                var marker = new google.maps.Marker({
                    map: map,
                    position: new google.maps.LatLng(lat,lng),
                    visible: true,
                    animation: google.maps.Animation.DROP,
                });

                var infowindow = new google.maps.InfoWindow({
                    content: "Service Location",
                });

                infowindow.open(map, marker);
            
            }

            window.setInterval(function() {
                $.ajax({
                    'url' : '<?php echo e(route("provider.incoming.request")); ?>',
                    'type' : 'GET',
                    'success' : function(return_data) {

                        if (return_data.success == true) {

                            if(return_data.data != "" && globalOnPopup == 0) {

                                if(return_data.data[0].time_left_to_respond > 0) {

                                    $('#request_user_name').text(return_data.data[0].user_name);

                                    $('#request_job_type').text("<?php echo e(tr('ondemand_request')); ?>");

                                    $('#request_category').text(return_data.data[0].category_name);

                                    $('#request_sub_category').text(return_data.data[0].sub_category_name);

                                    $('#request_title').text(return_data.data[0].name);
                                    
                                    $('#request_description').text(return_data.data[0].description);

                                    // $('#request_price').text(return_data.data[0].currency+' '+return_data.data[0].user_price+"<?php echo e(tr('per_hour_symbol')); ?>");
                                    
                                    if(return_data.data[0].user_picture != ""){
                                        
                                        var imageUrl = return_data.data[0].user_picture;

                                        $('#request_user_image').css('background-image', 'url(' + imageUrl + ')');
                                    } else {
                                        $('#request_user_image').css('background', "url(<?php echo e(asset('logo.png')); ?>)");
                                    }
                                    
                                    $('#request_time_left').text(return_data.data[0].time_left_to_respond + ' Seconds Left');

                                    $('#request_accept_url').attr('href',"<?php echo e(route('provider.request.accept')); ?>?request_id="+return_data.data[0].request_id);
                                    
                                    $('#request_decline_url').attr('href',"<?php echo e(route('provider.request.decline')); ?>?request_id="+return_data.data[0].request_id);

                                    setTimeout(function() {

                                        incomeMap(return_data.data[0].s_latitude, return_data.data[0].s_longitude);
                                    },1000);

                                    $('#incomingRequest').modal({
                                        backdrop: 'static',
                                        keyboard: false
                                    });

                                    globalOnPopup = 1;
                                    console.log('show '+globalOnPopup);
                                }
                            }

                            if(return_data.data != ""){
                                $('#request_time_left').text("Incoming Request | " + return_data.data[0].time_left_to_respond + ' Seconds Left');
                            }

                            if(globalOnPopup == 1 && return_data.data != ""){
                                if(return_data.data[0].time_left_to_respond < 0){
                                    $('#incomingRequest').modal('hide');
                                    globalOnPopup = 0; 
                                    console.log('hide '+globalOnPopup);
                                }
                            }

                            if(globalOnPopup == 1 && return_data.data == ""){
                                $('#incomingRequest').modal('hide');
                                globalOnPopup = 0; 
                                console.log('hide '+globalOnPopup);
                            }
                        }
                    }
                });

                $.ajax({
                    'url' : '<?php echo e(url("/api/provider/provider_notifications")); ?>',
                    'type' : 'post',
                    data : {id : "<?php echo e(Auth::guard('provider')->user()->id); ?>", 
                        token : "<?php echo e(Auth::guard('provider')->user()->token); ?>"},
                    'success' : function(response) {

                        if (response.cnt > 0) {
                            $('.bell_badge .cnt').show();
                       
                        } else {                            
                       
                            $('.bell_badge .cnt').hide();
                        }

                        $(".cnt").html(response.cnt);

                        // $(".new_job_badge").html(response.new_job_notify);

                        // $(".direct_job_badge").html(response.direct_job_notify);

                        $('.new_job_badge').hide();

                        $('.direct_job_badge').hide();

                        $('.bidded_job_badge').hide();

                        if (parseInt(response.new_job_notify) > 0) {

                            $('.new_job_badge').show();
 
                            $(".new_job_badge").html(response.new_job_notify);

                        }

                        if (parseInt(response.direct_job_notify) > 0) {

                            $('.direct_job_badge').show();
 
                            $(".direct_job_badge").html(response.direct_job_notify);

                        }

                        if (parseInt(response.bidded_job_notify) > 0) {

                            $(".bidded_job_badge").show();
    
                            $(".bidded_job_badge").html(response.bidded_job_notify);

                        }
                    }
                
                });
            
            }, 5000);
        
        </script>

        <?php if(Auth::guard('provider')->check()): ?> 

            <?php if(Setting::get('provider_notification_control')): ?>

                <script type="text/javascript">

                    $("#notify_click").click(function() {

                        $.ajax({
                            'url' : '<?php echo e(url("/api/provider/change_status_notifications")); ?>',
                            'type' : 'post',
                            data : {id : "<?php echo e(Auth::guard('provider')->user()->id); ?>", token : "<?php echo e(Auth::guard('provider')->user()->token); ?>"},    
                            'success' : function(response) {

                                console.log(response);

                                var list = [];

                                for(var i = 0; i < response.cnt; i++) {

                                    var obj = response.notifications[i];

                                    var ui = '<li style="border-bottom:1px solid #ddd;">'+
                                                '<a target="_blank" href="'+obj.url+'">'+
                                                    '<div style="padding: 3px 5px">'+
                                                        '<div class="col-md-2 col-sm-2 col-xs-2">'+
                                                            '<div class="incoming-img bg-img" style="background-image:url('+obj.picture+');width: 40px;height: 40px">'+
                                                            '</div>'+
                                                        '</div>'+
                                                        '<div class="col-md-8 col-sm-8 col-xs-8">'+
                                                            '<p class="notification_text">'+obj.notification+'</p>'+
                                                            '<p>'+obj.created_at+'</p>'+
                                                        '</div>'+
                                                        '<div class="clearfix"></div>'+
                                                    '</div>'+
                                                '</a>'+
                                            '</li>';

                                    list.push(ui);

                                }

                                $("#append_value").html(list);

                            }
                        
                        });

                    });

                </script>

            <?php endif; ?>


        <?php endif; ?>

        <?php echo Setting::get('google_analytics'); ?>

        <!-- <script type="text/javascript" src="<?php echo e(asset('common/js/jquery-3.3.1.slim.js')); ?>"></script> -->

        <!-- <script type="text/javascript" src="<?php echo e(asset('common/js/grid-gallery.min.js')); ?>"></script> -->

    </body>

</html>