<?php $__env->startSection('title', tr('login')); ?>

<?php $__env->startSection('content'); ?>

    <div class="login-box-body" style="height:275px">

        <form class="form-layout" role="form" method="POST" action="<?php echo e(url('/admin/login')); ?>">

            <?php echo e(csrf_field()); ?>


            <div class="login-logo">
               <!-- <a href="<?php echo e(route('admin.login')); ?>"><b><?php echo e(Setting::get('site_name')); ?></b></a> -->
            </div>

            <p class="text-center mb30"></p>

            <input type="hidden" name="timezone" id="userTimezone">

            <div class="form-inputs">
                <div class="form-group<?php echo e($errors->has('email') ? ' has-error' : ''); ?>">

                    <input type="email" class="form-control input-lg" name="email" placeholder="<?php echo e(tr('email')); ?>" value="<?php echo e(old('email') ? old('email') : Setting::get('demo_admin_email')); ?>" ">

                    <?php if($errors->has('email')): ?>
                        <span class="help-block">
                            <strong><?php echo e($errors->first('email')); ?></strong>
                        </span>
                    <?php endif; ?> 

                </div>

                <div class="form-group<?php echo e($errors->has('password') ? ' has-error' : ''); ?>">

                    <input type="password" class="form-control input-lg" name="password" placeholder="<?php echo e(tr('password')); ?>" value="<?php echo e(old('password') ? old('password') : Setting::get('demo_admin_password')); ?>" ">

                    <?php if($errors->has('password')): ?>
                        <span class="help-block">
                            <strong><?php echo e($errors->first('password')); ?></strong>
                        </span>
                    <?php endif; ?>

                </div>


            </div>

            <div class="col-md-6 col-md-offset-3">
                <button class="btn btn-success btn-block mb15" type="submit">
                    <h5><span><i class="fa fa-btn fa-sign-in"></i> <?php echo e(tr('login')); ?></span></h5>
                </button>
            </div>

            <!-- <div class="form-group">
                    <a style="margin-left:100px" class="btn btn-link" href="<?php echo e(url('/admin/password/reset')); ?>">Reset Password</a>
            </div> -->


        </form>

    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>

<script src="<?php echo e(asset('common/js/jstz.min.js')); ?>"></script>
<script>
    
    $(document).ready(function() {

        var dMin = new Date().getTimezoneOffset();
        var dtz = -(dMin/60);
        // alert(dtz);
        $("#userTimezone").val(jstz.determine().name());
    });

</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin.focused', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>