

<form class="" action="<?php echo e(Setting::get('admin_demo_control') == YES ? '#' : route('admin.providers.save')); ?>" method="POST" enctype="multipart/form-data" role="form">

    <div class="box-body">

        <input type="hidden" name="provider_id" value="<?php echo e($provider_details->id); ?>">

        <div class="row">

            <div class="col-md-6">

                <div class="form-group">
                    <label for="username"><?php echo e(tr('username')); ?> *</label>

                    <input type="text" required name="name" value="<?php echo e(old('name') ?: $provider_details->name); ?>" class="form-control" id="username" placeholder="<?php echo e(tr('username')); ?>" autofocus>
                </div>

                <div class="form-group">

                    <label for="email"><?php echo e(tr('email')); ?> *</label>

                    <input type="email" required class="form-control" value="<?php echo e(old('email') ?:   $provider_details->email); ?>" id="email" name="email" placeholder="<?php echo e(tr('email')); ?>">
                </div> 

                <div class="form-group">

                    <label for="description"><?php echo e(tr('description')); ?></label>

                    <textarea style="resize: none;" name="description" class="form-control" placeholder="<?php echo e(tr('description')); ?>"><?php echo e(old('description') ?: $provider_details->description); ?></textarea>
                    
                </div>

                <div class="form-group">

                    <label for="picture"><?php echo e(tr('picture')); ?></label>

                    <input type="file" class="form-control" id="picture" name="picture" placeholder="<?php echo e(tr('picture')); ?>" onchange="loadFile(this)" accept="image/*">
                </div>

            </div>

            <div class="col-md-6">
            
                <div class="form-group">

                    <label for="mobile"><?php echo e(tr('mobile')); ?> *</label>

                    <input type="number" required onkeypress="return isNumber(event)" minlength="6" maxlength="16" name="mobile" value="<?php echo e(old('mobile') ?: $provider_details->mobile); ?>" class="form-control" id="mobile" placeholder="<?php echo e(tr('mobile')); ?>">
                </div>   

                <?php if(!$provider_details->id != ''): ?>
                <div class="form-group">

                    <label for="password"><?php echo e(tr('password')); ?><span> *</span></label>

                    <input type="password" required name="password" class="form-control" id="password" placeholder="<?php echo e(tr('password')); ?>">

                </div>

                <div class="form-group">
                    
                    <label for="confirm-password"><?php echo e(tr('confirm_password')); ?><span> *</span></label>

                    <input type="password" required name="password_confirmation" class="form-control" id="confirm-password" placeholder="<?php echo e(tr('confirm_password')); ?>">

                </div>

                <?php endif; ?>

                <div class="form-group">

                    <label for="video"><?php echo e(tr('video')); ?></label>

                    <input type="file" class="form-control" id="video" accept="video/*" name="video" placeholder="<?php echo e(tr('video')); ?>">
                </div>

            </div>
            
        </div>

        <div class="clearfix"></div>                        

    </div>

    <div class="box-footer">
        <button type="reset" class="btn btn-danger"><?php echo e(tr('reset')); ?></button>
        <?php if(Setting::get('admin_demo_control')): ?>
        <button type="button" class="btn btn-success pull-right" disabled><?php echo e(tr('submit')); ?></button>
        <?php else: ?>
        <button type="submit" class="btn btn-success pull-right"><?php echo e(tr('submit')); ?></button>
        <?php endif; ?>
    </div>

</form>