 <form action="<?php echo e(route('admin.sub_categories.save')); ?>" method="POST" enctype="multipart/form-data" role="form">

    <input type="hidden" name="sub_category_id" value="<?php echo e($sub_category_details->id); ?>">

    <div class="box-body">

        <div class="form-group">

            <label><?php echo e(tr('select_category')); ?> * </label>
            
            <select name="category_id" required class="form-control select2" autofocus>

                <option value=""><?php echo e(tr('select_category')); ?> </option>

                <?php foreach($categories as $category): ?>

                    <?php if( $sub_category_details->category_id == $category->category_id): ?>
                        <option value="<?php echo e($category->category_id); ?>" selected><?php echo e($category->category_name); ?></option>
                    <?php else: ?>
                        <option value="<?php echo e($category->category_id); ?>"><?php echo e($category->category_name); ?></option>
                    <?php endif; ?>

                <?php endforeach; ?>

            </select>                           
            
        </div>

        <div class="form-group">
            <label for="sub_categoryname"><?php echo e(tr('name')); ?> * </label>

            <input type="text" required name="name" class="form-control" id="sub_categoryname" value="<?php echo e(old('name') ?: $sub_category_details->name); ?>" placeholder="<?php echo e(tr('sub_category_name')); ?>">
        </div>

        <div class="form-group">

            <label for="price"><?php echo e(tr('price')); ?> * </label>

            <input type="number" step="any" min="1" title="This must be a number with up to 2 decimal places and/or %" required name="price" class="form-control" id="price" value="<?php echo e(old('price') ?: $sub_category_details->price); ?>" placeholder="<?php echo e(tr('price_per_hour')); ?>" onkeypress="return isNumber(event)">

        </div>

        <div class="form-group">
            <label for="email"><?php echo e(tr('description')); ?> * </label>
            <input type="text" required class="form-control" id="description" name="description" value="<?php echo e(old('description') ?: $sub_category_details->description); ?>" placeholder="<?php echo e(tr('description')); ?>">
        </div>

        <div class="form-group">
            
            <label for="picture"><?php echo e(tr('picture')); ?> * </label>
            
            <input type="file" class="form-control" name="picture" id="picture" accept="image/png,image/jpeg" onchange="loadFile(this,'image_preview')" accept="image/*">
            
            <br>
            
            <?php if( $sub_category_details->id != '' ): ?>
                <img id="image_preview" style="height: 90px; margin-bottom: 15px; border-radius:2em;" src="<?php echo e($sub_category_details->picture); ?>">
            <?php endif; ?>

        </div>
    
    </div>

    <div class="box-footer">
    
        <button type="reset" class="btn btn-danger"><?php echo e(tr('reset')); ?></button>
        <?php if(Setting::get('admin_demo_control')): ?>
        <button type="button" class="btn btn-success pull-right" disabled><?php echo e(tr('submit')); ?></button>
        <?php else: ?>
        <button type="submit" class="btn btn-success pull-right"><?php echo e(tr('submit')); ?></button>
        <?php endif; ?>

    </div>

</form>