

<form class="" action="<?php echo e(Setting::get('admin_demo_control') == YES ? '#' : route('admin.users.save')); ?>" method="POST" enctype="multipart/form-data" role="form">

    <div class="box-body">

        <div class="row">

            <div class="col-md-6">

                <input type="hidden" name="user_id" value="<?php echo e($user_details->id); ?>">

                <?php if(!$user_details->id): ?>

                    <input type="hidden" name="login_by" value="manual">

                    <input type="hidden" name="device_type" value="web">

                <?php endif; ?>

                <div class="form-group">

                    <label for="username"><?php echo e(tr('username')); ?> *</label>

                    <input type="text" required name="name" value="<?php echo e(old('name') ?: $user_details->name); ?>" class="form-control" id="username" placeholder="<?php echo e(tr('username')); ?>" onkeydown="return alphaOnly(event);" autofocus>   

                </div>

                <div class="form-group">

                    <label for="email"><?php echo e(tr('email')); ?> *</label>
                    <input type="email" required class="form-control" value="<?php echo e(old('email') ?: $user_details->email); ?>" id="email" name="email" placeholder="<?php echo e(tr('email')); ?>">
        
                </div>

                <div class="form-group">

                    <label for="description"><?php echo e(tr('description')); ?></label>

                    <textarea rows="5" class="form-control" name="description" id="description" placeholder="<?php echo e(tr('description')); ?>"><?php echo e(old('description') ?: $user_details->description); ?></textarea>                        
                </div>

            </div>

            <div class="col-md-6">

                <div class="form-group">

                    <label for="mobile"><?php echo e(tr('mobile')); ?> *</label>

                    <input type="number" onkeypress="return isNumber(event)" minlength="4" maxlength="16" pattern="[0-9]{4,16}" required name="mobile" value="<?php echo e(old('mobile') ?: $user_details->mobile); ?>" class="form-control" id="mobile" placeholder="<?php echo e(tr('mobile')); ?>">

                </div>

                <?php if(!$user_details->id): ?>
                
                    <div class="form-group">
                        <label for="password" class=""><?php echo e(tr('password')); ?> *</label>

                        <input type="password" minlength="6" required name="password" class="form-control" id="password" placeholder="<?php echo e(tr('password')); ?>" accept="image/image/jpeg">
                    </div>

                    <div class="form-group">
                        
                        <label for="confirm-password" class=""><?php echo e(tr('confirm_password')); ?> *</label>

                        <input type="password" minlength="6" required name="password_confirmation" class="form-control" id="confirm-password" placeholder="<?php echo e(tr('confirm_password')); ?>">
                    </div>

                <?php endif; ?>

                <div class="form-group">

                    <label for="picture"><?php echo e(tr('picture')); ?></label>
                    
                    <input type="file" name="picture" class="form-control" id="picture" placeholder="<?php echo e(tr('picture')); ?>" onchange="loadFile(this)" accept="image/*">
        
                </div>               

            </div>

        </div>

    </div>

    <div class="box-footer">

        <button type="reset" class="btn btn-danger"><?php echo e(tr('reset')); ?></button>
        <?php if(Setting::get('admin_demo_control')): ?>
        <button type="button" class="btn btn-success pull-right" disabled><?php echo e(tr('submit')); ?></button>
        <?php else: ?>
        <button type="submit" class="btn btn-success pull-right"><?php echo e(tr('submit')); ?></button>
        <?php endif; ?>

    </div>

</form>